/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.notification;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.eventd.EventIpcManagerFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateNotifdStatusServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateNotifdStatusServlet.class);
    private static final long serialVersionUID = -841122529212545321L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            LOG.info("Setting notifd status to {} for user {}", (Object)request.getParameter("status"), (Object)request.getRemoteUser());
            if (request.getParameter("status").equals("on")) {
                NotifdConfigFactory.getInstance().turnNotifdOn();
                this.sendEvent("uei.opennms.org/internal/notificationsTurnedOn", request);
            } else {
                NotifdConfigFactory.getInstance().turnNotifdOff();
                this.sendEvent("uei.opennms.org/internal/notificationsTurnedOff", request);
            }
        }
        catch (Throwable e) {
            throw new ServletException("Could not update notification status: " + e.getMessage(), e);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/index.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void sendEvent(String uei, HttpServletRequest request) {
        EventBuilder bldr = new EventBuilder(uei, "NotifdConfigFactory");
        bldr.addParam("remoteUser", request.getRemoteUser());
        bldr.addParam("remoteHost", request.getRemoteHost());
        bldr.addParam("remoteAddr", request.getRemoteAddr());
        try {
            EventIpcManagerFactory.getIpcManager().sendNow(bldr.getEvent());
        }
        catch (Throwable t) {
            // empty catch block
        }
    }
}

