/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.discovery;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyDiscoveryConfigurationServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyDiscoveryConfigurationServlet.class);
    private static final long serialVersionUID = -3782436743630940629L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.info("Loading Discovery configuration.");
        DiscoveryConfiguration config = ModifyDiscoveryConfigurationServlet.getDiscoveryConfig();
        HttpSession sess = request.getSession();
        sess.setAttribute("discoveryConfiguration", (Object)config);
        response.sendRedirect("edit-config.jsp");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public static DiscoveryConfiguration getDiscoveryConfig() throws ServletException {
        DiscoveryConfiguration config = null;
        try {
            DiscoveryConfigFactory.reload();
            config = DiscoveryConfigFactory.getInstance().getConfiguration();
        }
        catch (Exception e) {
            throw new ServletException("Could not load configuration: " + e.getMessage(), (Throwable)e);
        }
        return config;
    }
}

