/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.server;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.dashboard.client.SurveillanceGroup;
import org.opennms.dashboard.client.Visitor;
import org.opennms.netmgt.config.surveillanceViews.Category;
import org.opennms.netmgt.config.surveillanceViews.ColumnDef;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CriteriaAddingVisitor
implements Visitor,
InitializingBean {
    private OnmsCriteria m_criteria;
    private CategoryDao m_categoryDao;
    private View m_view;
    private SurveillanceView m_survView;

    public CriteriaAddingVisitor(OnmsCriteria criteria) {
        this.m_criteria = criteria;
    }

    @Override
    public void visitAll() {
        this.addCriteriaForCategories(this.m_criteria, this.m_survView.getColumnCategories());
        this.addCriteriaForCategories(this.m_criteria, this.m_survView.getRowCategories());
    }

    @Override
    public void visitGroup(SurveillanceGroup group) {
        if (group.isColumn()) {
            this.addCriteriaForCategories(this.m_criteria, this.m_survView.getRowCategories());
            this.addCriteriaForCategories(this.m_criteria, this.m_survView.getCategoriesForColumn(group.getId()));
        } else {
            this.addCriteriaForCategories(this.m_criteria, this.m_survView.getColumnCategories());
            this.addCriteriaForCategories(this.m_criteria, this.m_survView.getCategoriesForRow(group.getId()));
        }
    }

    @Override
    public void visitIntersection(SurveillanceGroup row, SurveillanceGroup column) {
        this.addCriteriaForCategories(this.m_criteria, this.m_survView.getCategoriesForRow(row.getId()));
        this.addCriteriaForCategories(this.m_criteria, this.m_survView.getCategoriesForColumn(column.getId()));
    }

    public void addCriteriaForCategories(OnmsCriteria criteria, Set<String> categories) {
        String[] categoryNames = categories.toArray(new String[categories.size()]);
        this.addCriteriaForCategories(criteria, categoryNames);
    }

    public void addCriteriaForCategories(OnmsCriteria criteria, String ... categories) {
        String sql = "{alias}.nodeId in (select distinct cn.nodeId from category_node cn join categories c on cn.categoryId = c.categoryId where c.categoryName in (" + this.commaDelimitedQuestionMarks(categories.length) + "))";
        criteria.add(Restrictions.sqlRestriction((String)sql, (Object[])categories, (Type[])this.arrayOfType(categories.length, (Type)new StringType())));
    }

    public View getView() {
        return this.m_view;
    }

    public void setView(View view) {
        this.m_view = view;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_view != null ? 1 : 0) != 0, (String)"view property must be set");
        Assert.state((this.m_categoryDao != null ? 1 : 0) != 0, (String)"categoryDao property must be set");
        this.m_survView = new SurveillanceView();
        this.m_survView.setName(this.m_view.getName());
        for (ColumnDef columnDef : this.m_view.getColumns().getColumnDef()) {
            for (Category category : columnDef.getCategory()) {
                this.m_survView.addColumnCategory(columnDef.getLabel(), category.getName());
            }
        }
        for (ColumnDef columnDef : this.m_view.getRows().getRowDef()) {
            for (Category category : columnDef.getCategory()) {
                this.m_survView.addRowCategory(columnDef.getLabel(), category.getName());
            }
        }
    }

    private Type[] arrayOfType(int length, Type initialVal) {
        Type[] array = new Type[length];
        for (int i = 0; i < length; ++i) {
            array[i] = initialVal;
        }
        return array;
    }

    public String commaDelimitedQuestionMarks(int count) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append('?');
        }
        return buf.toString();
    }

    private static class MapToSetOf<K, V> {
        private Map<K, Set<V>> m_map = new LinkedHashMap<K, Set<V>>();

        private MapToSetOf() {
        }

        public void addValue(K key, V value) {
            if (!this.m_map.containsKey(key)) {
                this.m_map.put(key, new LinkedHashSet());
            }
            this.m_map.get(key).add(value);
        }

        public Set<V> getValuesForKeys(Collection<? extends K> keys) {
            LinkedHashSet values = new LinkedHashSet();
            for (K key : keys) {
                values.addAll(this.m_map.get(key));
            }
            return values;
        }

        public Set<V> getAllValues() {
            return this.getValuesForKeys(this.m_map.keySet());
        }

        public Set<V> getValueForKey(K key) {
            return this.getValuesForKeys(Collections.singleton(key));
        }
    }

    private static class SurveillanceView {
        private String m_name;
        private MapToSetOf<String, String> m_columns = new MapToSetOf();
        private MapToSetOf<String, String> m_rows = new MapToSetOf();

        private SurveillanceView() {
        }

        public void setName(String name) {
            this.m_name = name;
        }

        public String getName() {
            return this.m_name;
        }

        public void addColumnCategory(String column, String category) {
            this.m_columns.addValue(column, category);
        }

        public void addRowCategory(String row, String category) {
            this.m_rows.addValue(row, category);
        }

        public Set<String> getCategoriesForRow(String row) {
            return this.m_rows.getValueForKey(row);
        }

        public Set<String> getCategoriesForColumn(String column) {
            return this.m_columns.getValueForKey(column);
        }

        public Set<String> getRowCategories() {
            return this.m_rows.getAllValues();
        }

        public Set<String> getColumnCategories() {
            return this.m_columns.getAllValues();
        }

        public Set<String> getCategoriesForColumns(Collection<? extends String> columns) {
            return this.m_columns.getValuesForKeys(columns);
        }

        public Set<String> getCategoriesForRows(Collection<? extends String> rows) {
            return this.m_rows.getValuesForKeys(rows);
        }
    }
}

