/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.opennms.netmgt.config.surveillanceViews.Columns;
import org.opennms.netmgt.config.surveillanceViews.Rows;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.opennms.netmgt.dao.CategoryDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.SurveillanceViewConfigDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.web.svclayer.support.DefaultSurveillanceService;

public class DefaultSurveillanceServiceTest {
    private EasyMockUtils m_mockUtils;
    private NodeDao m_nodeDao;
    private CategoryDao m_categoryDao;
    private SurveillanceViewConfigDao m_surveillanceViewConfigDao;

    @Before
    public void setUp() throws Exception {
        this.m_mockUtils = new EasyMockUtils();
        this.m_nodeDao = (NodeDao)this.m_mockUtils.createMock(NodeDao.class);
        this.m_categoryDao = (CategoryDao)this.m_mockUtils.createMock(CategoryDao.class);
        this.m_surveillanceViewConfigDao = (SurveillanceViewConfigDao)this.m_mockUtils.createMock(SurveillanceViewConfigDao.class);
    }

    @Test
    public void testCreateSurveillanceTable() {
        View view = new View();
        Rows rows = new Rows();
        view.setRows(rows);
        Columns columns = new Columns();
        view.setColumns(columns);
        EasyMock.expect((Object)this.m_surveillanceViewConfigDao.getView((String)EasyMock.eq((Object)"default"))).andReturn((Object)view).atLeastOnce();
        this.m_mockUtils.replayAll();
        DefaultSurveillanceService surveillanceSvc = new DefaultSurveillanceService();
        surveillanceSvc.setNodeDao(this.m_nodeDao);
        surveillanceSvc.setCategoryDao(this.m_categoryDao);
        surveillanceSvc.setSurveillanceConfigDao(this.m_surveillanceViewConfigDao);
        surveillanceSvc.createSurveillanceTable();
        this.m_mockUtils.verifyAll();
    }

    public Collection<OnmsCategory> createCategories(List<String> catNames) {
        Collection<OnmsCategory> categories = this.createCategoryNameCollection(catNames);
        return categories;
    }

    private Collection<OnmsCategory> createCategoryNameCollection(List<String> categoryNames) {
        ArrayList<OnmsCategory> categories = new ArrayList<OnmsCategory>();
        for (String catName : categoryNames) {
            categories.add(this.m_categoryDao.findByName(catName));
        }
        return categories;
    }

    @Test
    public void testUrlMaker() {
        System.err.println(this.createNodePageUrl("1 of 10"));
    }

    private String createNodePageUrl(String label) {
        OnmsNode m_foundDownNode = new OnmsNode();
        m_foundDownNode.setId(Integer.valueOf(1));
        if (m_foundDownNode != null) {
            label = "<a href=\"element/node.jsp?node=" + m_foundDownNode.getId() + "\">" + label + "</a>";
        }
        return label;
    }
}

