/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import junit.framework.TestCase;
import org.opennms.netmgt.dao.GraphDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.RrdDao;
import org.opennms.test.FileAnticipator;
import org.opennms.test.ThrowableAnticipator;
import org.opennms.test.mock.EasyMockUtils;
import org.opennms.web.svclayer.support.DefaultRrdGraphService;

public class DefaultRrdGraphServiceTest
extends TestCase {
    private EasyMockUtils m_mockUtils;
    private FileAnticipator m_fileAnticipator;
    private DefaultRrdGraphService m_service;
    private ResourceDao m_resourceDao;
    private GraphDao m_graphDao;
    private RrdDao m_rrdDao;

    protected void setUp() throws Exception {
        super.setUp();
        this.m_mockUtils = new EasyMockUtils();
        this.m_fileAnticipator = new FileAnticipator(false);
        this.m_service = new DefaultRrdGraphService();
    }

    protected void tearDown() throws Exception {
        this.m_fileAnticipator.tearDown();
    }

    public void testAfterPropertiesSet() {
        this.setUpAll();
    }

    public void testNoResourceDao() throws Exception {
        this.setUpGraphDao();
        this.setUpRrdDao();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("resourceDao property has not been set"));
        this.m_mockUtils.replayAll();
        try {
            this.m_service.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.m_mockUtils.verifyAll();
    }

    public void testNoGraphDao() {
        this.setUpResourceDao();
        this.setUpRrdDao();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("graphDao property has not been set"));
        this.m_mockUtils.replayAll();
        try {
            this.m_service.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.m_mockUtils.verifyAll();
    }

    public void testNoRrdDao() {
        this.setUpResourceDao();
        this.setUpGraphDao();
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalStateException("rrdDao property has not been set"));
        this.m_mockUtils.replayAll();
        try {
            this.m_service.afterPropertiesSet();
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
        this.m_mockUtils.verifyAll();
    }

    private void setUpAll() {
        this.setUpResourceDao();
        this.setUpGraphDao();
        this.setUpRrdDao();
        this.m_service.afterPropertiesSet();
    }

    private void setUpResourceDao() {
        this.m_resourceDao = (ResourceDao)this.m_mockUtils.createMock(ResourceDao.class);
        this.m_service.setResourceDao(this.m_resourceDao);
    }

    private void setUpGraphDao() {
        this.m_graphDao = (GraphDao)this.m_mockUtils.createMock(GraphDao.class);
        this.m_service.setGraphDao(this.m_graphDao);
    }

    private void setUpRrdDao() {
        this.m_rrdDao = (RrdDao)this.m_mockUtils.createMock(RrdDao.class);
        this.m_service.setRrdDao(this.m_rrdDao);
    }
}

