/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.Collection;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.opennms.core.test.ConfigurationTestUtils;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.MockForeignSourceRepository;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.web.svclayer.support.DefaultManualProvisioningService;
import org.opennms.web.svclayer.support.PropertyUtils;

public class DefaultManualProvisioningServiceTest
extends TestCase {
    private DefaultManualProvisioningService m_provisioningService;
    private Requisition m_testData;
    private ForeignSourceRepository m_activeRepository = new MockForeignSourceRepository();
    private ForeignSourceRepository m_pendingRepository = new MockForeignSourceRepository();

    protected void setUp() throws Exception {
        this.m_testData = this.m_activeRepository.importResourceRequisition(ConfigurationTestUtils.getSpringResourceForResource((Object)((Object)this), (String)"/tec_dump.xml"));
        this.m_provisioningService = new DefaultManualProvisioningService();
        this.m_provisioningService.setDeployedForeignSourceRepository(this.m_activeRepository);
        this.m_provisioningService.setPendingForeignSourceRepository(this.m_pendingRepository);
    }

    public void testGetProvisioningGroupNames() {
        TreeSet<String> expected = new TreeSet<String>();
        expected.add("matt:");
        Collection groupNames = this.m_provisioningService.getProvisioningGroupNames();
        DefaultManualProvisioningServiceTest.assertEquals(expected, (Object)groupNames);
    }

    public void testGetProvisioningGroup() {
        String name = "matt:";
        Requisition expected = this.m_testData;
        Requisition actual = this.m_provisioningService.getProvisioningGroup(name);
        DefaultManualProvisioningServiceTest.assertEquals((Object)expected, (Object)actual);
    }

    public void testAddNewNodeToGroup() {
        String groupName = "matt:";
        String nodeLabel = "david";
        int initialCount = this.m_testData.getNodes().size();
        Requisition result = this.m_provisioningService.addNewNodeToGroup(groupName, nodeLabel);
        int newCount = result.getNodes().size();
        DefaultManualProvisioningServiceTest.assertEquals((int)(initialCount + 1), (int)newCount);
        DefaultManualProvisioningServiceTest.assertEquals((String)nodeLabel, (String)((RequisitionNode)result.getNodes().get(0)).getNodeLabel());
    }

    public void testAddCategoryToNode() {
        String groupName = "matt:";
        String pathToNode = "node[0]";
        String categoryName = "categoryName";
        int initialCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToNode + ".categoryCount"), Integer.TYPE);
        Requisition result = this.m_provisioningService.addCategoryToNode(groupName, pathToNode, categoryName);
        int newCount = (Integer)PropertyUtils.getPathValue((Object)result, (String)(pathToNode + ".categoryCount"), Integer.TYPE);
        DefaultManualProvisioningServiceTest.assertEquals((int)(initialCount + 1), (int)newCount);
        RequisitionCategory newCategory = (RequisitionCategory)PropertyUtils.getPathValue((Object)result, (String)(pathToNode + ".category[0]"), RequisitionCategory.class);
        DefaultManualProvisioningServiceTest.assertNotNull((Object)newCategory);
        DefaultManualProvisioningServiceTest.assertEquals((String)categoryName, (String)newCategory.getName());
    }

    public void testAddInterfaceToNode() {
        String groupName = "matt:";
        String pathToNode = "node[0]";
        String ipAddr = "10.1.1.1";
        int initialCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToNode + ".interfaceCount"), Integer.TYPE);
        Requisition result = this.m_provisioningService.addInterfaceToNode(groupName, pathToNode, ipAddr);
        int newCount = (Integer)PropertyUtils.getPathValue((Object)result, (String)(pathToNode + ".interfaceCount"), Integer.TYPE);
        DefaultManualProvisioningServiceTest.assertEquals((int)(initialCount + 1), (int)newCount);
        RequisitionInterface newIface = (RequisitionInterface)PropertyUtils.getPathValue((Object)result, (String)(pathToNode + ".interface[0]"), RequisitionInterface.class);
        DefaultManualProvisioningServiceTest.assertNotNull((Object)newIface);
        DefaultManualProvisioningServiceTest.assertEquals((String)ipAddr, (String)newIface.getIpAddr());
    }

    public void testAddServiceToInterface() {
        String groupName = "matt:";
        String pathToInterface = "node[0].interface[0]";
        String serviceName = "SVC";
        int initialCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToInterface + ".monitoredServiceCount"), Integer.TYPE);
        Requisition result = this.m_provisioningService.addServiceToInterface(groupName, pathToInterface, serviceName);
        int newCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToInterface + ".monitoredServiceCount"), Integer.TYPE);
        DefaultManualProvisioningServiceTest.assertEquals((int)(initialCount + 1), (int)newCount);
        RequisitionMonitoredService svc = (RequisitionMonitoredService)PropertyUtils.getPathValue((Object)result, (String)(pathToInterface + ".monitoredService[0]"), RequisitionMonitoredService.class);
        DefaultManualProvisioningServiceTest.assertNotNull((Object)svc);
        DefaultManualProvisioningServiceTest.assertEquals((String)serviceName, (String)svc.getServiceName());
    }

    public void testDeletePath() {
        String groupName = "matt:";
        String pathToInterface = "node[0].interface[0]";
        String pathToDelete = pathToInterface + ".monitoredService[0]";
        int initialCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToInterface + ".monitoredServiceCount"), Integer.TYPE);
        String svcName = (String)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToDelete + ".serviceName"), String.class);
        Requisition result = this.m_provisioningService.deletePath(groupName, pathToDelete);
        int newCount = (Integer)PropertyUtils.getPathValue((Object)this.m_testData, (String)(pathToInterface + ".monitoredServiceCount"), Integer.TYPE);
        DefaultManualProvisioningServiceTest.assertEquals((int)(initialCount - 1), (int)newCount);
        RequisitionMonitoredService svc = (RequisitionMonitoredService)PropertyUtils.getPathValue((Object)result, (String)(pathToInterface + ".monitoredService[0]"), RequisitionMonitoredService.class);
        DefaultManualProvisioningServiceTest.assertNotNull((Object)svc);
        DefaultManualProvisioningServiceTest.assertFalse((boolean)svc.getServiceName().equals(svcName));
    }
}

