/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.daemonstatus.support;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.dao.DaemonStatusDao;
import org.opennms.netmgt.dao.ServiceInfo;
import org.opennms.netmgt.model.MockServiceDaemon;
import org.opennms.web.svclayer.daemonstatus.support.DefaultDaemonStatusService;

public class DefaultDaemonStatusServiceTest
extends TestCase {
    private DefaultDaemonStatusService defaultDaemonStatusService;
    private DaemonStatusDao daemonStatusDao;

    protected void setUp() throws Exception {
        super.setUp();
        this.daemonStatusDao = (DaemonStatusDao)EasyMock.createMock(DaemonStatusDao.class);
        this.defaultDaemonStatusService = new DefaultDaemonStatusService();
        this.defaultDaemonStatusService.setDaemonStatusDao(this.daemonStatusDao);
    }

    public List<ServiceInfo> testGetCurrentDaemonStatusNotEmpty() {
        return null;
    }

    public List<ServiceInfo> testGetCurrentDaemonStatusEmpty() {
        return null;
    }

    public void testStartDaemon() {
        HashMap<String, ServiceInfo> info2Return = new HashMap<String, ServiceInfo>();
        ServiceInfo sinfo1 = new ServiceInfo("ignore", "failed");
        info2Return.put("notifd", sinfo1);
        ServiceInfo sinfo2 = new ServiceInfo("notifd", "Started");
        info2Return.put("notifd", sinfo2);
        MockServiceDaemon dstub = new MockServiceDaemon("notifd");
        EasyMock.expect((Object)this.daemonStatusDao.getServiceHandle("notifd")).andReturn((Object)dstub);
        EasyMock.expect((Object)this.daemonStatusDao.getCurrentDaemonStatus()).andReturn(info2Return);
        EasyMock.replay((Object[])new Object[]{this.daemonStatusDao});
        Map listServiceInfo = this.defaultDaemonStatusService.startDaemon("notifd");
        String status = ((ServiceInfo)listServiceInfo.get("notifd")).getServiceStatus();
        EasyMock.verify((Object[])new Object[]{this.daemonStatusDao});
        DefaultDaemonStatusServiceTest.assertTrue((String)"Service not started", (boolean)dstub.getStartCalled());
        DefaultDaemonStatusServiceTest.assertEquals((String)"status must be 'Started'", (String)"Started", (String)status);
    }

    public void testStopDaemon() {
    }

    public void testRestartDaemon() {
    }

    public void testPerformOperationOnDaemonsEmptySetOfDaemons() {
    }

    public void testPerformOperationOnDaemonsNonEmptySetOfDaemons() {
    }

    public void testPerformOperationOnDaemonsNonEmptySetOfDaemonsInvalidOperation() {
    }
}

