/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.rest.AbstractSpringJerseyRestTestCase;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class IPhoneRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    private EventDao m_eventDao;
    private DistPollerDao m_distPollerDao;

    @Override
    protected void afterServletStart() throws Exception {
        WebApplicationContext context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        DatabasePopulator dbp = (DatabasePopulator)context.getBean("databasePopulator", DatabasePopulator.class);
        dbp.populateDatabase();
        this.m_distPollerDao = (DistPollerDao)context.getBean("distPollerDao", DistPollerDao.class);
        this.m_eventDao = (EventDao)context.getBean("eventDao", EventDao.class);
    }

    @Test
    public void testAcknowlegement() throws Exception {
        Pattern p = Pattern.compile("^.*<ackTime>(.*?)</ackTime>.*$", 0);
        this.sendData(POST, "application/x-www-form-urlencoded", "/acks", "alarmId=1&action=ack");
        String xml = this.sendRequest(GET, "/alarms/1", new HashMap(), 200);
        Matcher m = p.matcher(xml);
        Assert.assertTrue((boolean)m.matches());
        Assert.assertTrue((m.group(1).length() > 0 ? 1 : 0) != 0);
        this.sendData(POST, "application/x-www-form-urlencoded", "/acks", "alarmId=1&action=unack");
        xml = this.sendRequest(GET, "/alarms/1", new HashMap(), 200);
        m = p.matcher(xml);
        Assert.assertFalse((boolean)m.matches());
    }

    @Test
    public void testAlarms() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("orderBy", "lastEventTime");
        parameters.put("order", "desc");
        parameters.put("alarmAckUser", "null");
        parameters.put("limit", "1");
        String xml = this.sendRequest(GET, "/alarms", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        xml = this.sendRequest(GET, "/alarms/1", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("This is a test alarm"));
        Assert.assertTrue((boolean)xml.contains("<nodeLabel>node1</nodeLabel>"));
    }

    @Test
    public void testEvents() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        String xml = this.sendRequest(GET, "/events", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("uei.opennms.org/test"));
        parameters.put("orderBy", "lastEventTime");
        parameters.put("order", "desc");
        parameters.put("limit", "1");
        xml = this.sendRequest(GET, "/events/1", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("uei.opennms.org/test"));
    }

    @Test
    public void testNodes() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("comparator", "ilike");
        parameters.put("match", "any");
        parameters.put("label", "1%");
        parameters.put("ipInterface.ipAddress", "1%");
        parameters.put("ipInterface.ipHostName", "1%");
        String xml = this.sendRequest(GET, "/nodes", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("<node "));
        Assert.assertTrue((boolean)xml.contains("label=\"node1\""));
        parameters.clear();
        parameters.put("comparator", "ilike");
        parameters.put("match", "any");
        parameters.put("label", "8%");
        parameters.put("ipInterface.ipAddress", "8%");
        parameters.put("ipInterface.ipHostName", "8%");
        xml = this.sendRequest(GET, "/nodes", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("totalCount=\"0\""));
        parameters.clear();
        parameters.put("limit", "50");
        parameters.put("orderBy", "ifLostService");
        parameters.put("order", "desc");
        xml = this.sendRequest(GET, "/outages/forNode/1", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("SNMP"));
        parameters.clear();
        parameters.put("orderBy", new String[]{"ipHostName", "ipAddress"});
        xml = this.sendRequest(GET, "/nodes/1/ipinterfaces", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("192.168.1.1"));
        parameters.clear();
        parameters.put("orderBy", new String[]{"ifName", "ipAddress", "ifDesc"});
        xml = this.sendRequest(GET, "/nodes/1/snmpinterfaces", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("Initial ifAlias value"));
        parameters.clear();
        parameters.put("limit", "50");
        parameters.put("node.id", "1");
        xml = this.sendRequest(GET, "/events", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("totalCount=\"0\""));
    }

    @Test
    public void testSnmpInterfacesForNodeId() throws Exception {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        parameters.put("orderBy", new String[]{"ifName", "ipAddress", "ifDesc"});
        String xml = this.sendRequest(GET, "/nodes/1/snmpinterfaces", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("Initial ifAlias value"));
    }

    @Test
    public void testEventsForNodeId() throws Exception {
        OnmsNode node = new OnmsNode();
        node.setId(Integer.valueOf(1));
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller((OnmsDistPoller)this.m_distPollerDao.get((Serializable)((Object)"localhost")));
        event.setEventUei("uei.opennms.org/test");
        event.setEventTime(new Date());
        event.setEventSource("test");
        event.setEventCreateTime(new Date());
        event.setEventSeverity(Integer.valueOf(1));
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setNode(node);
        this.m_eventDao.save((Object)event);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("limit", "50");
        parameters.put("node.id", "1");
        String xml = this.sendRequest(GET, "/events", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("totalCount=\"1\""));
        Assert.assertTrue((boolean)xml.contains("uei.opennms.org/test"));
    }

    @Test
    public void testOutages() throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("orderBy", "ifLostService");
        parameters.put("order", "desc");
        parameters.put("ifRegainedService", "null");
        String xml = this.sendRequest(GET, "/outages", parameters, 200);
        Assert.assertTrue((boolean)xml.contains("count=\"1\""));
        Assert.assertTrue((boolean)xml.contains("id=\"2\""));
        Assert.assertTrue((boolean)xml.contains("192.168.1.1"));
        Assert.assertFalse((boolean)xml.contains("<ipAddress/>"));
    }
}

