/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.xml.XmlTest;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.rest.AbstractSpringJerseyRestTestCase;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AlarmStatsRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    private DatabasePopulator m_databasePopulator;
    private WebApplicationContext m_context;
    private int count = 0;

    @Override
    protected void afterServletStart() throws Exception {
        this.count = 0;
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        this.m_context = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.m_databasePopulator = (DatabasePopulator)this.m_context.getBean("databasePopulator", DatabasePopulator.class);
        this.m_databasePopulator.populateDatabase();
        EventDao eventDao = this.getEventDao();
        for (OnmsEvent event : eventDao.findAll()) {
            eventDao.delete((Object)event);
        }
        eventDao.flush();
        AlarmDao alarmDao = this.getAlarmDao();
        for (OnmsAlarm alarm : alarmDao.findAll()) {
            alarmDao.delete((Object)alarm);
        }
        alarmDao.flush();
    }

    @Test
    public void testGetAlarmStats() throws Exception {
        this.createAlarm(OnmsSeverity.CLEARED, "admin");
        this.createAlarm(OnmsSeverity.MAJOR, "admin");
        this.createAlarm(OnmsSeverity.CRITICAL, "admin");
        this.createAlarm(OnmsSeverity.CRITICAL, null);
        this.createAlarm(OnmsSeverity.MINOR, null);
        this.createAlarm(OnmsSeverity.NORMAL, null);
        String xml = this.sendRequest(GET, "/stats/alarms", 200);
        Assert.assertTrue((boolean)xml.contains(" totalCount=\"6\""));
        Assert.assertTrue((boolean)xml.contains(" unacknowledgedCount=\"3\""));
        Assert.assertTrue((boolean)xml.contains(" acknowledgedCount=\"3\""));
    }

    @Test
    public void testGetAlarmStatsBySeverity() throws Exception {
        this.createAlarm(OnmsSeverity.CLEARED, "admin");
        this.createAlarm(OnmsSeverity.MAJOR, "admin");
        this.createAlarm(OnmsSeverity.CRITICAL, "admin");
        this.createAlarm(OnmsSeverity.CRITICAL, null);
        this.createAlarm(OnmsSeverity.MINOR, null);
        this.createAlarm(OnmsSeverity.NORMAL, null);
        String xml = this.sendRequest(GET, "/stats/alarms", AlarmStatsRestServiceTest.parseParamData("comparator=ge&severity=MAJOR"), 200);
        Assert.assertTrue((boolean)xml.contains(" totalCount=\"3\""));
        Assert.assertTrue((boolean)xml.contains(" unacknowledgedCount=\"1\""));
        Assert.assertTrue((boolean)xml.contains(" acknowledgedCount=\"2\""));
    }

    @Test
    public void testNewestAndOldestBySeverity() throws Exception {
        OnmsAlarm oldestAckedAlarm = this.createAlarm(OnmsSeverity.WARNING, "admin");
        OnmsAlarm newestAckedAlarm = this.createAlarm(OnmsSeverity.WARNING, "admin");
        OnmsAlarm oldestUnackedAlarm = this.createAlarm(OnmsSeverity.WARNING, null);
        OnmsAlarm newestUnackedAlarm = this.createAlarm(OnmsSeverity.WARNING, null);
        String xml = this.sendRequest(GET, "/stats/alarms/by-severity", 200);
        String oldestAckedXml = this.getXml("oldestAcked", xml);
        String newestAckedXml = this.getXml("newestAcked", xml);
        String oldestUnackedXml = this.getXml("oldestUnacked", xml);
        String newestUnackedXml = this.getXml("newestUnacked", xml);
        XmlTest.assertXpathMatches((String)("should contain WARNING with ID#" + oldestAckedAlarm.getId()), (String)oldestAckedXml, (String)("//alarm[@severity='WARNING' and @id='" + oldestAckedAlarm.getId() + "']"));
        Assert.assertTrue((boolean)oldestAckedXml.contains("<firstEventTime>2010-01-01T00:00:00"));
        XmlTest.assertXpathMatches((String)("should contain WARNING with ID#" + newestAckedAlarm.getId()), (String)newestAckedXml, (String)("//alarm[@severity='WARNING' and @id='" + newestAckedAlarm.getId() + "']"));
        Assert.assertTrue((boolean)newestAckedXml.contains("<firstEventTime>2010-01-01T01:00:00"));
        XmlTest.assertXpathMatches((String)("should contain WARNING with ID#" + oldestUnackedAlarm.getId()), (String)oldestUnackedXml, (String)("//alarm[@severity='WARNING' and @id='" + oldestUnackedAlarm.getId() + "']"));
        Assert.assertTrue((boolean)oldestUnackedXml.contains("<firstEventTime>2010-01-01T02:00:00"));
        XmlTest.assertXpathMatches((String)("should contain WARNING with ID#" + newestUnackedAlarm.getId()), (String)newestUnackedXml, (String)("//alarm[@severity='WARNING' and @id='" + newestUnackedAlarm.getId() + "']"));
        Assert.assertTrue((boolean)newestUnackedXml.contains("<firstEventTime>2010-01-01T03:00:00"));
    }

    private String getXml(String tag, String xml) {
        Pattern p = Pattern.compile("(<" + tag + ">.*?</" + tag + ">)", 42);
        Matcher m = p.matcher(xml);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    @Test
    public void testGetAlarmStatsSeverityList() throws Exception {
        this.createAlarm(OnmsSeverity.CLEARED, "admin");
        this.createAlarm(OnmsSeverity.MAJOR, "admin");
        this.createAlarm(OnmsSeverity.CRITICAL, "admin");
        this.createAlarm(OnmsSeverity.CRITICAL, null);
        this.createAlarm(OnmsSeverity.MINOR, null);
        this.createAlarm(OnmsSeverity.NORMAL, null);
        String xml = this.sendRequest(GET, "/stats/alarms/by-severity", 200);
        Assert.assertTrue((boolean)xml.contains("<severities>"));
        Assert.assertTrue((boolean)xml.contains("<alarmStatistics"));
        Assert.assertTrue((boolean)xml.contains("severity="));
        xml = this.sendRequest(GET, "/stats/alarms/by-severity", AlarmStatsRestServiceTest.parseParamData("severities=MINOR,NORMAL"), 200);
        Assert.assertFalse((boolean)xml.contains("CLEARED"));
        Assert.assertFalse((boolean)xml.contains("CRITICAL"));
        Assert.assertTrue((boolean)xml.contains("MINOR"));
        Assert.assertTrue((boolean)xml.contains("NORMAL"));
    }

    private OnmsAlarm createAlarm(OnmsSeverity severity, String ackUser) {
        OnmsEvent event = this.createEvent();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        alarm.setUei(event.getEventUei());
        alarm.setAlarmType(Integer.valueOf(1));
        alarm.setNode(this.m_databasePopulator.getNode1());
        alarm.setDescription("This is a test alarm");
        alarm.setLogMsg("this is a test alarm log message");
        alarm.setCounter(Integer.valueOf(1));
        alarm.setIpAddr(InetAddressUtils.UNPINGABLE_ADDRESS);
        alarm.setSeverity(severity);
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        if (ackUser != null) {
            alarm.setAlarmAckTime(new Date());
            alarm.setAlarmAckUser(ackUser);
        }
        this.getAlarmDao().save((Object)alarm);
        this.getAlarmDao().flush();
        LogUtils.debugf((Object)this, (String)"CreateAlarm: %s", (Object[])new Object[]{alarm});
        return alarm;
    }

    protected OnmsEvent createEvent() {
        GregorianCalendar c = new GregorianCalendar();
        c.set(2010, 0, 1, 0, 0, 0);
        long time = c.getTimeInMillis();
        time -= time % 1000L;
        Date date = new Date(time + (long)(this.count * 60 * 60 * 1000));
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller((OnmsDistPoller)this.getDistPollerDao().load((Serializable)((Object)"localhost")));
        event.setEventUei("uei.opennms.org/test/" + this.count);
        event.setEventCreateTime(date);
        event.setEventTime(date);
        event.setEventDescr("Test event " + this.count);
        event.setEventDisplay("Y");
        event.setEventLog("Y");
        event.setEventHost("es-with-the-most-es");
        event.setEventLogMsg("Test event " + this.count + " (log)");
        event.setEventSeverity(Integer.valueOf(OnmsSeverity.MAJOR.getId()));
        event.setEventSource("AlarmStatsRestServiceTest");
        event.setNode(this.m_databasePopulator.getNode1());
        this.getEventDao().save((Object)event);
        this.getEventDao().flush();
        ++this.count;
        return event;
    }

    private AlarmDao getAlarmDao() {
        return (AlarmDao)this.m_context.getBean("alarmDao", AlarmDao.class);
    }

    private DistPollerDao getDistPollerDao() {
        return (DistPollerDao)this.m_context.getBean("distPollerDao", DistPollerDao.class);
    }

    private EventDao getEventDao() {
        return (EventDao)this.m_context.getBean("eventDao", EventDao.class);
    }
}

