/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.outage;

import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.netmgt.model.outage.OutageSummary;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.filter.Filter;
import org.opennms.web.outage.Outage;
import org.opennms.web.outage.WebOutageRepository;
import org.opennms.web.outage.filter.OutageCriteria;
import org.opennms.web.outage.filter.OutageIdFilter;
import org.opennms.web.outage.filter.RegainedServiceDateBeforeFilter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/daoWebRepositoryTestContext.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class DaoWebOutageRepositoryTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    WebOutageRepository m_daoOutageRepo;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @BeforeClass
    public static void setupLogging() {
        Properties props = new Properties();
        props.setProperty("log4j.logger.org.hibernate", "INFO");
        props.setProperty("log4j.logger.org.springframework", "INFO");
        props.setProperty("log4j.logger.org.hibernate.SQL", "DEBUG");
        MockLogAppender.setupLogging((Properties)props);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
        OnmsMonitoredService svc2 = this.m_dbPopulator.getMonitoredServiceDao().get(Integer.valueOf(2), InetAddressUtils.addr((String)"192.168.2.1"), "ICMP");
        OnmsEvent event = (OnmsEvent)this.m_dbPopulator.getEventDao().get((Serializable)Integer.valueOf(1));
        OnmsOutage unresolved2 = new OnmsOutage(new Date(), event, svc2);
        this.m_dbPopulator.getOutageDao().save((Object)unresolved2);
        this.m_dbPopulator.getOutageDao().flush();
    }

    @Test
    @Transactional
    public void testCountMatchingOutages() {
        int count = this.m_daoOutageRepo.countMatchingOutages(new OutageCriteria(new Filter[0]));
        Assert.assertEquals((long)3L, (long)count);
        count = this.m_daoOutageRepo.countMatchingOutages(new OutageCriteria(new Filter[]{new RegainedServiceDateBeforeFilter(new Date())}));
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetMatchingOutages() {
        Outage[] outage = this.m_daoOutageRepo.getMatchingOutages(new OutageCriteria(new Filter[0]));
        Assert.assertEquals((long)3L, (long)outage.length);
        outage = this.m_daoOutageRepo.getMatchingOutages(new OutageCriteria(new Filter[]{new RegainedServiceDateBeforeFilter(new Date())}));
        Assert.assertEquals((long)1L, (long)outage.length);
        outage = this.m_daoOutageRepo.getMatchingOutages(new OutageCriteria(new Filter[]{new OutageIdFilter(1)}));
        Assert.assertEquals((long)1L, (long)outage.length);
        Assert.assertEquals((long)1L, (long)outage[0].getId());
        outage = this.m_daoOutageRepo.getMatchingOutages(new OutageCriteria(new Filter[]{new OutageIdFilter(2)}));
        Assert.assertEquals((long)1L, (long)outage.length);
        Assert.assertEquals((long)2L, (long)outage[0].getId());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetOutage() {
        Outage outage = this.m_daoOutageRepo.getOutage(1);
        Assert.assertNotNull((Object)outage);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetOutageSummaries() {
        OutageSummary[] summaries = this.m_daoOutageRepo.getMatchingOutageSummaries(new OutageCriteria(new Filter[0]));
        Assert.assertEquals((String)"there should be 2 outage summary in the default (current) outage criteria match", (long)2L, (long)summaries.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testCountMatchingSummaries() {
        int count = this.m_daoOutageRepo.countMatchingOutageSummaries(new OutageCriteria(new Filter[0]));
        Assert.assertEquals((long)2L, (long)count);
    }
}

