/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import java.io.Serializable;
import java.util.Date;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.Event;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.WebEventRepository;
import org.opennms.web.event.filter.AcknowledgedByFilter;
import org.opennms.web.event.filter.EventCriteria;
import org.opennms.web.event.filter.EventIdFilter;
import org.opennms.web.event.filter.NegativeSeverityFilter;
import org.opennms.web.event.filter.SeverityFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/daoWebRepositoryTestContext.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class DaoWebEventRepositoryTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    WebEventRepository m_daoEventRepo;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
        OnmsEvent event = new OnmsEvent();
        event.setDistPoller(this.getDistPoller("localhost", "127.0.0.1"));
        event.setEventUei("uei.opennms.org/test2");
        event.setEventTime(new Date());
        event.setEventSource("test");
        event.setEventCreateTime(new Date());
        event.setEventSeverity(Integer.valueOf(OnmsSeverity.CLEARED.getId()));
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        this.m_dbPopulator.getEventDao().save((Object)event);
        this.m_dbPopulator.getEventDao().flush();
        OnmsEvent event2 = new OnmsEvent();
        event2.setDistPoller(this.getDistPoller("localhost", "127.0.0.1"));
        event2.setEventUei("uei.opennms.org/test3");
        event2.setEventTime(new Date());
        event2.setEventSource("test");
        event2.setEventCreateTime(new Date());
        event2.setEventSeverity(Integer.valueOf(OnmsSeverity.CLEARED.getId()));
        event2.setEventLog("Y");
        event2.setEventDisplay("N");
        this.m_dbPopulator.getEventDao().save((Object)event2);
        this.m_dbPopulator.getEventDao().flush();
    }

    private OnmsDistPoller getDistPoller(String localhost, String localhostIp) {
        OnmsDistPoller distPoller = (OnmsDistPoller)this.m_dbPopulator.getDistPollerDao().get((Serializable)((Object)localhost));
        if (distPoller == null) {
            distPoller = new OnmsDistPoller(localhost, localhostIp);
            this.m_dbPopulator.getDistPollerDao().save((Object)distPoller);
            this.m_dbPopulator.getDistPollerDao().flush();
        }
        return distPoller;
    }

    @Test
    @Transactional
    public void testCountMatchingEvents() {
        EventCriteria criteria = new EventCriteria(new Filter[0]);
        int event = this.m_daoEventRepo.countMatchingEvents(criteria);
        Assert.assertEquals((long)2L, (long)event);
    }

    @Test
    @Transactional
    public void testCountMatchingEventsBySeverity() {
        EventCriteria criteria = new EventCriteria(new Filter[0]);
        int[] matchingEvents = this.m_daoEventRepo.countMatchingEventsBySeverity(criteria);
        Assert.assertNotNull((Object)matchingEvents);
        Assert.assertEquals((long)8L, (long)matchingEvents.length);
        Assert.assertEquals((long)1L, (long)matchingEvents[OnmsSeverity.CLEARED.getId()]);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.CRITICAL.getId()]);
        Assert.assertEquals((long)1L, (long)matchingEvents[OnmsSeverity.INDETERMINATE.getId()]);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.MAJOR.getId()]);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.MINOR.getId()]);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.NORMAL.getId()]);
        Assert.assertEquals((long)0L, (long)matchingEvents[OnmsSeverity.WARNING.getId()]);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetEvent() {
        Event event = this.m_daoEventRepo.getEvent(1);
        Assert.assertNotNull((Object)event);
        Assert.assertEquals((Object)"uei.opennms.org/test", (Object)event.uei);
        Assert.assertNotNull((Object)event.getEventDisplay());
        Assert.assertTrue((boolean)event.getEventDisplay());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAcknowledgeUnacknowledgeMatchingAlarms() {
        this.m_daoEventRepo.acknowledgeMatchingEvents("TestUser", new Date(), new EventCriteria(new Filter[]{new EventIdFilter(1)}));
        int matchingEventCount = this.m_daoEventRepo.countMatchingEvents(new EventCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)1L, (long)matchingEventCount);
        this.m_daoEventRepo.unacknowledgeMatchingEvents(new EventCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        matchingEventCount = this.m_daoEventRepo.countMatchingEvents(new EventCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)0L, (long)matchingEventCount);
    }

    @Test
    @Transactional
    public void testAcknowledgeUnacknowledgeAllAlarms() {
        this.m_daoEventRepo.acknowledgeAll("TestUser", new Date());
        int matchingEventCount = this.m_daoEventRepo.countMatchingEvents(new EventCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)2L, (long)matchingEventCount);
        this.m_daoEventRepo.unacknowledgeAll();
        matchingEventCount = this.m_daoEventRepo.countMatchingEvents(new EventCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)0L, (long)matchingEventCount);
    }

    @Test
    @Transactional
    public void testCountMatchingBySeverity() {
        int[] matchingEventCount = this.m_daoEventRepo.countMatchingEventsBySeverity(new EventCriteria(new Filter[]{new SeverityFilter(3)}));
        Assert.assertNotNull((Object)matchingEventCount);
        Assert.assertEquals((long)8L, (long)matchingEventCount.length);
    }

    @Test
    @Transactional
    public void testFilterBySeverity() {
        NegativeSeverityFilter filter = new NegativeSeverityFilter(OnmsSeverity.NORMAL.getId());
        EventCriteria criteria = new EventCriteria(new Filter[]{filter});
        Event[] events = this.m_daoEventRepo.getMatchingEvents(criteria);
        Assert.assertTrue((events.length > 0 ? 1 : 0) != 0);
        EventCriteria sortedCriteria = new EventCriteria(new Filter[]{filter}, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, 100, 0);
        Event[] sortedEvents = this.m_daoEventRepo.getMatchingEvents(sortedCriteria);
        Assert.assertTrue((sortedEvents.length > 0 ? 1 : 0) != 0);
    }
}

