/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.element.AtInterface;
import org.opennms.web.element.Interface;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.element.Service;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/daoWebRepositoryTestContext.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class NetworkElementFactoryTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    ApplicationContext m_appContext;
    @Autowired
    DataSource m_dataSource;
    @Autowired
    SimpleJdbcTemplate m_jdbcTemplate;
    @Autowired
    NodeDao m_nodeDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetNodeLabel() throws SQLException {
        String nodeLabel = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getNodeLabel(1);
        Assert.assertEquals((Object)nodeLabel, (Object)"node1");
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetIpPrimaryAddress() throws SQLException {
        this.m_jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime, nodeType, nodeLabel) VALUES (12, now(), 'A', 'nodeLabel')", new Object[0]);
        this.m_jdbcTemplate.update("INSERT INTO ipinterface (nodeid, ipaddr, iplastcapsdpoll, issnmpprimary) VALUES (12, '172.168.1.1', now(), 'P')", new Object[0]);
        String ipAddr = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getIpPrimaryAddress(12);
        Assert.assertEquals((Object)ipAddr, (Object)"172.168.1.1");
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetNodesWithIpLikeOneInterface() throws Exception {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
        this.m_jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime, nodeType) VALUES (12, now(), 'A')", new Object[0]);
        this.m_jdbcTemplate.update("INSERT INTO ipInterface (nodeId, ipAddr, isManaged) VALUES (12, '1.1.1.1', 'M')", new Object[0]);
        List nodes = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getNodesWithIpLike("*.*.*.*");
        Assert.assertEquals((String)"node count", (long)1L, (long)nodes.size());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetNodesWithIpLikeTwoInterfaces() throws Exception {
        for (OnmsNode node : this.m_nodeDao.findAll()) {
            this.m_nodeDao.delete((Object)node);
        }
        this.m_nodeDao.flush();
        this.m_jdbcTemplate.update("INSERT INTO node (nodeId, nodeCreateTime, nodeType) VALUES (12, now(), 'A')", new Object[0]);
        this.m_jdbcTemplate.update("INSERT INTO ipInterface (nodeId, ipAddr, isManaged) VALUES (12, '1.1.1.1', 'M')", new Object[0]);
        this.m_jdbcTemplate.update("INSERT INTO ipInterface (nodeId, ipAddr, isManaged) VALUES (12, '1.1.1.2', 'M')", new Object[0]);
        List nodes = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getNodesWithIpLike("*.*.*.*");
        Assert.assertEquals((String)"node count", (long)1L, (long)nodes.size());
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetInterfacesWithIpAddress() throws Exception {
        Interface[] interfaces = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getInterfacesWithIpAddress("fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%5");
        Assert.assertEquals((String)"interface count", (long)1L, (long)interfaces.length);
        Assert.assertEquals((String)"node ID", (long)this.m_dbPopulator.getNode1().getId().intValue(), (long)interfaces[0].getNodeId());
        Assert.assertEquals((String)"ifIndex", (long)4L, (long)interfaces[0].getIfIndex());
        interfaces = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getInterfacesWithIpAddress("fe80:0000:0000:0000:aaaa:bbbb:cccc:0001%5");
        Assert.assertEquals((String)"interface count", (long)0L, (long)interfaces.length);
        interfaces = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getInterfacesWithIpAddress("fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%4");
        Assert.assertEquals((String)"interface count", (long)0L, (long)interfaces.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetActiveInterfacesOnNode() {
        Interface[] intfs = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getActiveInterfacesOnNode(this.m_dbPopulator.getNode1().getId().intValue());
        Assert.assertEquals((String)"active interfaces", (long)4L, (long)intfs.length);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetDataLinksOnInterface() {
        List dlis = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getDataLinksOnInterface(this.m_dbPopulator.getNode1().getId().intValue(), 1);
        Assert.assertEquals((long)4L, (long)dlis.size());
        List dlis2 = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getDataLinksOnInterface(this.m_dbPopulator.getNode1().getId().intValue(), 9);
        Assert.assertEquals((long)0L, (long)dlis2.size());
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetAtInterfaces() throws Exception {
        AtInterface atif = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getAtInterface(this.m_dbPopulator.getNode2().getId().intValue(), "192.168.2.1");
        Assert.assertEquals((Object)"AA:BB:CC:DD:EE:FF", (Object)atif.get_physaddr());
        List nodes = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getNodesFromPhysaddr("AA:BB:CC:DD:EE:FF");
        Assert.assertEquals((long)1L, (long)nodes.size());
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetDataLinksOnNode() throws SQLException {
        List dlis = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getDataLinksOnNode(this.m_dbPopulator.getNode1().getId().intValue());
        Assert.assertEquals((long)5L, (long)dlis.size());
        List dlis2 = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getDataLinksOnNode(100);
        Assert.assertEquals((long)0L, (long)dlis2.size());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetServicesOnInterface() {
        this.m_jdbcTemplate.update("UPDATE ifservices SET status='A' WHERE id=2;", new Object[0]);
        Service[] svc = NetworkElementFactory.getInstance((ApplicationContext)this.m_appContext).getServicesOnInterface(1, "192.168.1.1");
        Assert.assertEquals((long)1L, (long)svc.length);
    }
}

