/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm;

import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.Alarm;
import org.opennms.web.alarm.SortStyle;
import org.opennms.web.alarm.WebAlarmRepository;
import org.opennms.web.alarm.filter.AcknowledgedByFilter;
import org.opennms.web.alarm.filter.AlarmCriteria;
import org.opennms.web.alarm.filter.AlarmIdFilter;
import org.opennms.web.alarm.filter.NodeNameLikeFilter;
import org.opennms.web.alarm.filter.SeverityFilter;
import org.opennms.web.filter.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath*:/META-INF/opennms/component-service.xml", "classpath:/daoWebRepositoryTestContext.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class DaoWebAlarmRepositoryTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    WebAlarmRepository m_alarmRepo;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_dbPopulator.populateDatabase();
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetAlarmById() {
        Alarm alarm = this.m_alarmRepo.getAlarm(1);
        Assert.assertNotNull((Object)alarm);
        Assert.assertEquals((long)1L, (long)alarm.id);
        Assert.assertEquals((Object)"uei.opennms.org/test", (Object)alarm.uei);
        Assert.assertEquals((Object)"localhost", (Object)alarm.dpName);
        Assert.assertEquals((long)1L, (long)alarm.count);
        Assert.assertEquals((long)3L, (long)alarm.severity.getId());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testCountMatchingAlarms() {
        int alarms = this.m_alarmRepo.countMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmIdFilter(1)}));
        Assert.assertEquals((long)1L, (long)alarms);
        alarms = this.m_alarmRepo.countMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmIdFilter(2)}));
        Assert.assertEquals((long)0L, (long)alarms);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testCountMatchingAlarmsBySeverity() {
        AlarmCriteria criteria = new AlarmCriteria(new Filter[0]);
        int[] matchingAlarms = this.m_alarmRepo.countMatchingAlarmsBySeverity(criteria);
        Assert.assertEquals((long)8L, (long)matchingAlarms.length);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.CLEARED.getId()]);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.CRITICAL.getId()]);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.INDETERMINATE.getId()]);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.MINOR.getId()]);
        Assert.assertEquals((long)1L, (long)matchingAlarms[OnmsSeverity.NORMAL.getId()]);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.WARNING.getId()]);
        Assert.assertEquals((long)0L, (long)matchingAlarms[OnmsSeverity.MAJOR.getId()]);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetMatchingAlarms() {
        Alarm[] alarms = this.m_alarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new SeverityFilter(OnmsSeverity.NORMAL), new AlarmIdFilter(1)}));
        Assert.assertNotNull((Object)alarms);
        Assert.assertEquals((long)1L, (long)alarms.length);
        alarms = this.m_alarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new SeverityFilter(OnmsSeverity.MAJOR)}));
        Assert.assertNotNull((Object)alarms);
        Assert.assertEquals((long)0L, (long)alarms.length);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testGetUnacknowledgedAlarms() {
        AlarmCriteria acked = new AlarmCriteria(AcknowledgeType.ACKNOWLEDGED, new Filter[0]);
        AlarmCriteria unacked = new AlarmCriteria(AcknowledgeType.UNACKNOWLEDGED, new Filter[0]);
        AlarmCriteria all = new AlarmCriteria(AcknowledgeType.BOTH, new Filter[0]);
        int countAll = this.m_alarmRepo.countMatchingAlarms(all);
        int countAcked = this.m_alarmRepo.countMatchingAlarms(acked);
        int countUnacked = this.m_alarmRepo.countMatchingAlarms(unacked);
        Assert.assertEquals((long)countAll, (long)(countAcked + countUnacked));
        Assert.assertTrue((countAll > 0 ? 1 : 0) != 0);
        Assert.assertTrue((countAcked == 0 ? 1 : 0) != 0);
        Assert.assertTrue((countUnacked > 0 ? 1 : 0) != 0);
        Alarm[] unackedAlarms = this.m_alarmRepo.getMatchingAlarms(unacked);
        Assert.assertEquals((long)countUnacked, (long)unackedAlarms.length);
        Alarm[] ackedAlarms = this.m_alarmRepo.getMatchingAlarms(acked);
        Assert.assertEquals((long)countAcked, (long)ackedAlarms.length);
        Alarm[] allAlarms = this.m_alarmRepo.getMatchingAlarms(all);
        Assert.assertEquals((long)countAll, (long)allAlarms.length);
        this.m_alarmRepo.acknowledgeMatchingAlarms("TestUser", new Date(), new AlarmCriteria(new Filter[]{new AlarmIdFilter(1)}));
        Assert.assertEquals((long)(countAcked + 1), (long)this.m_alarmRepo.countMatchingAlarms(acked));
        Assert.assertEquals((long)(countUnacked - 1), (long)this.m_alarmRepo.countMatchingAlarms(unacked));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAcknowledgeUnacknowledge() {
        String user = "TestUser";
        this.m_alarmRepo.acknowledgeMatchingAlarms(user, new Date(), new AlarmCriteria(new Filter[]{new AlarmIdFilter(1)}));
        int matchingAlarmCount = this.m_alarmRepo.countMatchingAlarms(new AlarmCriteria(new Filter[]{new AcknowledgedByFilter(user)}));
        Assert.assertEquals((long)1L, (long)matchingAlarmCount);
        this.m_alarmRepo.unacknowledgeMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmIdFilter(1)}), user);
        matchingAlarmCount = this.m_alarmRepo.countMatchingAlarms(new AlarmCriteria(new Filter[]{new AcknowledgedByFilter(user)}));
        Assert.assertEquals((long)0L, (long)matchingAlarmCount);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testSort() {
        for (SortStyle style : SortStyle.values()) {
            AlarmCriteria sorted = new AlarmCriteria(new Filter[0], style, AcknowledgeType.UNACKNOWLEDGED, 100, 0);
            Alarm[] alarms = this.m_alarmRepo.getMatchingAlarms(sorted);
            Assert.assertTrue((String)("Failed to sort with style " + style), (alarms.length > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testSortAndSearchBySameProperty() {
        Filter[] filters = new Filter[]{new NodeNameLikeFilter("node")};
        AlarmCriteria sorted = new AlarmCriteria(filters, SortStyle.NODE, AcknowledgeType.UNACKNOWLEDGED, 100, 0);
        Alarm[] alarms = this.m_alarmRepo.getMatchingAlarms(sorted);
        Assert.assertTrue((String)("Failed to sort with style " + SortStyle.NODE), (alarms.length > 0 ? 1 : 0) != 0);
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testAcknowledgeUnacknowledgeAllAlarms() {
        String user = "TestUser";
        this.m_alarmRepo.acknowledgeAll("TestUser", new Date());
        int matchingAlarmCount = this.m_alarmRepo.countMatchingAlarms(new AlarmCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)1L, (long)matchingAlarmCount);
        this.m_alarmRepo.unacknowledgeAll(user);
        matchingAlarmCount = this.m_alarmRepo.countMatchingAlarms(new AlarmCriteria(new Filter[]{new AcknowledgedByFilter("TestUser")}));
        Assert.assertEquals((long)0L, (long)matchingAlarmCount);
    }

    @Test
    @JUnitTemporaryDatabase
    public void testEscalateAlarms() {
        int[] alarmIds = new int[]{1};
        this.m_alarmRepo.escalateAlarms(alarmIds, "TestUser", new Date());
        Alarm[] alarms = this.m_alarmRepo.getMatchingAlarms(new AlarmCriteria(new Filter[]{new AlarmIdFilter(1)}));
        Assert.assertNotNull((Object)alarms);
        Assert.assertEquals((long)OnmsSeverity.WARNING.getId(), (long)alarms[0].severity.getId());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testClearAlarms() {
        Alarm alarm = this.m_alarmRepo.getAlarm(1);
        Assert.assertNotNull((Object)alarm);
        Assert.assertEquals((long)OnmsSeverity.NORMAL.getId(), (long)alarm.severity.getId());
        int[] alarmIds = new int[]{1};
        this.m_alarmRepo.clearAlarms(alarmIds, "TestUser", new Date());
        alarm = this.m_alarmRepo.getAlarm(1);
        Assert.assertNotNull((Object)alarm);
        Assert.assertEquals((long)OnmsSeverity.CLEARED.getId(), (long)alarm.severity.getId());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testAcknowledgements() {
        this.m_alarmRepo.acknowledgeAlarms(new int[]{1}, "agalue", new Date());
        List acks = this.m_alarmRepo.getAcknowledgments(1);
        Assert.assertNotNull((Object)acks);
        Assert.assertEquals((long)1L, (long)acks.size());
        Assert.assertEquals((Object)"agalue", (Object)((OnmsAcknowledgment)acks.get(0)).getAckUser());
    }
}

