/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.netmgt.dao.OutageDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsOutage;
import org.opennms.web.svclayer.outage.DefaultOutageService;

public class DefaultOutageServiceTest {
    DefaultOutageService outageService = new DefaultOutageService();
    private OutageDao outageDao;

    @Before
    public void setUp() throws Exception {
        this.outageDao = (OutageDao)EasyMock.createMock(OutageDao.class);
        this.outageService.setDao(this.outageDao);
    }

    @Test
    public void testLoadOneOutage() {
        Assert.assertNotNull((Object)this.outageService);
        Assert.assertNotNull((Object)this.outageDao);
        Integer outageId = 505;
        OnmsOutage outage = new OnmsOutage();
        outage.setId(Integer.valueOf(505));
        EasyMock.expect((Object)this.outageDao.load((Serializable)outageId)).andReturn((Object)outage);
        EasyMock.replay((Object[])new Object[]{this.outageDao});
        OnmsOutage outage2 = this.outageService.load(outageId);
        EasyMock.verify((Object[])new Object[]{this.outageDao});
        Assert.assertTrue((String)"Yay we can load a single outage... ", (boolean)outage.equals(outage2));
    }

    @Test
    public void testGetCurrentOutageCount() {
        Assert.assertNotNull((Object)this.outageService);
        Assert.assertNotNull((Object)this.outageDao);
        Integer expectedCount = 1;
        EasyMock.expect((Object)this.outageDao.currentOutageCount()).andReturn((Object)expectedCount);
        EasyMock.replay((Object[])new Object[]{this.outageDao});
        Integer count = this.outageService.getCurrentOutageCount();
        EasyMock.verify((Object[])new Object[]{this.outageDao});
        Assert.assertTrue((String)"A good system should have outages ", (boolean)count.equals(1));
    }

    @Ignore(value="The features here have yet been implemented")
    public void testSuppressedOutageCount() {
        Assert.fail((String)"Needs to be upgraded to hibernate");
    }

    @Test
    public void testCurrentOutages() {
        Assert.assertNotNull((Object)this.outageService);
        Assert.assertNotNull((Object)this.outageDao);
        HashSet<OnmsOutage> expectedOutages = new HashSet<OnmsOutage>();
        OnmsOutage expectedCurrent = new OnmsOutage();
        expectedCurrent.setId(Integer.valueOf(1));
        expectedOutages.add(expectedCurrent);
        EasyMock.expect((Object)this.outageDao.currentOutages()).andReturn(expectedOutages);
        EasyMock.replay((Object[])new Object[]{this.outageDao});
        Collection current = this.outageService.getCurrentOutages();
        EasyMock.verify((Object[])new Object[]{this.outageDao});
        Assert.assertTrue((String)"Current Outages", (boolean)current.equals(expectedOutages));
    }

    @Ignore(value="The features here have yet been implemented")
    public void testSuppressedOutages() {
        Assert.fail((String)"Needs to be upgraded to hibernate");
    }

    @Ignore(value="The features here have yet been implemented")
    public void testOpenAndResolved() {
        Assert.fail((String)"Needs to be upgraded to hibernate");
    }

    @Test
    public void testCurrentByRange() {
        Assert.assertNotNull((Object)this.outageService);
        Assert.assertNotNull((Object)this.outageDao);
        LinkedList<OnmsOutage> expectedOutages = new LinkedList<OnmsOutage>();
        OnmsOutage expectedCurrent = new OnmsOutage();
        expectedCurrent.setId(Integer.valueOf(1));
        expectedCurrent.setMonitoredService(new OnmsMonitoredService());
        expectedCurrent.getMonitoredService().setIpInterface(new OnmsIpInterface());
        expectedCurrent.getMonitoredService().getIpInterface().setNode(new OnmsNode());
        expectedOutages.add(expectedCurrent);
        OnmsCriteria criteria = new OnmsCriteria(OnmsOutage.class);
        EasyMock.expect((Object)this.outageDao.findMatching(criteria)).andReturn(expectedOutages);
        EasyMock.replay((Object[])new Object[]{this.outageDao});
        Collection outages = this.outageService.getOutagesByRange(Integer.valueOf(1), Integer.valueOf(1), "iflostservice", "asc", criteria);
        EasyMock.verify((Object[])new Object[]{this.outageDao});
        Assert.assertTrue((String)"Current Outages", (boolean)outages.equals(expectedOutages));
    }

    @Ignore(value="The features here have yet been implemented")
    public void testSuppressedByRange() {
        Assert.fail((String)"Needs to be upgraded to hibernate");
    }

    @Ignore(value="The features here have yet been implemented")
    public void testGetOpenAndResolvedByRange() {
        Assert.fail((String)"Needs to be upgraded to hibernate");
    }
}

