/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import org.opennms.netmgt.dao.DemandPollDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.model.DemandPoll;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.web.services.PollerService;
import org.opennms.web.svclayer.DemandPollService;

public class DefaultDemandPollService
implements DemandPollService {
    private PollerService m_pollerService;
    private DemandPollDao m_demandPollDao;
    private MonitoredServiceDao m_monitoredServiceDao;

    public void setDemandPollDao(DemandPollDao demandPollDao) {
        this.m_demandPollDao = demandPollDao;
    }

    public void setPollerAPI(PollerService pollerAPI) {
        this.m_pollerService = pollerAPI;
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    @Override
    public DemandPoll pollMonitoredService(int nodeId, InetAddress ipAddr, int ifIndex, int serviceId) {
        DemandPoll demandPoll = new DemandPoll();
        demandPoll.setRequestTime(new Date());
        this.m_demandPollDao.save((Object)demandPoll);
        OnmsMonitoredService monSvc = this.m_monitoredServiceDao.get(Integer.valueOf(nodeId), ipAddr, Integer.valueOf(ifIndex), Integer.valueOf(serviceId));
        if (monSvc == null) {
            throw new RuntimeException("Service doesn't exist: " + monSvc);
        }
        this.m_pollerService.poll(monSvc, demandPoll.getId());
        return demandPoll;
    }

    @Override
    public DemandPoll getUpdatedResults(int pollId) {
        return (DemandPoll)this.m_demandPollDao.get((Serializable)Integer.valueOf(pollId));
    }
}

