/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rss;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import org.opennms.web.notification.Notification;
import org.opennms.web.notification.NotificationModel;
import org.opennms.web.rss.AbstractFeed;

public class NotificationFeed
extends AbstractFeed {
    @Override
    public SyndFeed getFeed() {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setTitle("Notifications");
        feed.setDescription("Notifications");
        feed.setLink(this.getUrlBase() + "notification/browse");
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        try {
            NotificationModel model = new NotificationModel();
            Notification[] notifications = model.allNotifications("desc");
            int count = 0;
            for (Notification notification : notifications) {
                if (count++ != this.getMaxEntries()) {
                    SyndEntryImpl entry = new SyndEntryImpl();
                    entry.setPublishedDate(notification.getTimeSent());
                    if (notification.getTimeReplied() == null) {
                        entry.setTitle(this.sanitizeTitle(notification.getTextMessage()));
                        entry.setUpdatedDate(notification.getTimeSent());
                    } else {
                        entry.setTitle(this.sanitizeTitle(notification.getTextMessage()) + " (acknowledged)");
                        entry.setUpdatedDate(notification.getTimeReplied());
                    }
                    entry.setLink(this.getUrlBase() + "notification/detail.jsp?notice=" + notification.getId());
                    entries.add(entry);
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            this.log().warn("unable to get outstanding notifications", (Throwable)e);
        }
        feed.setEntries(entries);
        return feed;
    }
}

