/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.CollectdConfigFactory;
import org.opennms.netmgt.config.CollectdPackage;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.config.PollOutagesConfigFactory;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.ThreshdConfigFactory;
import org.opennms.netmgt.config.poller.Outage;
import org.opennms.netmgt.config.poller.Outages;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="sched-outages")
public class ScheduledOutagesRestService
extends OnmsRestService {
    @Context
    UriInfo m_uriInfo;
    @Autowired
    protected PollOutagesConfigFactory m_configFactory;
    @Autowired
    protected EventProxy m_eventProxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Outages getOutages() {
        this.readLock();
        try {
            Outages outages = new Outages();
            outages.setOutage(this.m_configFactory.getOutages());
            Outages outages2 = outages;
            return outages2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{outageName}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Outage getOutage(@PathParam(value="outageName") String outageName) throws IllegalArgumentException {
        this.readLock();
        try {
            Outage outage = this.m_configFactory.getOutage(outageName);
            if (outage == null) {
                throw new IllegalArgumentException("Scheduled outage " + outageName + " does not exist.");
            }
            Outage outage2 = outage;
            return outage2;
        }
        finally {
            this.readUnlock();
        }
    }

    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response saveOrUpdateOutage(Outage newOutage) {
        this.writeLock();
        try {
            if (newOutage == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "Outage object can't be null");
            }
            Outage oldOutage = this.m_configFactory.getOutage(newOutage.getName());
            if (oldOutage == null) {
                this.log().debug("saveOrUpdateOutage: adding outage " + newOutage.getName());
                this.m_configFactory.addOutage(newOutage);
            } else {
                this.log().debug("saveOrUpdateOutage: updating outage " + newOutage.getName());
                this.m_configFactory.replaceOutage(oldOutage, newOutage);
            }
            this.m_configFactory.saveCurrent();
            this.sendConfigChangedEvent();
            Response response = Response.seeOther((URI)ScheduledOutagesRestService.getRedirectUri(this.m_uriInfo, newOutage.getName())).build();
            return response;
        }
        catch (Exception e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Can't save or update the scheduled outage " + newOutage.getName() + " because, " + e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{outageName}")
    public Response deleteOutage(@PathParam(value="outageName") String outageName) {
        this.writeLock();
        try {
            this.log().debug("deleteOutage: deleting outage " + outageName);
            this.updateCollectd(ConfigAction.REMOVE_FROM_ALL, outageName, null);
            this.updatePollerd(ConfigAction.REMOVE_FROM_ALL, outageName, null);
            this.updateThreshd(ConfigAction.REMOVE_FROM_ALL, outageName, null);
            this.updateNotifd(ConfigAction.REMOVE, outageName);
            this.m_configFactory.removeOutage(outageName);
            this.m_configFactory.saveCurrent();
            this.sendConfigChangedEvent();
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Can't delete the scheduled outage " + outageName + " because, " + e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Path(value="{outageName}/collectd/{packageName}")
    public Response addOutageToCollector(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updateCollectd(ConfigAction.ADD, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.seeOther((URI)ScheduledOutagesRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        catch (Exception e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Can't add scheduled outage " + outageName + " to collector package " + packageName + ", because: " + e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{outageName}/collectd/{packageName}")
    public Response removeOutageFromCollector(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updateCollectd(ConfigAction.REMOVE, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Can't remove scheduled outage " + outageName + " from collector package " + packageName + ", because: " + e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Path(value="{outageName}/pollerd/{packageName}")
    public Response addOutageToPoller(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updatePollerd(ConfigAction.ADD, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.seeOther((URI)ScheduledOutagesRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        catch (Exception e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Can't add scheduled outage " + outageName + " to poller package " + packageName + ", because: " + e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{outageName}/pollerd/{packageName}")
    public Response removeOutageFromPoller(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updatePollerd(ConfigAction.REMOVE, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Can't remove scheduled outage " + outageName + " from poller package " + packageName + ", because: " + e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Path(value="{outageName}/threshd/{packageName}")
    public Response addOutageToThresholder(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updateThreshd(ConfigAction.ADD, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.seeOther((URI)ScheduledOutagesRestService.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        catch (Exception e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Can't add scheduled outage " + outageName + " to threshold package " + packageName + ", because: " + e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{outageName}/threshd/{packageName}")
    public Response removeOutageFromThresholder(@PathParam(value="outageName") String outageName, @PathParam(value="packageName") String packageName) {
        this.writeLock();
        try {
            this.updateThreshd(ConfigAction.REMOVE, outageName, packageName);
            this.sendConfigChangedEvent();
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Can't remove scheduled outage " + outageName + " from threshold package " + packageName + ", because: " + e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Path(value="{outageName}/notifd")
    public Response addOutageToNotifications(@PathParam(value="outageName") String outageName) {
        this.writeLock();
        try {
            this.updateNotifd(ConfigAction.ADD, outageName);
            this.sendConfigChangedEvent();
            Response response = Response.seeOther((URI)ScheduledOutagesRestService.getRedirectUri(this.m_uriInfo, outageName)).build();
            return response;
        }
        catch (Exception e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Can't add scheduled outage " + outageName + " to notifications because: " + e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{outageName}/notifd")
    public Response removeOutageFromNotifications(@PathParam(value="outageName") String outageName) {
        this.writeLock();
        try {
            this.updateNotifd(ConfigAction.REMOVE, outageName);
            this.sendConfigChangedEvent();
            Response response = Response.ok().build();
            return response;
        }
        catch (Exception e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Can't remove scheduled outage " + outageName + " from notifications because: " + e.getMessage());
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{outageName}/nodeInOutage/{nodeId}")
    @Produces(value={"text/plain"})
    public String isNodeInOutage(@PathParam(value="outageName") String outageName, @PathParam(value="nodeId") Integer nodeId) {
        this.readLock();
        try {
            Outage outage = this.getOutage(outageName);
            Boolean inOutage = this.m_configFactory.isNodeIdInOutage((long)nodeId.intValue(), outage) && this.m_configFactory.isCurTimeInOutage(outage);
            String string = inOutage.toString();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="nodeInOutage/{nodeId}")
    @Produces(value={"text/plain"})
    public String isNodeInOutage(@PathParam(value="nodeId") Integer nodeId) {
        this.readLock();
        try {
            for (Outage outage : this.m_configFactory.getOutages()) {
                if (!this.m_configFactory.isNodeIdInOutage((long)nodeId.intValue(), outage) || !this.m_configFactory.isCurTimeInOutage(outage)) continue;
                String string = Boolean.TRUE.toString();
                return string;
            }
            String string = Boolean.FALSE.toString();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{outageName}/interfaceInOutage/{ipAddr}")
    @Produces(value={"text/plain"})
    public String isInterfaceInOutage(@PathParam(value="outageName") String outageName, @PathParam(value="ipAddr") String ipAddr) {
        this.readLock();
        try {
            this.validateAddress(ipAddr);
            Outage outage = this.getOutage(outageName);
            Boolean inOutage = this.m_configFactory.isInterfaceInOutage(ipAddr, outage) && this.m_configFactory.isCurTimeInOutage(outage);
            String string = inOutage.toString();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="interfaceInOutage/{ipAddr}")
    @Produces(value={"text/plain"})
    public String isInterfaceInOutage(@PathParam(value="ipAddr") String ipAddr) {
        this.readLock();
        try {
            for (Outage outage : this.m_configFactory.getOutages()) {
                if (!this.m_configFactory.isInterfaceInOutage(ipAddr, outage) || !this.m_configFactory.isCurTimeInOutage(outage)) continue;
                String string = Boolean.TRUE.toString();
                return string;
            }
            String string = Boolean.FALSE.toString();
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    private void validateAddress(String ipAddress) {
        boolean valid = false;
        try {
            valid = InetAddressUtils.addr((String)ipAddress) != null;
        }
        catch (Exception e) {
            valid = false;
        }
        if (!valid) {
            throw this.getException(Response.Status.BAD_REQUEST, "Malformed IP Address " + ipAddress);
        }
    }

    private void updateCollectd(ConfigAction action, String outageName, String packageName) throws Exception {
        CollectdPackage pkg;
        this.getOutage(outageName);
        if (action.equals((Object)ConfigAction.ADD) && !(pkg = this.getCollectdPackage(packageName)).getPackage().getOutageCalendarCollection().contains(outageName)) {
            pkg.getPackage().addOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE)) {
            pkg = this.getCollectdPackage(packageName);
            pkg.getPackage().removeOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE_FROM_ALL)) {
            for (CollectdPackage pkg2 : CollectdConfigFactory.getInstance().getCollectdConfig().getPackages()) {
                pkg2.getPackage().removeOutageCalendar(outageName);
            }
        }
        CollectdConfigFactory.getInstance().saveCurrent();
    }

    private CollectdPackage getCollectdPackage(String packageName) throws IllegalArgumentException {
        CollectdPackage pkg = CollectdConfigFactory.getInstance().getPackage(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Collectd package " + packageName + " does not exist.");
        }
        return pkg;
    }

    private void updatePollerd(ConfigAction action, String outageName, String packageName) throws Exception {
        Package pkg;
        this.getOutage(outageName);
        if (action.equals((Object)ConfigAction.ADD) && !(pkg = this.getPollerdPackage(packageName)).getOutageCalendarCollection().contains(outageName)) {
            pkg.addOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE)) {
            pkg = this.getPollerdPackage(packageName);
            pkg.removeOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE_FROM_ALL)) {
            for (Package pkg2 : PollerConfigFactory.getInstance().getConfiguration().getPackage()) {
                pkg2.removeOutageCalendar(outageName);
            }
        }
        PollerConfigFactory.getInstance().save();
    }

    private Package getPollerdPackage(String packageName) throws IllegalArgumentException {
        Package pkg = PollerConfigFactory.getInstance().getPackage(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Poller package " + packageName + " does not exist.");
        }
        return pkg;
    }

    private void updateThreshd(ConfigAction action, String outageName, String packageName) throws Exception {
        org.opennms.netmgt.config.threshd.Package pkg;
        this.getOutage(outageName);
        if (action.equals((Object)ConfigAction.ADD) && !(pkg = this.getThreshdPackage(packageName)).getOutageCalendarCollection().contains(outageName)) {
            pkg.addOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE)) {
            pkg = this.getThreshdPackage(packageName);
            pkg.removeOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE_FROM_ALL)) {
            for (org.opennms.netmgt.config.threshd.Package pkg2 : ThreshdConfigFactory.getInstance().getConfiguration().getPackage()) {
                pkg2.removeOutageCalendar(outageName);
            }
        }
        ThreshdConfigFactory.getInstance().saveCurrent();
    }

    private org.opennms.netmgt.config.threshd.Package getThreshdPackage(String packageName) throws IllegalArgumentException {
        org.opennms.netmgt.config.threshd.Package pkg = ThreshdConfigFactory.getInstance().getPackage(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Threshold package " + packageName + " does not exist.");
        }
        return pkg;
    }

    private void updateNotifd(ConfigAction action, String outageName) throws Exception {
        this.getOutage(outageName);
        NotifdConfigFactory factory = NotifdConfigFactory.getInstance();
        if (action.equals((Object)ConfigAction.ADD)) {
            factory.getConfiguration().addOutageCalendar(outageName);
        }
        if (action.equals((Object)ConfigAction.REMOVE) || action.equals((Object)ConfigAction.REMOVE_FROM_ALL)) {
            factory.getConfiguration().removeOutageCalendar(outageName);
        }
        factory.saveCurrent();
    }

    private void sendConfigChangedEvent() {
        EventBuilder builder = new EventBuilder("uei.opennms.org/internal/schedOutagesChanged", "Web UI");
        try {
            this.m_eventProxy.send(builder.getEvent());
        }
        catch (Throwable e) {
            throw this.getException(Response.Status.BAD_REQUEST, "Could not send event " + builder.getEvent().getUei() + " because, " + e.getMessage());
        }
    }

    private static enum ConfigAction {
        ADD,
        REMOVE,
        REMOVE_FROM_ALL;

    }
}

