/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterfaceList;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Transactional
public class OnmsSnmpInterfaceResource
extends OnmsRestService {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private EventProxy m_eventProxy;
    @Context
    UriInfo m_uriInfo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsSnmpInterfaceList getSnmpInterfaces(@PathParam(value="nodeCriteria") String nodeCriteria) {
        this.readLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            MultivaluedMap params = this.m_uriInfo.getQueryParameters();
            CriteriaBuilder builder = new CriteriaBuilder(OnmsSnmpInterface.class);
            builder.ne("collect", (Object)"D");
            builder.limit(Integer.valueOf(20));
            this.applyQueryFilters((MultivaluedMap<String, String>)params, builder);
            builder.eq("node.id", (Object)node.getId());
            OnmsSnmpInterfaceList snmpList = new OnmsSnmpInterfaceList((Collection)this.m_snmpInterfaceDao.findMatching(builder.toCriteria()));
            snmpList.setTotalCount(this.m_snmpInterfaceDao.countMatching(builder.count().toCriteria()));
            OnmsSnmpInterfaceList onmsSnmpInterfaceList = snmpList;
            return onmsSnmpInterfaceList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{ifIndex}")
    public OnmsEntity getSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ifIndex") int ifIndex) {
        this.readLock();
        try {
            OnmsSnmpInterface onmsSnmpInterface = this.m_nodeDao.get(nodeCriteria).getSnmpInterfaceWithIfIndex(ifIndex);
            return onmsSnmpInterface;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, OnmsSnmpInterface snmpInterface) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addSnmpInterface: can't find node " + nodeCriteria);
            }
            if (snmpInterface == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addSnmpInterface: SNMP interface object cannot be null");
            }
            LogUtils.debugf((Object)this, (String)"addSnmpInterface: adding interface %s", (Object[])new Object[]{snmpInterface});
            node.addSnmpInterface(snmpInterface);
            if (snmpInterface.getPrimaryIpInterface() != null) {
                OnmsIpInterface iface = snmpInterface.getPrimaryIpInterface();
                iface.setSnmpInterface(snmpInterface);
            }
            this.m_snmpInterfaceDao.save((Object)snmpInterface);
            Integer ifIndex = snmpInterface.getIfIndex();
            Response response = Response.seeOther((URI)OnmsSnmpInterfaceResource.getRedirectUri(this.m_uriInfo, ifIndex)).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{ifIndex}")
    public Response deleteSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ifIndex") int ifIndex) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteSnmpInterface: can't find node " + nodeCriteria);
            }
            OnmsSnmpInterface snmpInterface = node.getSnmpInterfaceWithIfIndex(ifIndex);
            if (snmpInterface == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteSnmpInterface: can't find SNMP interface with ifIndex " + ifIndex + " for node " + nodeCriteria);
            }
            LogUtils.debugf((Object)this, (String)"deletSnmpInterface: deleting interface with ifIndex %d from node %s", (Object[])new Object[]{ifIndex, nodeCriteria});
            node.getSnmpInterfaces().remove(snmpInterface);
            this.m_nodeDao.saveOrUpdate((Object)node);
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{ifIndex}")
    public Response updateSnmpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ifIndex") int ifIndex, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteSnmpInterface: can't find node " + nodeCriteria);
            }
            if (ifIndex < 0) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteSnmpInterface: invalid ifIndex specified for SNMP interface on node " + node.getId() + ": " + ifIndex);
            }
            OnmsSnmpInterface snmpInterface = node.getSnmpInterfaceWithIfIndex(ifIndex);
            if (snmpInterface == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteSnmpInterface: can't find SNMP interface with ifIndex " + ifIndex + " for node " + nodeCriteria);
            }
            LogUtils.debugf((Object)this, (String)"updateSnmpInterface: updating SNMP interface %s", (Object[])new Object[]{snmpInterface});
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)snmpInterface);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            Event e = null;
            if (params.containsKey("collect")) {
                EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/reinitializePrimarySnmpInterface", "OpenNMS.Webapp");
                bldr.setNode(node);
                OnmsIpInterface iface = node.getPrimaryInterface();
                if (iface == null) {
                    LogUtils.warnf((Object)this, (String)"updateSnmpInterface: Cannot send %s event because node %d has no primary SNMP interface", (Object[])new Object[]{"uei.opennms.org/nodes/reinitializePrimarySnmpInterface", node.getId()});
                } else {
                    bldr.setInterface(iface.getIpAddress());
                    e = bldr.getEvent();
                }
            }
            LogUtils.debugf((Object)this, (String)"updateSnmpInterface: SNMP interface %s updated", (Object[])new Object[]{snmpInterface});
            this.m_snmpInterfaceDao.saveOrUpdate((Object)snmpInterface);
            if (e != null) {
                try {
                    this.m_eventProxy.send(e);
                }
                catch (EventProxyException ex) {
                    throw this.getException(Response.Status.INTERNAL_SERVER_ERROR, "Exception occurred sending event: " + ex.getMessage());
                }
            }
            Response response = Response.seeOther((URI)OnmsSnmpInterfaceResource.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }
}

