/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.net.InetAddress;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.dao.support.CreateIfNecessaryTemplate;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoredServiceList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.netmgt.model.events.EventProxyException;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Transactional
public class OnmsMonitoredServiceResource
extends OnmsRestService {
    @Context
    UriInfo m_uriInfo;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_serviceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    private EventProxy m_eventProxy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsMonitoredServiceList getServices(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress) {
        this.readLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            OnmsMonitoredServiceList onmsMonitoredServiceList = new OnmsMonitoredServiceList((Collection)node.getIpInterfaceByIpAddress(ipAddress).getMonitoredServices());
            return onmsMonitoredServiceList;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{service}")
    public OnmsMonitoredService getService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String service) {
        this.readLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            OnmsMonitoredService onmsMonitoredService = node.getIpInterfaceByIpAddress(ipAddress).getMonitoredServiceByServiceType(service);
            return onmsMonitoredService;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, final OnmsMonitoredService service) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addService: can't find node " + nodeCriteria);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(ipAddress);
            if (intf == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addService: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria);
            }
            if (service == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addService: service object cannot be null");
            }
            if (service.getServiceName() == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addService: service must have a name");
            }
            OnmsServiceType serviceType = (OnmsServiceType)new CreateIfNecessaryTemplate<OnmsServiceType, ServiceTypeDao>(this.m_transactionManager, this.m_serviceTypeDao){

                protected OnmsServiceType query() {
                    return ((ServiceTypeDao)this.m_dao).findByName(service.getServiceName());
                }

                protected OnmsServiceType doInsert() {
                    OnmsServiceType s = new OnmsServiceType(service.getServiceName());
                    ((ServiceTypeDao)this.m_dao).saveOrUpdate((Object)s);
                    return s;
                }
            }.execute();
            service.setServiceType(serviceType);
            service.setIpInterface(intf);
            this.log().debug("addService: adding service " + service);
            this.m_serviceDao.save((Object)service);
            Event e = EventUtils.createNodeGainedServiceEvent((String)this.getClass().getName(), (int)node.getId(), (InetAddress)intf.getIpAddress(), (String)service.getServiceName(), (String)node.getLabel(), (String)node.getLabelSource(), (String)node.getSysName(), (String)node.getSysDescription());
            try {
                this.m_eventProxy.send(e);
            }
            catch (EventProxyException ex) {
                throw this.getException(Response.Status.BAD_REQUEST, ex.getMessage());
            }
            Response response = Response.seeOther((URI)OnmsMonitoredServiceResource.getRedirectUri(this.m_uriInfo, service.getServiceName())).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{service}")
    public Response updateService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String serviceName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addService: can't find node " + nodeCriteria);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(ipAddress);
            if (intf == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addService: can't find ip interface on " + nodeCriteria + "@" + ipAddress);
            }
            OnmsMonitoredService service = intf.getMonitoredServiceByServiceType(serviceName);
            if (service == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "addService: can't find service " + serviceName + " on " + nodeCriteria + "@" + ipAddress);
            }
            this.log().debug("updateService: updating service " + service);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)service);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            this.log().debug("updateSservice: service " + service + " updated");
            this.m_serviceDao.saveOrUpdate((Object)service);
            Response response = Response.seeOther((URI)OnmsMonitoredServiceResource.getRedirectUri(this.m_uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{service}")
    public Response deleteService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String serviceName) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteService: can't find node " + nodeCriteria);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(ipAddress);
            if (intf == null) {
                throw this.getException(Response.Status.BAD_REQUEST, "deleteService: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria);
            }
            OnmsMonitoredService service = intf.getMonitoredServiceByServiceType(serviceName);
            if (service == null) {
                throw this.getException(Response.Status.CONFLICT, "deleteService: service " + serviceName + " not found on interface " + intf);
            }
            this.log().debug("deleteService: deleting service " + serviceName + " from node " + nodeCriteria);
            intf.getMonitoredServices().remove(service);
            this.m_ipInterfaceDao.saveOrUpdate((Object)intf);
            EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/serviceDeleted", this.getClass().getName());
            bldr.setNodeid((long)node.getId().intValue());
            bldr.setInterface(InetAddressUtils.addr((String)ipAddress));
            bldr.setService(serviceName);
            try {
                this.m_eventProxy.send(bldr.getEvent());
            }
            catch (EventProxyException ex) {
                throw this.getException(Response.Status.BAD_REQUEST, ex.getMessage());
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }
}

