/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.web.notification.NoticeSentTo;
import org.opennms.web.notification.Notification;

public class NotificationModel {
    private static final String USERID = "userID";
    private static final String NOTICE_TIME = "notifytime";
    private static final String TXT_MESG = "textMsg";
    private static final String NUM_MESG = "numericMsg";
    private static final String NOTIFY = "notifyID";
    private static final String TIME = "pageTime";
    private static final String REPLYTIME = "respondTime";
    private static final String ANS_BY = "answeredBy";
    private static final String CONTACT = "contactInfo";
    private static final String NODE = "nodeID";
    private static final String INTERFACE = "interfaceID";
    private static final String SERVICE = "serviceID";
    private static final String MEDIA = "media";
    private static final String EVENTID = "eventid";
    private static final String SELECT = "SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid from NOTIFICATIONS";
    private static final String NOTICE_ID = "SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid from NOTIFICATIONS where NOTIFYID = ?";
    private static final String SENT_TO = "SELECT userid, notifytime, media, contactinfo FROM usersnotified WHERE notifyid=?";
    private static final String INSERT_NOTIFY = "INSERT INTO NOTIFICATIONS (notifyid, textmsg, numericmsg, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid) VALUES (NEXTVAL('notifyNxtId'), ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String OUTSTANDING = "SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid FROM NOTIFICATIONS WHERE respondTime is NULL";
    private static final String OUTSTANDING_COUNT = "SELECT COUNT(notifyid) AS TOTAL FROM NOTIFICATIONS WHERE respondTime is NULL";
    private static final String USER_OUTSTANDING = "SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid FROM NOTIFICATIONS WHERE (respondTime is NULL) AND notifications.notifyid in (SELECT DISTINCT usersnotified.notifyid FROM usersnotified WHERE usersnotified.userid=?)";
    private static final String USER_OUTSTANDING_COUNT = "SELECT COUNT(notifyid) AS TOTAL FROM NOTIFICATIONS WHERE (respondTime is NULL) AND notifications.notifyid in (SELECT DISTINCT usersnotified.notifyid FROM usersnotified WHERE usersnotified.userid=?)";

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    public Notification getNoticeInfo(int id) throws SQLException {
        Notification nbean = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(this.getClass(), new Object[]{conn});
        try {
            pstmt = conn.prepareStatement(NOTICE_ID);
            d.watch((Object)pstmt);
            pstmt.setInt(1, id);
            rs = pstmt.executeQuery();
            d.watch((Object)rs);
            Notification[] n = this.rs2NotifyBean(conn, rs);
            nbean = n.length > 0 ? n[0] : new Notification();
            rs.close();
            pstmt.close();
            PreparedStatement sentTo = conn.prepareStatement(SENT_TO);
            d.watch((Object)sentTo);
            sentTo.setInt(1, id);
            ResultSet sentToResults = sentTo.executeQuery();
            d.watch((Object)sentToResults);
            ArrayList<NoticeSentTo> sentToList = new ArrayList<NoticeSentTo>();
            while (sentToResults.next()) {
                NoticeSentTo newSentTo = new NoticeSentTo();
                newSentTo.setUserId(sentToResults.getString(USERID));
                Timestamp ts = sentToResults.getTimestamp(NOTICE_TIME);
                if (ts != null) {
                    newSentTo.setTime(ts.getTime());
                } else {
                    newSentTo.setTime(0L);
                }
                newSentTo.setMedia(sentToResults.getString(MEDIA));
                newSentTo.setContactInfo(sentToResults.getString(CONTACT));
                sentToList.add(newSentTo);
            }
            nbean.m_sentTo = sentToList;
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            d.cleanUp();
        }
        return nbean;
    }

    public Notification[] allNotifications() throws SQLException {
        return this.allNotifications(null);
    }

    public Notification[] allNotifications(String order) throws SQLException {
        Notification[] notices = null;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(this.getClass(), new Object[]{conn});
        try {
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            String query = SELECT;
            if (order != null) {
                if (order.equalsIgnoreCase("asc")) {
                    query = query + " ORDER BY pagetime ASC";
                } else if (order.equalsIgnoreCase("desc")) {
                    query = query + " ORDER BY pagetime DESC";
                }
            }
            query = query + ";";
            ResultSet rs = stmt.executeQuery(query);
            d.watch((Object)rs);
            notices = this.rs2NotifyBean(conn, rs);
        }
        catch (SQLException e) {
            this.log().error((Object)("allNotifications: Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            d.cleanUp();
        }
        return notices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getServiceName(Connection conn, Integer id) {
        if (id == null) {
            return null;
        }
        String serviceName = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        DBUtils d = new DBUtils(this.getClass());
        try {
            ps = conn.prepareStatement("SELECT servicename from service where serviceid = ?");
            d.watch((Object)ps);
            ps.setInt(1, id);
            rs = ps.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                serviceName = rs.getString("servicename");
            }
        }
        catch (SQLException e) {
            this.log().warn((Object)("unable to get service name for service ID '" + id + "'"), (Throwable)e);
        }
        finally {
            d.cleanUp();
        }
        return serviceName;
    }

    protected Notification[] rs2NotifyBean(Connection conn, ResultSet rs) throws SQLException {
        Notification[] notices = null;
        Vector<Notification> vector = new Vector<Notification>();
        try {
            while (rs.next()) {
                Notification nbean = new Notification();
                nbean.m_timeReply = 0L;
                nbean.m_txtMsg = rs.getString(TXT_MESG);
                nbean.m_numMsg = rs.getString(NUM_MESG);
                nbean.m_notifyID = rs.getInt(NOTIFY);
                if (rs.getTimestamp(TIME) != null) {
                    nbean.m_timeSent = rs.getTimestamp(TIME).getTime();
                }
                if (rs.getTimestamp(REPLYTIME) != null) {
                    nbean.m_timeReply = rs.getTimestamp(REPLYTIME).getTime();
                }
                nbean.m_responder = rs.getString(ANS_BY);
                nbean.m_nodeID = rs.getInt(NODE);
                nbean.m_interfaceID = rs.getString(INTERFACE);
                nbean.m_serviceId = rs.getInt(SERVICE);
                nbean.m_eventId = rs.getInt(EVENTID);
                nbean.m_serviceName = this.getServiceName(conn, nbean.m_serviceId);
                vector.addElement(nbean);
            }
        }
        catch (SQLException e) {
            this.log().error((Object)("Error occurred in rs2NotifyBean: " + e), (Throwable)e);
            throw e;
        }
        notices = new Notification[vector.size()];
        for (int i = 0; i < notices.length; ++i) {
            notices[i] = (Notification)vector.elementAt(i);
        }
        return notices;
    }

    public Notification[] getOutstandingNotices() throws SQLException {
        Notification[] notices = null;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(this.getClass(), new Object[]{conn});
        try {
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery(OUTSTANDING);
            d.watch((Object)rs);
            notices = this.rs2NotifyBean(conn, rs);
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            d.cleanUp();
        }
        return notices;
    }

    public int getOutstandingNoticeCount() throws SQLException {
        int count = 0;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(this.getClass(), new Object[]{conn});
        try {
            Statement stmt = conn.createStatement();
            d.watch((Object)stmt);
            ResultSet rs = stmt.executeQuery(OUTSTANDING_COUNT);
            d.watch((Object)rs);
            if (rs.next()) {
                count = rs.getInt("TOTAL");
            }
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            d.cleanUp();
        }
        return count;
    }

    public int getOutstandingNoticeCount(String username) throws SQLException {
        if (username == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int count = 0;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(this.getClass(), new Object[]{conn});
        try {
            PreparedStatement pstmt = conn.prepareStatement(USER_OUTSTANDING_COUNT);
            d.watch((Object)pstmt);
            pstmt.setString(1, username);
            ResultSet rs = pstmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                count = rs.getInt("TOTAL");
            }
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            d.cleanUp();
        }
        return count;
    }

    public Notification[] getOutstandingNotices(String name) throws SQLException {
        Notification[] notices = null;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(this.getClass(), new Object[]{conn});
        try {
            PreparedStatement pstmt = conn.prepareStatement(USER_OUTSTANDING);
            d.watch((Object)pstmt);
            pstmt.setString(1, name);
            ResultSet rs = pstmt.executeQuery();
            d.watch((Object)rs);
            notices = this.rs2NotifyBean(conn, rs);
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            d.cleanUp();
        }
        return notices;
    }

    public void acknowledged(String name, int noticeId) throws SQLException {
        if (name == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(this.getClass(), new Object[]{conn});
        try {
            PreparedStatement pstmt = conn.prepareStatement("UPDATE notifications SET respondtime = ? , answeredby = ? WHERE notifyid= ?");
            d.watch((Object)pstmt);
            pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(2, name);
            pstmt.setInt(3, noticeId);
            pstmt.execute();
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem acknowledging notification " + noticeId + " as answered by '" + name + "': " + e), (Throwable)e);
            throw e;
        }
        finally {
            d.cleanUp();
        }
    }

    public void insert(Notification nbean) throws SQLException {
        if (nbean == null || nbean.m_txtMsg == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(this.getClass(), new Object[]{conn});
        try {
            PreparedStatement pstmt = conn.prepareStatement(INSERT_NOTIFY);
            d.watch((Object)pstmt);
            pstmt.setString(1, nbean.m_txtMsg);
            pstmt.setString(2, nbean.m_numMsg);
            pstmt.setLong(3, nbean.m_timeSent);
            pstmt.setLong(4, nbean.m_timeReply);
            pstmt.setString(5, nbean.m_responder);
            pstmt.setInt(6, nbean.m_nodeID);
            pstmt.setString(7, nbean.m_interfaceID);
            pstmt.setInt(8, nbean.m_serviceId);
            pstmt.setInt(9, nbean.m_eventId);
            pstmt.execute();
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            d.cleanUp();
        }
    }
}

