/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.navigate;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opennms.web.navigate.DisplayStatus;
import org.opennms.web.navigate.NavBarEntry;

public class MenuDropdownNavBarEntry
implements NavBarEntry {
    private String m_name = null;
    private String m_url = null;
    private String m_contents = null;
    private List<NavBarEntry> m_entries = null;

    @Override
    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    @Override
    public String getName() {
        if (this.m_name == null || this.m_contents == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"nav-dropdown\">");
        sb.append("<a href=\"");
        if (this.m_url == null) {
            sb.append("#");
        } else {
            sb.append(this.m_url);
        }
        sb.append("\" class=\"nav-dropdown\">");
        sb.append(this.m_name);
        sb.append(" ");
        sb.append("<span class=\"nav-item\">\u25bc</span>");
        sb.append("</a>");
        sb.append("<ul>");
        sb.append(this.m_contents);
        sb.append("</ul>");
        sb.append("</div>");
        return sb.toString();
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public List<NavBarEntry> getEntries() {
        return this.m_entries;
    }

    public void setEntries(List<NavBarEntry> entries) {
        this.m_entries = entries;
    }

    @Override
    public DisplayStatus evaluate(HttpServletRequest request) {
        boolean display = false;
        if (this.m_entries != null) {
            StringBuilder sb = new StringBuilder();
            for (NavBarEntry entry : this.m_entries) {
                DisplayStatus status = entry.evaluate(request);
                switch (status) {
                    case DISPLAY_LINK: {
                        sb.append("<li><a href=\"" + entry.getUrl() + "\">" + entry.getName() + "</a></li>");
                        display = true;
                        break;
                    }
                    case DISPLAY_NO_LINK: {
                        sb.append("<li>" + entry.getName() + "</li>");
                        display = true;
                        break;
                    }
                }
            }
            this.m_contents = sb.toString();
        }
        return display ? DisplayStatus.DISPLAY_NO_LINK : DisplayStatus.NO_DISPLAY;
    }
}

