/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map.db.datasources;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.opennms.core.resource.Vault;
import org.opennms.core.resource.db.SimpleDbConnectionFactory;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.map.db.datasources.DataSourceInterface;

public class ServerDataSource
implements DataSourceInterface {
    private Map<?, ?> params;
    boolean initialized = false;
    private Map<String, String> severityMapping = new HashMap<String, String>();
    static ThreadCategory log;
    static final String STATUS_FIELD = "ev_status";
    static final String SEVERITY_FIELD = "ev_severity";
    static final String TABLE_NAME = "v_eventi_snm";
    final String CLOSED_STATUS = "CLOSED";
    final String ACK_STATUS = "ACK";
    final String ASSIGNED_STATUS = "ASSIGNED";
    final String OPEN_STATUS = "OPEN";
    static Connection opennmsConn;
    static Connection externalConn;

    public ServerDataSource(Map<?, ?> params) {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        log = ThreadCategory.getInstance(this.getClass());
        this.params = params;
        this.init();
    }

    public void init() {
        log.debug("Init...getting db connection");
        try {
            if (opennmsConn == null || opennmsConn.isClosed()) {
                opennmsConn = Vault.getDbConnection();
            }
            String url = (String)this.params.get("url");
            String driver = (String)this.params.get("driver");
            String user = (String)this.params.get("user");
            String password = (String)this.params.get("password");
            if (externalConn == null || externalConn.isClosed()) {
                log.debug("getting external db connection with parameters url=" + url + ", driver=" + driver + ", user=" + user + ", password=" + password);
                SimpleDbConnectionFactory dbConnFactory = new SimpleDbConnectionFactory();
                dbConnFactory.init(url, driver, user, password);
                externalConn = dbConnFactory.getConnection();
            }
        }
        catch (Throwable s) {
            log.error("Error while getting db Connection from Vault " + s);
            throw new RuntimeException(s);
        }
        this.severityMapping.put("6", "Critical");
        this.severityMapping.put("5", "Major");
        this.severityMapping.put("4", "Minor");
        this.severityMapping.put("3", "Warning");
        this.severityMapping.put("2", "Cleared");
        this.severityMapping.put("1", "Normal");
        this.severityMapping.put("0", "Indeterminate");
    }

    private boolean isInitialized() throws SQLException {
        return opennmsConn != null && !opennmsConn.isClosed() && externalConn != null && !externalConn.isClosed();
    }

    protected void finalize() throws Throwable {
        log.debug("Finalizing...closing db connections");
        super.finalize();
        if (opennmsConn != null) {
            Vault.releaseDbConnection((Connection)opennmsConn);
        }
        if (externalConn != null && !externalConn.isClosed()) {
            externalConn.close();
        }
    }

    @Override
    public String getSeverity(Object id) {
        String result = "-1";
        try {
            if (!this.isInitialized()) {
                this.init();
            }
        }
        catch (Throwable e) {
            log.error("exiting: error found " + e);
            return "-1";
        }
        Set<String> ipAddrs = this.getIpAddrById(id);
        if (ipAddrs.size() == 0) {
            log.warn("No ip address found for node with id " + (Integer)id);
            return "-1";
        }
        result = this.getSev(ipAddrs);
        if (result.equals("-1")) {
            log.warn("No severity found for element with id " + (Integer)id);
        }
        return result;
    }

    private Set<String> getIpAddrById(Object id) {
        String sqlQueryIFaces = "select distinct ipaddr from ipinterface where ipaddr!='0.0.0.0' and nodeid=?";
        HashSet<String> ipAddrs = new HashSet<String>();
        int nodeId = 0;
        try {
            nodeId = (Integer)id;
            PreparedStatement ps = opennmsConn.prepareStatement(sqlQueryIFaces);
            ps.setInt(1, nodeId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String ipAddr = rs.getString(1);
                ipAddrs.add(ipAddr);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            log.error("Error while getting ipaddress by id " + e);
        }
        return ipAddrs;
    }

    private String getSev(Set<String> ipAddrs) {
        String getDataQuery = "select max(ev_severity) from v_eventi_snm where ip_address in (";
        Iterator<String> it = ipAddrs.iterator();
        while (it.hasNext()) {
            String ip = it.next();
            getDataQuery = getDataQuery + "'" + ip + "'";
            if (!it.hasNext()) continue;
            getDataQuery = getDataQuery + ",";
        }
        getDataQuery = getDataQuery + ") and ev_status!='CLOSED'";
        log.debug("get severity query is " + getDataQuery);
        String value = null;
        try {
            Statement stmt = externalConn.createStatement();
            ResultSet rs = stmt.executeQuery(getDataQuery);
            if (rs.next()) {
                value = rs.getString(1);
                log.debug("found severity for ipaddresses " + ipAddrs + " with value " + value);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e1) {
            log.error("Exception while getting severity " + e1);
            return "-1";
        }
        String sevLabel = this.severityMapping.get(value);
        log.debug("Getting severity mapping for key=" + value + ": sevLabel=" + sevLabel);
        return sevLabel;
    }

    @Override
    public String getStatus(Object id) {
        String result = "-1";
        try {
            if (!this.isInitialized()) {
                this.init();
            }
        }
        catch (Throwable e) {
            log.error("exiting: error found " + e);
            return result;
        }
        Set<String> ipAddrs = this.getIpAddrById(id);
        if (ipAddrs.size() == 0) {
            log.warn("No ip address found for node with id " + (Integer)id);
            return result;
        }
        result = this.getSt(ipAddrs);
        if (result.equals("-1")) {
            log.warn("No severity found for element with id " + (Integer)id);
        }
        return result;
    }

    private String getSt(Set<String> ipAddrs) {
        String getDataQuery = "select ev_status from v_eventi_snm where ip_address in (";
        Iterator<String> it = ipAddrs.iterator();
        while (it.hasNext()) {
            String ip = it.next();
            getDataQuery = getDataQuery + "'" + ip + "'";
            if (!it.hasNext()) continue;
            getDataQuery = getDataQuery + ",";
        }
        getDataQuery = getDataQuery + ") and ev_status!='CLOSED'";
        String innerQuery = "select max(ev_severity) from v_eventi_snm where ip_address in (";
        Iterator<String> it2 = ipAddrs.iterator();
        while (it2.hasNext()) {
            String ip = it2.next();
            innerQuery = innerQuery + "'" + ip + "'";
            if (!it2.hasNext()) continue;
            innerQuery = innerQuery + ",";
        }
        innerQuery = innerQuery + ") and ev_status!='CLOSED'";
        getDataQuery = getDataQuery + " and ev_severity=(" + innerQuery + ")";
        log.debug("get status query is " + getDataQuery);
        String value = null;
        try {
            Statement stmt = externalConn.createStatement();
            ResultSet rs = stmt.executeQuery(getDataQuery);
            if (rs.next()) {
                value = rs.getString(1);
                log.debug("found status for ipaddresses " + ipAddrs + " with value " + value);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e1) {
            log.error("Exception while getting status " + e1);
            return "-1";
        }
        return value;
    }

    @Override
    public double getAvailability(Object id) {
        return -1.0;
    }

    static {
        opennmsConn = null;
        externalConn = null;
    }
}

