/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.map.view.Command;
import org.opennms.web.map.view.Manager;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class ExecCommandAjaxController
extends AbstractController {
    ThreadCategory log;
    private Manager manager;

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(((Object)((Object)this)).getClass());
        String id = request.getParameter("id");
        String command = request.getParameter("command");
        String address = request.getParameter("address");
        response.setBufferSize(0);
        response.setContentType("text/html");
        response.setHeader("pragma", "no-Cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "no-Cache");
        OutputStreamWriter os = new OutputStreamWriter((OutputStream)response.getOutputStream(), "UTF-8");
        try {
            if (id == null) {
                if (command == null) {
                    throw new IllegalArgumentException("Command or id is required");
                }
                if (address == null) {
                    throw new IllegalArgumentException("Address is required");
                }
                if (NetworkElementFactory.getInstance(this.getServletContext()).getInterfacesWithIpAddress(address).length == 0) {
                    os.write("NOADDRESSINDATABASE");
                } else if (!this.manager.checkCommandExecution()) {
                    os.write("NOEXECUTIONALLOWED");
                } else {
                    String commandToExec = this.getCommandToExec(request, command, address);
                    Command p = new Command(commandToExec);
                    this.log.info("Executing " + commandToExec);
                    os.write(this.manager.execCommand(p));
                }
            } else {
                this.log.info("Getting output for id: " + id);
                Command p = this.manager.getCommand(id);
                String s = p.getNextLine();
                if (p.runned() && s == null) {
                    this.log.info("Process ended and no more output for id: " + id);
                    this.manager.removeCommand(id);
                    os.write("END");
                } else if (s == null) {
                    os.write("BLANCK");
                    this.log.debug("no lines in buffer found");
                } else {
                    os.write(s);
                    this.log.debug("Got line: " + s);
                }
            }
        }
        catch (Throwable e) {
            this.log.error("An error occourred while executing command.", e);
            os.write("ERROR");
        }
        finally {
            os.flush();
            os.close();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getCommandToExec(HttpServletRequest request, String command, String address) {
        String commandToExec = command;
        int timeOut = 1;
        int numberOfRequest = 10;
        int packetSize = 56;
        String hopAddress = null;
        String numericoutput = request.getParameter("numericOutput");
        if (numericoutput != null && numericoutput.equals("true")) {
            commandToExec = commandToExec + " -n ";
        }
        if (command.equals("ping")) {
            String solaris;
            String packetsize;
            String numberofrequest;
            String timeout = request.getParameter("timeOut");
            if (timeout != null) {
                timeOut = WebSecurityUtils.safeParseInt((String)timeout);
            }
            if ((numberofrequest = request.getParameter("numberOfRequest")) != null) {
                numberOfRequest = WebSecurityUtils.safeParseInt((String)numberofrequest);
            }
            if ((packetsize = request.getParameter("packetSize")) != null) {
                packetSize = WebSecurityUtils.safeParseInt((String)packetsize);
            }
            if ((solaris = request.getParameter("solaris")) == null) return commandToExec + " -c " + numberOfRequest + " -i " + timeOut + " -s " + packetSize + " " + address;
            if (!solaris.equals("true")) return commandToExec + " -c " + numberOfRequest + " -i " + timeOut + " -s " + packetSize + " " + address;
            return commandToExec + " -I " + timeOut + " " + address + " " + packetSize + " " + numberOfRequest;
        }
        if (command.equals("traceroute")) {
            hopAddress = request.getParameter("hopAddress");
            if (hopAddress == null) return commandToExec + " " + address;
            return commandToExec + " -g " + hopAddress + " " + address;
        }
        if (!command.equals("ipmitool")) throw new IllegalStateException("Command " + command + " not supported.");
        String ipmiCommand = request.getParameter("ipmiCommand");
        String ipmiUserName = request.getParameter("ipmiUser");
        String ipmiPassword = request.getParameter("ipmiPassword");
        String ipmiProtocol = request.getParameter("ipmiProtocol");
        if (ipmiCommand == null) throw new IllegalStateException("IPMITool requires Protocol, Command, Usernane and Password");
        if (ipmiUserName == null) throw new IllegalStateException("IPMITool requires Protocol, Command, Usernane and Password");
        if (ipmiPassword == null) throw new IllegalStateException("IPMITool requires Protocol, Command, Usernane and Password");
        return commandToExec + " -I " + ipmiProtocol + " -U " + ipmiUserName + " -P " + ipmiPassword + " -H " + address + " " + ipmiCommand;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleRequest(request, response);
    }
}

