/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.mail;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.opennms.core.utils.StreamUtils;
import org.opennms.web.servlet.MissingParameterException;

public class MailerServlet
extends HttpServlet {
    private static final long serialVersionUID = -6241742874510146571L;
    protected static final String[] REQUIRED_FIELDS = new String[]{"sendto", "subject", "username", "msg"};
    protected String redirectSuccess;
    protected String mailProgram;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        this.redirectSuccess = config.getInitParameter("redirect.success");
        this.mailProgram = config.getInitParameter("mail.program");
        if (this.redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
        if (this.mailProgram == null) {
            throw new ServletException("Missing required init parameter: mail.program");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sendto = request.getParameter("sendto");
        String subject = request.getParameter("subject");
        String msg = request.getParameter("msg");
        String username = request.getRemoteUser();
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("To: " + sendto + ", Subject: " + subject + ", message: " + msg + ", username: " + username));
        }
        if (sendto == null) {
            throw new MissingParameterException("sendto", REQUIRED_FIELDS);
        }
        if (subject == null) {
            throw new MissingParameterException("subject", REQUIRED_FIELDS);
        }
        if (msg == null) {
            throw new MissingParameterException("msg", REQUIRED_FIELDS);
        }
        if (username == null) {
            username = "";
        }
        String[] cmdArgs = new String[]{this.mailProgram, "-s", subject, sendto};
        Process process = Runtime.getRuntime().exec(cmdArgs);
        PrintWriter stdinWriter = new PrintWriter(process.getOutputStream());
        stdinWriter.print(msg);
        stdinWriter.close();
        BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        if (err.ready()) {
            StringWriter tempErr = new StringWriter();
            StreamUtils.streamToStream((Reader)err, (Writer)tempErr);
            String errorMessage = tempErr.toString();
            this.log().warn((Object)("Read from stderr: " + errorMessage));
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            StreamUtils.streamToStream((Reader)new StringReader(errorMessage), (Writer)out);
            out.close();
        } else {
            response.sendRedirect(this.redirectSuccess);
        }
    }

    private Logger log() {
        return Logger.getLogger((String)"WEB.MAIL");
    }
}

