/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event.filter;

import javax.servlet.ServletContext;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.filter.EqualsFilter;
import org.opennms.web.filter.SQLType;
import org.springframework.context.ApplicationContext;

public class NodeFilter
extends EqualsFilter<Integer> {
    public static final String TYPE = "node";
    private ServletContext m_servletContext;
    private ApplicationContext m_appContext;

    public NodeFilter(int nodeId, ServletContext servletContext) {
        super(TYPE, SQLType.INT, "EVENTS.NODEID", "node.id", nodeId);
        this.m_servletContext = servletContext;
    }

    public NodeFilter(int nodeId, ApplicationContext appContext) {
        super(TYPE, SQLType.INT, "EVENTS.NODEID", "node.id", nodeId);
        this.m_appContext = appContext;
    }

    @Override
    public String getTextDescription() {
        String nodeName = this.getNodeLabel();
        if (nodeName == null) {
            nodeName = Integer.toString(this.getNodeId());
        }
        return "node=" + nodeName;
    }

    private String getNodeLabel() {
        return this.m_servletContext != null ? NetworkElementFactory.getInstance(this.m_servletContext).getNodeLabel(this.getNodeId()) : NetworkElementFactory.getInstance(this.m_appContext).getNodeLabel(this.getNodeId());
    }

    @Override
    public String toString() {
        return "<WebEventRepository.NodeFilter: " + this.getDescription() + ">";
    }

    public int getNodeId() {
        return (Integer)this.getValue();
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

