/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event.filter;

import javax.servlet.ServletContext;
import org.opennms.web.element.NetworkElementFactory;
import org.opennms.web.filter.NotEqualOrNullFilter;
import org.opennms.web.filter.SQLType;
import org.springframework.context.ApplicationContext;

public class NegativeNodeFilter
extends NotEqualOrNullFilter<Integer> {
    public static final String TYPE = "nodenot";
    private ServletContext m_servletContext;
    private ApplicationContext m_appContext;

    public NegativeNodeFilter(int nodeId, ServletContext servletContext) {
        super(TYPE, SQLType.INT, "EVENTS.NODEID", "node.id", nodeId);
        this.m_servletContext = servletContext;
    }

    public NegativeNodeFilter(int nodeId, ApplicationContext appContext) {
        super(TYPE, SQLType.INT, "EVENTS.NODEID", "node.id", nodeId);
        this.m_appContext = appContext;
    }

    @Override
    public String getTextDescription() {
        String nodeName = this.getNodeLabel();
        if (nodeName == null) {
            nodeName = Integer.toString((Integer)this.getValue());
        }
        return "node is not " + nodeName;
    }

    private String getNodeLabel() {
        return this.m_servletContext != null ? NetworkElementFactory.getInstance(this.m_servletContext).getNodeLabel((Integer)this.getValue()) : NetworkElementFactory.getInstance(this.m_appContext).getNodeLabel((Integer)this.getValue());
    }

    @Override
    public String toString() {
        return "<WebEventRepository.NegativeNodeFilter: " + this.getDescription() + ">";
    }

    public int getNodeId() {
        return (Integer)this.getValue();
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

