/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.event;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.Event;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.filter.IfIndexFilter;
import org.opennms.web.event.filter.InterfaceFilter;
import org.opennms.web.event.filter.NodeFilter;
import org.opennms.web.event.filter.ServiceFilter;
import org.opennms.web.event.filter.SeverityFilter;
import org.opennms.web.filter.Filter;

public class EventFactory {
    private EventFactory() {
    }

    public static int getEventCount() throws SQLException {
        return EventFactory.getEventCount(AcknowledgeType.UNACKNOWLEDGED, new Filter[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEventCount(AcknowledgeType ackType, Filter[] filters) throws SQLException {
        if (ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int eventCount = 0;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            StringBuffer select = new StringBuffer("SELECT COUNT(EVENTID) AS EVENTCOUNT FROM EVENTS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) WHERE ");
            select.append(EventFactory.getAcknowledgeTypeClause(ackType));
            for (Filter filter : filters) {
                select.append(" AND");
                select.append(filter.getParamSql());
            }
            select.append(" AND EVENTDISPLAY='Y' ");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                eventCount = rs.getInt("EVENTCOUNT");
            }
            stmt.close();
        }
        finally {
            d.cleanUp();
        }
        return eventCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getEventCountBySeverity(AcknowledgeType ackType, Filter[] filters) throws SQLException {
        if (ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int[] eventCounts = new int[8];
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            StringBuffer select = new StringBuffer("SELECT EVENTSEVERITY, COUNT(*) AS EVENTCOUNT FROM EVENTS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) WHERE ");
            select.append(EventFactory.getAcknowledgeTypeClause(ackType));
            for (Filter filter : filters) {
                select.append(" AND");
                select.append(filter.getParamSql());
            }
            select.append(" AND EVENTDISPLAY='Y'");
            select.append(" GROUP BY EVENTSEVERITY");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                int eventCount;
                int severity = rs.getInt("EVENTSEVERITY");
                eventCounts[severity] = eventCount = rs.getInt("EVENTCOUNT");
            }
        }
        finally {
            d.cleanUp();
        }
        return eventCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event getEvent(int eventId) throws SQLException {
        Event event = null;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            PreparedStatement stmt = conn.prepareStatement("SELECT EVENTS.*, NODE.NODELABEL, SERVICE.SERVICENAME FROM EVENTS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) WHERE EVENTID=? ");
            d.watch((Object)stmt);
            stmt.setInt(1, eventId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Event[] events = EventFactory.rs2Events(rs);
            if (events.length > 0) {
                event = events[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return event;
    }

    public static Event[] getEvents() throws SQLException {
        return EventFactory.getEvents(SortStyle.TIME, AcknowledgeType.UNACKNOWLEDGED);
    }

    public static Event[] getEvents(AcknowledgeType ackType) throws SQLException {
        return EventFactory.getEvents(SortStyle.TIME, ackType);
    }

    public static Event[] getEvents(SortStyle sortStyle) throws SQLException {
        return EventFactory.getEvents(sortStyle, AcknowledgeType.UNACKNOWLEDGED);
    }

    public static Event[] getEvents(SortStyle sortStyle, boolean includeAcknowledged) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEvents(sortStyle, ackType);
    }

    public static Event[] getEvents(SortStyle sortStyle, AcknowledgeType ackType) throws SQLException {
        return EventFactory.getEvents(sortStyle, ackType, new Filter[0]);
    }

    public static Event[] getEvents(SortStyle sortStyle, AcknowledgeType ackType, Filter[] filters) throws SQLException {
        return EventFactory.getEvents(sortStyle, ackType, filters, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event[] getEvents(SortStyle sortStyle, AcknowledgeType ackType, Filter[] filters, int limit, int offset) throws SQLException {
        if (sortStyle == null || ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        boolean useLimits = false;
        if (limit > 0 && offset > -1) {
            useLimits = true;
        }
        Event[] events = null;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            StringBuffer select = new StringBuffer("          SELECT events.*, node.nodelabel, service.servicename             FROM node RIGHT OUTER JOIN events               ON (events.nodeid = node.nodeid)  LEFT OUTER JOIN service               ON (service.serviceid = events.serviceid)            WHERE ");
            select.append(EventFactory.getAcknowledgeTypeClause(ackType));
            for (Filter filter : filters) {
                select.append(" AND");
                select.append(filter.getParamSql());
            }
            select.append(" AND EVENTDISPLAY='Y' ");
            select.append(EventFactory.getOrderByClause(sortStyle));
            if (useLimits) {
                select.append(" LIMIT ");
                select.append(limit);
                select.append(" OFFSET ");
                select.append(offset);
            }
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            events = EventFactory.rs2Events(rs);
        }
        finally {
            d.cleanUp();
        }
        return events;
    }

    public static Event[] getEventsForNode(int nodeId, ServletContext servletContext) throws SQLException {
        return EventFactory.getEventsForNode(nodeId, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Event[] getEventsForNode(int nodeId, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForNode(nodeId, SortStyle.ID, ackType, -1, -1, servletContext);
    }

    public static Event[] getEventsForNode(int nodeId, SortStyle sortStyle, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        return EventFactory.getEventsForNode(nodeId, sortStyle, ackType, -1, -1, servletContext);
    }

    public static Event[] getEventsForNode(int nodeId, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEventCountForNode(int nodeId, AcknowledgeType ackType) throws SQLException {
        if (ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int eventCount = 0;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            StringBuffer select = new StringBuffer("SELECT COUNT(EVENTID) AS EVENTCOUNT FROM EVENTS WHERE ");
            select.append(EventFactory.getAcknowledgeTypeClause(ackType));
            select.append(" AND NODEID=?");
            select.append(" AND EVENTDISPLAY='Y' ");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                eventCount = rs.getInt("EVENTCOUNT");
            }
        }
        finally {
            d.cleanUp();
        }
        return eventCount;
    }

    public static Event[] getEventsForInterface(int nodeId, String ipAddress, ServletContext servletContext) throws SQLException {
        return EventFactory.getEventsForInterface(nodeId, ipAddress, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Event[] getEventsForInterface(int nodeId, String ipAddress, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForInterface(nodeId, ipAddress, SortStyle.ID, ackType, -1, -1, servletContext);
    }

    public static Event[] getEventsForInterface(int nodeId, String ipAddress, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    public static Event[] getEventsForInterface(int nodeId, int ifIndex, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new IfIndexFilter(ifIndex)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    public static Event[] getEventsForInterface(String ipAddress) throws SQLException {
        return EventFactory.getEventsForInterface(ipAddress, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1);
    }

    public static Event[] getEventsForInterface(String ipAddress, boolean includeAcknowledged) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForInterface(ipAddress, SortStyle.ID, ackType, -1, -1);
    }

    public static Event[] getEventsForInterface(String ipAddress, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset) throws SQLException {
        if (ipAddress == null || sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new InterfaceFilter(ipAddress)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    public static int getEventCountForInterface(int nodeId, String ipAddress, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress)};
        return EventFactory.getEventCount(ackType, filters);
    }

    public static int getEventCountForInterface(String ipAddress, AcknowledgeType ackType) throws SQLException {
        if (ipAddress == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new InterfaceFilter(ipAddress)};
        return EventFactory.getEventCount(ackType, filters);
    }

    public static Event[] getEventsForService(int nodeId, String ipAddress, int serviceId, ServletContext servletContext) throws SQLException {
        return EventFactory.getEventsForService(nodeId, ipAddress, serviceId, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Event[] getEventsForService(int nodeId, String ipAddress, int serviceId, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForService(nodeId, ipAddress, serviceId, SortStyle.ID, ackType, -1, -1, servletContext);
    }

    public static Event[] getEventsForService(int nodeId, String ipAddress, int serviceId, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress), new ServiceFilter(serviceId, servletContext)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    public static Event[] getEventsForService(int serviceId, ServletContext servletContext) throws SQLException {
        return EventFactory.getEventsForService(serviceId, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Event[] getEventsForService(int serviceId, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForService(serviceId, SortStyle.ID, ackType, -1, -1, servletContext);
    }

    public static Event[] getEventsForService(int serviceId, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new ServiceFilter(serviceId, servletContext)};
        return EventFactory.getEvents(sortStyle, ackType, filters, throttle, offset);
    }

    public static int getEventCountForService(int nodeId, String ipAddress, int serviceId, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress), new ServiceFilter(serviceId, servletContext)};
        return EventFactory.getEventCount(ackType, filters);
    }

    public static int getEventCountForService(int serviceId, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new ServiceFilter(serviceId, servletContext)};
        return EventFactory.getEventCount(ackType, filters);
    }

    public static Event[] getEventsForSeverity(int severity) throws SQLException {
        return EventFactory.getEventsForSeverity(severity, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED);
    }

    public static Event[] getEventsForSeverity(int severity, boolean includeAcknowledged) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return EventFactory.getEventsForSeverity(severity, SortStyle.ID, ackType);
    }

    public static Event[] getEventsForSeverity(int severity, SortStyle sortStyle, AcknowledgeType ackType) throws SQLException {
        return EventFactory.getEvents(sortStyle, ackType, new Filter[]{new SeverityFilter(severity)});
    }

    public static Event[] getEventsForPoller(String poller) throws SQLException {
        return EventFactory.getEventsForPoller(poller, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event[] getEventsForPoller(String poller, boolean includeAcknowledged) throws SQLException {
        if (poller == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Event[] events = null;
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
        try {
            StringBuffer select = new StringBuffer("SELECT * FROM EVENTS WHERE EVENTDPNAME=?");
            if (!includeAcknowledged) {
                select.append(" AND EVENTACKUSER IS NULL");
            }
            select.append(" AND EVENTDISPLAY='Y' ");
            select.append(" ORDER BY EVENTID DESC");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            stmt.setString(1, poller);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            events = EventFactory.rs2Events(rs);
        }
        finally {
            d.cleanUp();
        }
        return events;
    }

    public static void acknowledge(Event[] events, String user) throws SQLException {
        EventFactory.acknowledge(events, user, new Date());
    }

    public static void acknowledge(Event[] events, String user, Date time) throws SQLException {
        if (events == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int[] ids = new int[events.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = events[i].getId();
        }
        EventFactory.acknowledge(ids, user, time);
    }

    public static void acknowledge(int[] eventIds, String user) throws SQLException {
        EventFactory.acknowledge(eventIds, user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acknowledge(int[] eventIds, String user, Date time) throws SQLException {
        if (eventIds == null || user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (eventIds.length > 0) {
            StringBuffer update = new StringBuffer("UPDATE EVENTS SET EVENTACKUSER=?, EVENTACKTIME=?");
            update.append(" WHERE EVENTID IN (");
            update.append(eventIds[0]);
            for (int i = 1; i < eventIds.length; ++i) {
                update.append(",");
                update.append(eventIds[i]);
            }
            update.append(")");
            update.append(" AND EVENTACKUSER IS NULL");
            Connection conn = Vault.getDbConnection();
            DBUtils d = new DBUtils(EventFactory.class, new Object[]{conn});
            try {
                PreparedStatement stmt = conn.prepareStatement(update.toString());
                d.watch((Object)stmt);
                stmt.setString(1, user);
                stmt.setTimestamp(2, new Timestamp(time.getTime()));
                stmt.executeUpdate();
            }
            finally {
                d.cleanUp();
            }
        }
    }

    public static void acknowledge(Filter[] filters, String user) throws SQLException {
        EventFactory.acknowledge(filters, user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acknowledge(Filter[] filters, String user, Date time) throws SQLException {
        if (filters == null || user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuffer update = new StringBuffer("UPDATE EVENTS SET EVENTACKUSER=?, EVENTACKTIME=? WHERE");
        update.append(EventFactory.getAcknowledgeTypeClause(AcknowledgeType.UNACKNOWLEDGED));
        for (Filter filter : filters) {
            update.append(" AND");
            update.append(filter.getParamSql());
        }
        DBUtils d = new DBUtils(EventFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(update.toString());
            d.watch((Object)stmt);
            stmt.setString(1, user);
            stmt.setTimestamp(2, new Timestamp(time.getTime()));
            int parameterIndex = 3;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    public static void acknowledgeAll(String user) throws SQLException {
        EventFactory.acknowledgeAll(user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acknowledgeAll(String user, Date time) throws SQLException {
        if (user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        DBUtils d = new DBUtils(EventFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("UPDATE EVENTS SET EVENTACKUSER=?, EVENTACKTIME=? WHERE EVENTACKUSER IS NULL");
            d.watch((Object)stmt);
            stmt.setString(1, user);
            stmt.setTimestamp(2, new Timestamp(time.getTime()));
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    public static void unacknowledge(Event[] events) throws SQLException {
        if (events == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int[] ids = new int[events.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = events[i].getId();
        }
        EventFactory.unacknowledge(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unacknowledge(int[] eventIds) throws SQLException {
        if (eventIds == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (eventIds.length > 0) {
            StringBuffer update = new StringBuffer("UPDATE EVENTS SET EVENTACKUSER=NULL, EVENTACKTIME=NULL");
            update.append(" WHERE EVENTID IN (");
            update.append(eventIds[0]);
            for (int i = 1; i < eventIds.length; ++i) {
                update.append(",");
                update.append(eventIds[i]);
            }
            update.append(")");
            DBUtils d = new DBUtils(EventFactory.class);
            try {
                Connection conn = Vault.getDbConnection();
                d.watch((Object)conn);
                PreparedStatement stmt = conn.prepareStatement(update.toString());
                d.watch((Object)stmt);
                stmt.executeUpdate();
            }
            finally {
                d.cleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unacknowledge(Filter[] filters) throws SQLException {
        if (filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuffer update = new StringBuffer("UPDATE EVENTS SET EVENTACKUSER=NULL, EVENTACKTIME=NULL WHERE");
        update.append(EventFactory.getAcknowledgeTypeClause(AcknowledgeType.ACKNOWLEDGED));
        for (Filter filter : filters) {
            update.append(" AND");
            update.append(filter.getParamSql());
        }
        DBUtils d = new DBUtils(EventFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(update.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (Filter filter : filters) {
                parameterIndex += filter.bindParam(stmt, parameterIndex);
            }
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unacknowledgeAll() throws SQLException {
        DBUtils d = new DBUtils(EventFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("UPDATE EVENTS SET EVENTACKUSER=NULL, EVENTACKTIME=NULL WHERE EVENTACKUSER IS NOT NULL");
            d.watch((Object)stmt);
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    protected static Event[] rs2Events(ResultSet rs) throws SQLException {
        Event[] events = null;
        Vector<Event> vector = new Vector<Event>();
        while (rs.next()) {
            Event event = new Event();
            Object element = rs.getInt("eventID");
            event.id = (Integer)element;
            element = rs.getString("eventUei");
            event.uei = (String)element;
            element = rs.getString("eventSnmp");
            event.snmp = (String)element;
            element = rs.getTimestamp("eventTime");
            event.time = new Date(((Timestamp)element).getTime());
            element = rs.getString("eventHost");
            event.host = (String)element;
            element = rs.getString("eventSnmpHost");
            event.snmphost = (String)element;
            element = rs.getString("eventDpName");
            event.dpName = (String)element;
            element = rs.getString("eventParms");
            event.parms = (String)element;
            element = rs.getObject("nodeID");
            event.nodeID = element == null ? Integer.valueOf(0) : (Integer)element;
            element = rs.getString("ipAddr");
            event.ipAddr = (String)element;
            element = rs.getObject("serviceID");
            event.serviceID = (Integer)element;
            element = rs.getString("nodeLabel");
            event.nodeLabel = (String)element;
            element = rs.getString("serviceName");
            event.serviceName = (String)element;
            element = rs.getTimestamp("eventCreateTime");
            event.createTime = new Date(((Timestamp)element).getTime());
            element = rs.getString("eventDescr");
            event.description = (String)element;
            element = rs.getString("eventLoggroup");
            event.logGroup = (String)element;
            element = rs.getString("eventLogmsg");
            event.logMessage = (String)element;
            element = OnmsSeverity.get((int)rs.getInt("eventSeverity"));
            event.severity = (OnmsSeverity)element;
            element = rs.getString("eventOperInstruct");
            event.operatorInstruction = (String)element;
            element = rs.getString("eventAutoAction");
            event.autoAction = (String)element;
            element = rs.getString("eventOperAction");
            event.operatorAction = (String)element;
            element = rs.getString("eventOperActionMenuText");
            event.operatorActionMenuText = (String)element;
            element = rs.getString("eventNotification");
            event.notification = (String)element;
            element = rs.getString("eventTticket");
            event.troubleTicket = (String)element;
            element = rs.getObject("eventTticketState");
            event.troubleTicketState = (Integer)element;
            element = rs.getString("eventForward");
            event.forward = (String)element;
            element = rs.getString("eventMouseOverText");
            event.mouseOverText = (String)element;
            element = rs.getString("eventAckUser");
            event.acknowledgeUser = (String)element;
            element = rs.getTimestamp("eventAckTime");
            if (element != null) {
                event.acknowledgeTime = new Date(((Timestamp)element).getTime());
            }
            element = rs.getObject("alarmid");
            event.alarmId = (Integer)element;
            vector.addElement(event);
        }
        events = new Event[vector.size()];
        for (int i = 0; i < events.length; ++i) {
            events[i] = (Event)vector.elementAt(i);
        }
        return events;
    }

    protected static String getOrderByClause(SortStyle sortStyle) {
        if (sortStyle == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return sortStyle.getOrderByClause();
    }

    protected static String getAcknowledgeTypeClause(AcknowledgeType ackType) {
        if (ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return ackType.getAcknowledgeTypeClause();
    }
}

