/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.element;

import java.net.InetAddress;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;

public class SnmpIfAdmin {
    SnmpAgentConfig m_agent = null;
    int nodeid = -1;
    public static final int NULL = 0;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int TESTING = 3;
    private static final String[] m_value = new String[]{"null", "up", "down", "testing"};
    private static final String snmpObjectId = ".1.3.6.1.2.1.2.2.1.7";

    public SnmpIfAdmin(int nodeid, SnmpAgentConfig agent) throws SocketException {
        this.m_agent = agent;
        this.nodeid = nodeid;
    }

    public SnmpIfAdmin(int nodeid, InetAddress inetAddress, String community) throws SocketException, Exception {
        this.nodeid = nodeid;
        this.m_agent = new SnmpAgentConfig(inetAddress);
        this.m_agent.setWriteCommunity(community);
    }

    public boolean setIfAdminUp(int ifindex) throws SQLException {
        return this.setIfAdmin(ifindex, 1);
    }

    public boolean setIfAdminDown(int ifindex) throws SQLException {
        return this.setIfAdmin(ifindex, 2);
    }

    public boolean isIfAdminStatusUp() {
        return this.getIfAdminStatus(1) == 1;
    }

    public boolean isIfAdminStatusDown() {
        return this.getIfAdminStatus(2) == 2;
    }

    public int getIfAdminStatus(int ifindex) {
        SnmpObjId oid = SnmpObjId.get((String)(".1.3.6.1.2.1.2.2.1.7." + ifindex));
        SnmpValue status = SnmpUtils.get((SnmpAgentConfig)this.m_agent, (SnmpObjId)oid);
        return status.toInt();
    }

    public static String getReadableAdminStatus(int value) {
        return m_value[value];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIfAdminStatusInDB(int ifindex, int value) throws SQLException {
        DBUtils d = new DBUtils(this.getClass());
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("update snmpinterface set snmpifadminstatus = ? where nodeid = ? and snmpifindex=?;");
            d.watch((Object)stmt);
            stmt.setInt(1, value);
            stmt.setInt(2, this.nodeid);
            stmt.setInt(3, ifindex);
            stmt.execute();
        }
        finally {
            d.cleanUp();
        }
    }

    public boolean setIfAdmin(int ifindex, int value) throws SQLException {
        SnmpValue val;
        if (value != 1 && value != 2) {
            throw new IllegalArgumentException("Value not valid");
        }
        SnmpObjId oid = SnmpObjId.get((String)(".1.3.6.1.2.1.2.2.1.7." + ifindex));
        SnmpValue result = SnmpUtils.set((SnmpAgentConfig)this.m_agent, (SnmpObjId)oid, (SnmpValue)(val = SnmpUtils.getValueFactory().getInt32(value)));
        if (result != null && result.isNumeric()) {
            int retvalue = result.toInt();
            this.setIfAdminStatusInDB(ifindex, retvalue);
            if (retvalue == value) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidState(int status) {
        return status == 1 && status == 2;
    }
}

