/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.ksc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.web.graph.KscResultSet;
import org.opennms.web.servlet.MissingParameterException;
import org.opennms.web.svclayer.KscReportService;
import org.opennms.web.svclayer.ResourceService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class CustomViewController
extends AbstractController
implements InitializingBean {
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private KscReportService m_kscReportService;
    private ResourceService m_resourceService;
    private int m_defaultGraphsPerLine = 0;
    private Executor m_executor;
    private Set<String> m_resourcesPendingPromotion = Collections.synchronizedSet(new HashSet());

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        OnmsResource resource;
        String overrideGraphType;
        String overrideTimespan;
        String[] requiredParameters = new String[]{"report", "type"};
        int reportId = -1;
        String reportType = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.type.toString()));
        String reportIdString = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.report.toString()));
        if (reportType == null) {
            throw new MissingParameterException(Parameters.type.toString(), requiredParameters);
        }
        if (reportIdString == null) {
            throw new MissingParameterException(Parameters.report.toString(), requiredParameters);
        }
        if (reportType.equals("node") || reportType.equals("custom")) {
            reportId = WebSecurityUtils.safeParseInt((String)reportIdString);
        }
        if ("null".equals(overrideTimespan = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.timespan.toString()))) || "none".equals(overrideTimespan)) {
            overrideTimespan = null;
        }
        if ("null".equals(overrideGraphType = WebSecurityUtils.sanitizeString((String)request.getParameter(Parameters.graphtype.toString()))) || "none".equals(overrideGraphType)) {
            overrideGraphType = null;
        }
        Report report = null;
        if ("node".equals(reportType)) {
            CustomViewController.log().debug("handleRequestInternal: buildNodeReport(reportId) " + reportId);
            report = this.getKscReportService().buildNodeReport(reportId);
        } else if ("nodeSource".equals(reportType)) {
            CustomViewController.log().debug("handleRequestInternal: buildNodeSourceReport(nodeSource) " + reportIdString);
            report = this.getKscReportService().buildNodeSourceReport(reportIdString);
        } else if ("domain".equals(reportType)) {
            CustomViewController.log().debug("handleRequestInternal: buildDomainReport(reportIdString) " + reportIdString);
            report = this.getKscReportService().buildDomainReport(reportIdString);
        } else if ("custom".equals(reportType)) {
            CustomViewController.log().debug("handleRequestInternal: getReportByIndex(reportId) " + reportId);
            report = this.m_kscReportFactory.getReportByIndex(reportId);
            if (report == null) {
                throw new ServletException("Report could not be found in config file for index '" + reportId + "'");
            }
        } else {
            throw new IllegalArgumentException("value to 'type' parameter of '" + reportType + "' is not supported.  Must be one of: node, nodeSource, domain, or custom");
        }
        HashMap<String, OnmsResource> resourceMap = new HashMap<String, OnmsResource>();
        TreeSet<PrefabGraph> prefabGraphs = new TreeSet<PrefabGraph>();
        this.removeBrokenGraphsFromReport(report);
        List graphCollection = report.getGraphCollection();
        if (!graphCollection.isEmpty()) {
            List<OnmsResource> resources = this.getKscReportService().getResourcesFromGraphs(graphCollection);
            for (int i = 0; i < graphCollection.size(); ++i) {
                Graph graph = (Graph)graphCollection.get(i);
                resource = null;
                try {
                    resource = resources.get(i);
                }
                catch (IndexOutOfBoundsException e) {
                    CustomViewController.log().debug("Resource List Index Out Of Bounds Caught ", (Throwable)e);
                }
                resourceMap.put(graph.toString(), resource);
                if (resource == null) {
                    CustomViewController.log().debug("Could not get resource for graph " + graph + " in report " + report.getTitle());
                    continue;
                }
                prefabGraphs.addAll(Arrays.asList(this.getResourceService().findPrefabGraphsForResource(resource)));
            }
            if (("node".equals(reportType) || "nodeSource".equals(reportType) || "domain".equals(reportType)) && overrideGraphType == null && !prefabGraphs.isEmpty()) {
                overrideGraphType = ((PrefabGraph)prefabGraphs.iterator().next()).getName();
                if (CustomViewController.log().isDebugEnabled()) {
                    CustomViewController.log().debug("custom_view: setting default graph type to " + overrideGraphType);
                }
            }
        }
        ArrayList<KscResultSet> resultSets = new ArrayList<KscResultSet>(report.getGraphCount());
        for (Graph graph : graphCollection) {
            PrefabGraph displayGraph;
            resource = (OnmsResource)resourceMap.get(graph.toString());
            if (resource != null) {
                this.promoteResourceAttributesIfNecessary(resource);
            }
            String displayGraphType = overrideGraphType == null ? graph.getGraphtype() : overrideGraphType;
            try {
                displayGraph = this.getResourceService().getPrefabGraph(displayGraphType);
            }
            catch (ObjectRetrievalFailureException e) {
                if (CustomViewController.log().isDebugEnabled()) {
                    CustomViewController.log().debug("The prefabricated graph '" + displayGraphType + "' does not exist: " + (Object)((Object)e), (Throwable)e);
                }
                displayGraph = null;
            }
            boolean foundGraph = false;
            if (resource != null) {
                for (PrefabGraph availableGraph : this.getResourceService().findPrefabGraphsForResource(resource)) {
                    if (!availableGraph.equals(displayGraph)) continue;
                    foundGraph = true;
                    break;
                }
            }
            if (!foundGraph) {
                displayGraph = null;
            }
            String displayTimespan = null;
            displayTimespan = overrideTimespan == null ? graph.getTimespan() : overrideTimespan;
            Calendar beginTime = Calendar.getInstance();
            Calendar endTime = Calendar.getInstance();
            KSC_PerformanceReportFactory.getBeginEndTime((String)displayTimespan, (Calendar)beginTime, (Calendar)endTime);
            KscResultSet resultSet = new KscResultSet(graph.getTitle(), beginTime.getTime(), endTime.getTime(), resource, displayGraph);
            resultSets.add(resultSet);
        }
        ModelAndView modelAndView = new ModelAndView("KSC/customView");
        modelAndView.addObject("loggedIn", (Object)(request.getRemoteUser() != null ? 1 : 0));
        modelAndView.addObject("reportType", (Object)reportType);
        if (report != null) {
            modelAndView.addObject("report", (Object)reportIdString);
        }
        modelAndView.addObject("title", (Object)report.getTitle());
        modelAndView.addObject("resultSets", resultSets);
        if (report.getShow_timespan_button()) {
            if (overrideTimespan == null || !this.getKscReportService().getTimeSpans(true).containsKey(overrideTimespan)) {
                modelAndView.addObject("timeSpan", (Object)"none");
            } else {
                modelAndView.addObject("timeSpan", (Object)overrideTimespan);
            }
            modelAndView.addObject("timeSpans", this.getKscReportService().getTimeSpans(true));
        } else {
            modelAndView.addObject("timeSpan", null);
        }
        if (report.getShow_graphtype_button()) {
            LinkedHashMap<String, String> graphTypes = new LinkedHashMap<String, String>();
            graphTypes.put("none", "none");
            for (PrefabGraph graphOption : prefabGraphs) {
                graphTypes.put(graphOption.getName(), graphOption.getName());
            }
            if (overrideGraphType == null || !graphTypes.containsKey(overrideGraphType)) {
                modelAndView.addObject("graphType", (Object)"none");
            } else {
                modelAndView.addObject("graphType", (Object)overrideGraphType);
            }
            modelAndView.addObject("graphTypes", graphTypes);
        } else {
            modelAndView.addObject("graphType", null);
        }
        modelAndView.addObject("showCustomizeButton", (Object)((request.isUserInRole("ROLE_ADMIN") || !request.isUserInRole("ROLE_READONLY")) && request.getRemoteUser() != null ? 1 : 0));
        if (report.getGraphs_per_line() > 0) {
            modelAndView.addObject("graphsPerLine", (Object)report.getGraphs_per_line());
        } else {
            modelAndView.addObject("graphsPerLine", (Object)this.getDefaultGraphsPerLine());
        }
        return modelAndView;
    }

    private void removeBrokenGraphsFromReport(Report report) {
        Iterator itr = report.getGraphCollection().iterator();
        while (itr.hasNext()) {
            Graph graph = (Graph)itr.next();
            try {
                this.getKscReportService().getResourceFromGraph(graph);
            }
            catch (ObjectRetrievalFailureException orfe) {
                CustomViewController.log().error("Removing graph '" + graph.getTitle() + "' in KSC report '" + report.getTitle() + "' because the resource it refers to could not be found. Perhaps resource '" + graph.getResourceId() + "' (or its ancestor) referenced by this graph no longer exists?");
                itr.remove();
            }
            catch (Throwable e) {
                CustomViewController.log().error("Unexpected error while scanning through graphs in report: " + e.getMessage(), e);
                itr.remove();
            }
        }
    }

    private void promoteResourceAttributesIfNecessary(final OnmsResource resource) {
        boolean needToSchedule = false;
        if (resource != null && resource.getId() != null) {
            needToSchedule = this.m_resourcesPendingPromotion.add(resource.getId());
        }
        if (needToSchedule) {
            this.m_executor.execute(new Runnable(){

                @Override
                public void run() {
                    CustomViewController.this.getResourceService().promoteGraphAttributesForResource(resource);
                    CustomViewController.this.m_resourcesPendingPromotion.remove(resource.getId());
                }
            });
        }
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(CustomViewController.class);
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public int getDefaultGraphsPerLine() {
        return this.m_defaultGraphsPerLine;
    }

    public void setDefaultGraphsPerLine(int defaultGraphsPerLine) {
        Assert.isTrue((defaultGraphsPerLine > 0 ? 1 : 0) != 0, (String)"property defaultGraphsPerLine must be greater than zero");
        this.m_defaultGraphsPerLine = defaultGraphsPerLine;
    }

    public KscReportService getKscReportService() {
        return this.m_kscReportService;
    }

    public void setKscReportService(KscReportService kscReportService) {
        this.m_kscReportService = kscReportService;
    }

    public ResourceService getResourceService() {
        return this.m_resourceService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.m_resourceService = resourceService;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"property kscReportFactory must be set");
        Assert.state((this.m_kscReportService != null ? 1 : 0) != 0, (String)"property kscReportService must be set");
        Assert.state((this.m_resourceService != null ? 1 : 0) != 0, (String)"property resourceService must be set");
        Assert.state((this.m_defaultGraphsPerLine != 0 ? 1 : 0) != 0, (String)"property defaultGraphsPerLine must be set");
        this.m_executor = Executors.newSingleThreadExecutor((ThreadFactory)new LogPreservingThreadFactory(((Object)((Object)this)).getClass().getSimpleName(), 1, false));
    }

    public static enum Parameters {
        report,
        type,
        timespan,
        graphtype;

    }
}

