/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.admin.support;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.core.utils.LogUtils;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.web.controller.admin.support.SystemReportException;
import org.opennms.web.controller.admin.support.SystemReportInfo;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.InternalResourceView;

public final class FormatterView
implements View {
    private SystemReportFormatter m_formatter = null;
    private InternalResourceView m_view = null;

    public FormatterView(SystemReportFormatter formatter) {
        this.m_formatter = formatter;
        if (this.m_formatter == null || !this.m_formatter.needsOutputStream() || this.m_formatter.getContentType() == null) {
            this.m_view = new InternalResourceView("/admin/support/systemReportList.htm");
        }
        LogUtils.debugf((Object)this, (String)"formatter = %s, view = %s", (Object[])new Object[]{this.m_formatter, this.m_view});
    }

    public String getContentType() {
        if (this.m_view != null) {
            return this.m_view.getContentType();
        }
        if (this.m_formatter == null) {
            return "application/octet-stream";
        }
        return this.m_formatter.getContentType();
    }

    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.m_view == null) {
            String fileName = this.getFileName(request);
            response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        } else {
            String outputParameter = request.getParameter("output");
            this.m_formatter.setOutput(outputParameter);
        }
        if (model.containsKey("report")) {
            SystemReportInfo info = (SystemReportInfo)model.get("report");
            LogUtils.debugf((Object)this, (String)"found report = %s", (Object[])new Object[]{info});
            Object output = this.m_view == null ? response.getOutputStream() : new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            };
            try {
                LogUtils.debugf((Object)this, (String)"beginning output", (Object[])new Object[0]);
                this.m_formatter.setOutputStream((OutputStream)output);
                this.m_formatter.begin();
                for (SystemReportPlugin plugin : info.getPlugins()) {
                    LogUtils.debugf((Object)this, (String)"running plugin %s", (Object[])new Object[]{plugin});
                    this.m_formatter.write(plugin);
                    ((OutputStream)output).flush();
                }
                LogUtils.debugf((Object)this, (String)"finishing output", (Object[])new Object[0]);
                this.m_formatter.end();
            }
            catch (Throwable e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"Error while formatting system report output", (Object[])new Object[0]);
                throw new SystemReportException(e);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        } else {
            LogUtils.infof((Object)this, (String)"Invalid form input: %s", (Object[])new Object[]{model});
            throw new SystemReportException("Form input was invalid.");
        }
        LogUtils.debugf((Object)this, (String)"done", (Object[])new Object[0]);
        if (this.m_view != null) {
            this.m_view.render(model, request, response);
        }
    }

    public String getFileName(HttpServletRequest request) {
        String outputParameter = request.getParameter("output");
        String fileName = null;
        fileName = outputParameter != null && !outputParameter.matches("^[\\s]*$") ? new File(outputParameter).getName().replaceAll("[^[:alnum:]\\.]", "") : "opennms-system-report." + this.m_formatter.getExtension();
        return fileName;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("formatter", (Object)this.m_formatter).toString();
    }
}

