/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.provision.persist.ForeignSourceService;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.web.svclayer.ManualProvisioningService;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class ProvisioningGroupsController
extends SimpleFormController {
    private ManualProvisioningService m_provisioningService;
    private ForeignSourceService m_foreignSourceService;

    public void setProvisioningService(ManualProvisioningService provisioningService) {
        this.m_provisioningService = provisioningService;
    }

    public void setForeignSourceService(ForeignSourceService fss) {
        this.m_foreignSourceService = fss;
    }

    public ProvisioningGroupsController() {
        this.setCommandClass(GroupAction.class);
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object cmd, BindException errors) throws Exception {
        GroupAction command = (GroupAction)cmd;
        String action = command.getAction();
        if (action == null || "show".equalsIgnoreCase(action)) {
            return this.doShow(request, response, command, errors);
        }
        if ("addGroup".equalsIgnoreCase(action)) {
            return this.doAddGroup(request, response, command, errors);
        }
        if ("deleteNodes".equalsIgnoreCase(action)) {
            return this.doDeleteNodes(request, response, command, errors);
        }
        if ("import".equalsIgnoreCase(action)) {
            return this.doImport(request, response, command, errors);
        }
        if ("deleteGroup".equalsIgnoreCase(action)) {
            return this.doDeleteGroup(request, response, command, errors);
        }
        if ("cloneForeignSource".equalsIgnoreCase(action)) {
            return this.doCloneForeignSource(request, response, command, errors);
        }
        if ("resetDefaultForeignSource".equalsIgnoreCase(action)) {
            return this.doResetDefaultForeignSource(request, response, command, errors);
        }
        errors.reject("Unrecognized action: " + action);
        return super.onSubmit(request, response, (Object)command, errors);
    }

    private ModelAndView doShow(HttpServletRequest request, HttpServletResponse response, GroupAction command, BindException errors) throws Exception {
        return this.showForm(request, response, errors);
    }

    private ModelAndView doDeleteGroup(HttpServletRequest request, HttpServletResponse response, GroupAction command, BindException errors) throws Exception {
        this.m_provisioningService.deleteProvisioningGroup(command.getGroupName());
        this.m_foreignSourceService.deleteForeignSource(command.getGroupName());
        return this.showForm(request, response, errors);
    }

    private ModelAndView doImport(HttpServletRequest request, HttpServletResponse response, GroupAction command, BindException errors) throws Exception {
        this.m_provisioningService.importProvisioningGroup(command.getGroupName());
        Thread.sleep(500L);
        return this.showForm(request, response, errors);
    }

    private ModelAndView doDeleteNodes(HttpServletRequest request, HttpServletResponse response, GroupAction command, BindException errors) throws Exception {
        this.m_provisioningService.deleteAllNodes(command.getGroupName());
        return this.showForm(request, response, errors);
    }

    private ModelAndView doAddGroup(HttpServletRequest request, HttpServletResponse response, GroupAction command, BindException errors) throws Exception {
        String groupName = command.getGroupName();
        if (groupName.equals("default") || groupName.equals("")) {
            return this.showForm(request, response, errors);
        }
        this.m_provisioningService.createProvisioningGroup(command.getGroupName());
        return this.showForm(request, response, errors);
    }

    private ModelAndView doCloneForeignSource(HttpServletRequest request, HttpServletResponse response, GroupAction command, BindException errors) throws Exception {
        this.m_foreignSourceService.cloneForeignSource(command.getGroupName(), command.getActionTarget());
        return this.showForm(request, response, errors);
    }

    private ModelAndView doResetDefaultForeignSource(HttpServletRequest request, HttpServletResponse response, GroupAction command, BindException errors) throws Exception {
        this.m_foreignSourceService.deleteForeignSource("default");
        return this.showForm(request, response, errors);
    }

    protected Map<String, Object> referenceData(HttpServletRequest request) throws Exception {
        HashMap<String, Object> refData = new HashMap<String, Object>();
        TreeSet<String> names = new TreeSet<String>();
        TreeMap<String, Requisition> groups = new TreeMap<String, Requisition>();
        TreeMap<String, ForeignSource> foreignSources = new TreeMap<String, ForeignSource>();
        for (Requisition mi : this.m_provisioningService.getAllGroups()) {
            if (mi == null) continue;
            names.add(mi.getForeignSource());
            groups.put(mi.getForeignSource(), mi);
        }
        for (ForeignSource fs : this.m_foreignSourceService.getAllForeignSources()) {
            if (fs.isDefault()) continue;
            names.add(fs.getName());
            foreignSources.put(fs.getName(), fs);
        }
        refData.put("foreignSourceNames", names);
        refData.put("groups", groups);
        refData.put("foreignSources", foreignSources);
        refData.put("dbNodeCounts", this.m_provisioningService.getGroupDbNodeCounts());
        return refData;
    }

    public static class GroupAction {
        private String m_groupName;
        private String m_action = "show";
        private String m_actionTarget;

        public String getAction() {
            return this.m_action;
        }

        public void setAction(String action) {
            this.m_action = action;
        }

        public String getGroupName() {
            return this.m_groupName;
        }

        public void setGroupName(String groupName) {
            this.m_groupName = groupName;
        }

        public String getActionTarget() {
            return this.m_actionTarget;
        }

        public void setActionTarget(String target) {
            this.m_actionTarget = target;
        }
    }
}

