/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.web.svclayer.AdminApplicationService;
import org.opennms.web.svclayer.support.DefaultAdminApplicationService;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public class ApplicationController
extends AbstractController {
    private AdminApplicationService m_adminApplicationService;

    private String getNonEmptyParameter(HttpServletRequest request, String parameter) {
        String p;
        if (request != null && (p = request.getParameter(parameter)) != null && !p.equals("")) {
            return p;
        }
        return null;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String removeApplicationIdString = this.getNonEmptyParameter(request, "removeApplicationId");
        String newApplicationName = this.getNonEmptyParameter(request, "newApplicationName");
        String applicationIdString = this.getNonEmptyParameter(request, "applicationid");
        String editString = this.getNonEmptyParameter(request, "edit");
        String ifServiceIdString = this.getNonEmptyParameter(request, "ifserviceid");
        if (removeApplicationIdString != null) {
            this.m_adminApplicationService.removeApplication(removeApplicationIdString);
            return new ModelAndView((View)new RedirectView("/admin/applications.htm", true));
        }
        if (newApplicationName != null) {
            this.m_adminApplicationService.addNewApplication(newApplicationName);
            return new ModelAndView((View)new RedirectView("/admin/applications.htm", true));
        }
        if (applicationIdString != null && editString != null) {
            String editAction = this.getNonEmptyParameter(request, "action");
            if (editAction != null) {
                String[] toAdd = request.getParameterValues("toAdd");
                String[] toDelete = request.getParameterValues("toDelete");
                this.m_adminApplicationService.performEdit(applicationIdString, editAction, toAdd, toDelete);
                ModelAndView modelAndView = new ModelAndView((View)new RedirectView("/admin/applications.htm", true));
                modelAndView.addObject("applicationid", (Object)applicationIdString);
                modelAndView.addObject("edit", (Object)"edit");
                return modelAndView;
            }
            DefaultAdminApplicationService.EditModel model = this.m_adminApplicationService.findApplicationAndAllMonitoredServices(applicationIdString);
            return new ModelAndView("/admin/editApplication", "model", (Object)model);
        }
        if (applicationIdString != null) {
            return new ModelAndView("/admin/showApplication", "model", (Object)this.m_adminApplicationService.getApplication(applicationIdString));
        }
        if (ifServiceIdString != null && editString != null) {
            String editAction = this.getNonEmptyParameter(request, "action");
            if (editAction != null) {
                String[] toAdd = request.getParameterValues("toAdd");
                String[] toDelete = request.getParameterValues("toDelete");
                this.m_adminApplicationService.performServiceEdit(ifServiceIdString, editAction, toAdd, toDelete);
                ModelAndView modelAndView = new ModelAndView((View)new RedirectView("/admin/applications.htm", true));
                modelAndView.addObject("ifserviceid", (Object)ifServiceIdString);
                modelAndView.addObject("edit", (Object)"edit");
                return modelAndView;
            }
            DefaultAdminApplicationService.ServiceEditModel model = this.m_adminApplicationService.findServiceApplications(ifServiceIdString);
            return new ModelAndView("/admin/editServiceApplications", "model", (Object)model);
        }
        List<OnmsApplication> sortedApplications = this.m_adminApplicationService.findAllApplications();
        return new ModelAndView("/admin/applications", "applications", sortedApplications);
    }

    public AdminApplicationService getAdminApplicationService() {
        return this.m_adminApplicationService;
    }

    public void setAdminApplicationService(AdminApplicationService adminApplicationService) {
        this.m_adminApplicationService = adminApplicationService;
    }
}

