/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletContext;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.TroubleTicketState;
import org.opennms.web.alarm.AcknowledgeType;
import org.opennms.web.alarm.Alarm;
import org.opennms.web.alarm.SortStyle;
import org.opennms.web.alarm.filter.InterfaceFilter;
import org.opennms.web.alarm.filter.NodeFilter;
import org.opennms.web.alarm.filter.ServiceFilter;
import org.opennms.web.alarm.filter.SeverityFilter;
import org.opennms.web.filter.Filter;

public class AlarmFactory {
    private AlarmFactory() {
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance();
    }

    public static int getAlarmCount() throws SQLException {
        return AlarmFactory.getAlarmCount(AcknowledgeType.UNACKNOWLEDGED, new Filter[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAlarmCount(AcknowledgeType ackType, Filter[] filters) throws SQLException {
        if (ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int alarmCount = 0;
        DBUtils d = new DBUtils(AlarmFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer select = new StringBuffer("SELECT COUNT(ALARMID) AS ALARMCOUNT FROM ALARMS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) WHERE ");
            select.append(ackType.getAcknowledgeTypeClause());
            for (int i = 0; i < filters.length; ++i) {
                select.append(" AND ");
                select.append(filters[i].getParamSql());
            }
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (int i = 0; i < filters.length; ++i) {
                parameterIndex += filters[i].bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                alarmCount = rs.getInt("ALARMCOUNT");
            }
        }
        finally {
            d.cleanUp();
        }
        return alarmCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getAlarmCountBySeverity(AcknowledgeType ackType, Filter[] filters) throws SQLException {
        if (ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int[] alarmCounts = new int[8];
        DBUtils d = new DBUtils(AlarmFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer select = new StringBuffer("SELECT SEVERITY, COUNT(ALARMID) AS ALARMCOUNT FROM ALARMS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) WHERE ");
            select.append(ackType.getAcknowledgeTypeClause());
            for (int i = 0; i < filters.length; ++i) {
                select.append(" AND ");
                select.append(filters[i].getParamSql());
            }
            select.append(" GROUP BY SEVERITY");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (int i = 1; i < filters.length; ++i) {
                parameterIndex += filters[i].bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            while (rs.next()) {
                int alarmCount;
                int severity = rs.getInt("SEVERITY");
                alarmCounts[severity] = alarmCount = rs.getInt("ALARMCOUNT");
            }
        }
        finally {
            d.cleanUp();
        }
        return alarmCounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alarm getAlarms(int alarmId) throws SQLException {
        Alarm alarm = null;
        DBUtils d = new DBUtils(AlarmFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("SELECT ALARMS.*, NODE.NODELABEL, SERVICE.SERVICENAME FROM ALARMS LEFT OUTER JOIN NODE USING (NODEID) LEFT OUTER JOIN SERVICE USING (SERVICEID) WHERE ALARMID=? ");
            d.watch((Object)stmt);
            stmt.setInt(1, alarmId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            Alarm[] alarms = AlarmFactory.rs2Alarms(rs);
            if (alarms.length > 0) {
                alarm = alarms[0];
            }
        }
        finally {
            d.cleanUp();
        }
        return alarm;
    }

    public static Alarm[] getAlarms() throws SQLException {
        return AlarmFactory.getAlarms(SortStyle.LASTEVENTTIME, AcknowledgeType.UNACKNOWLEDGED);
    }

    public static Alarm[] getAlarms(AcknowledgeType ackType) throws SQLException {
        return AlarmFactory.getAlarms(SortStyle.LASTEVENTTIME, ackType);
    }

    public static Alarm[] getAlarms(SortStyle sortStyle) throws SQLException {
        return AlarmFactory.getAlarms(sortStyle, AcknowledgeType.UNACKNOWLEDGED);
    }

    public static Alarm[] getAlarms(SortStyle sortStyle, boolean includeAcknowledged) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return AlarmFactory.getAlarms(sortStyle, ackType);
    }

    public static Alarm[] getAlarms(SortStyle sortStyle, AcknowledgeType ackType) throws SQLException {
        return AlarmFactory.getAlarms(sortStyle, ackType, new Filter[0]);
    }

    public static Alarm[] getAlarms(SortStyle sortStyle, AcknowledgeType ackType, Filter[] filters) throws SQLException {
        return AlarmFactory.getAlarms(sortStyle, ackType, filters, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alarm[] getAlarms(SortStyle sortStyle, AcknowledgeType ackType, Filter[] filters, int limit, int offset) throws SQLException {
        if (sortStyle == null || ackType == null || filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        boolean useLimits = false;
        if (limit > 0 && offset > -1) {
            useLimits = true;
        }
        Alarm[] alarms = null;
        DBUtils d = new DBUtils(AlarmFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer select = new StringBuffer("SELECT ALARMS.*, NODE.NODELABEL, SERVICE.SERVICENAME FROM ALARMS LEFT OUTER JOIN NODE USING(NODEID) LEFT OUTER JOIN SERVICE USING(SERVICEID) WHERE");
            select.append(ackType.getAcknowledgeTypeClause());
            for (int i = 0; i < filters.length; ++i) {
                select.append(" AND ");
                select.append(filters[i].getParamSql());
            }
            select.append(sortStyle.getOrderByClause());
            if (useLimits) {
                select.append(" LIMIT ");
                select.append(limit);
                select.append(" OFFSET ");
                select.append(offset);
            }
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (int i = 0; i < filters.length; ++i) {
                parameterIndex += filters[i].bindParam(stmt, parameterIndex);
            }
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            alarms = AlarmFactory.rs2Alarms(rs);
        }
        finally {
            d.cleanUp();
        }
        return alarms;
    }

    public static Alarm[] getAlarmsForNode(int nodeId, ServletContext servletContext) throws SQLException {
        return AlarmFactory.getAlarmsForNode(nodeId, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Alarm[] getAlarmsForNode(int nodeId, SortStyle sortStyle, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        return AlarmFactory.getAlarmsForNode(nodeId, sortStyle, ackType, -1, -1, servletContext);
    }

    public static Alarm[] getAlarmsForNode(int nodeId, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext)};
        return AlarmFactory.getAlarms(sortStyle, ackType, filters, throttle, offset);
    }

    public static int getAlarmCountForNode(int nodeId, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext)};
        return AlarmFactory.getAlarmCount(ackType, filters);
    }

    public static Alarm[] getAlarmsForInterface(int nodeId, String ipAddress, ServletContext servletContext) throws SQLException {
        return AlarmFactory.getAlarmsForInterface(nodeId, ipAddress, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Alarm[] getAlarmsForInterface(int nodeId, String ipAddress, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress)};
        return AlarmFactory.getAlarms(sortStyle, ackType, filters, throttle, offset);
    }

    public static Alarm[] getAlarmsForInterface(String ipAddress) throws SQLException {
        return AlarmFactory.getAlarmsForInterface(ipAddress, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1);
    }

    public static Alarm[] getAlarmsForInterface(String ipAddress, boolean includeAcknowledged) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return AlarmFactory.getAlarmsForInterface(ipAddress, SortStyle.ID, ackType, -1, -1);
    }

    public static Alarm[] getAlarmsForInterface(String ipAddress, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset) throws SQLException {
        if (ipAddress == null || sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new InterfaceFilter(ipAddress)};
        return AlarmFactory.getAlarms(sortStyle, ackType, filters, throttle, offset);
    }

    public static int getAlarmCountForInterface(int nodeId, String ipAddress, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress)};
        return AlarmFactory.getAlarmCount(ackType, filters);
    }

    public static int getAlarmCountForInterface(String ipAddress, AcknowledgeType ackType) throws SQLException {
        if (ipAddress == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new InterfaceFilter(ipAddress)};
        return AlarmFactory.getAlarmCount(ackType, filters);
    }

    public static Alarm[] getAlarmsForService(int nodeId, String ipAddress, int serviceId, ServletContext servletContext) throws SQLException {
        return AlarmFactory.getAlarmsForService(nodeId, ipAddress, serviceId, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Alarm[] getAlarmsForService(int nodeId, String ipAddress, int serviceId, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress), new ServiceFilter(serviceId, servletContext)};
        return AlarmFactory.getAlarms(sortStyle, ackType, filters, throttle, offset);
    }

    public static Alarm[] getAlarmsForService(int serviceId, ServletContext servletContext) throws SQLException {
        return AlarmFactory.getAlarmsForService(serviceId, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED, -1, -1, servletContext);
    }

    public static Alarm[] getAlarmsForService(int serviceId, boolean includeAcknowledged, ServletContext servletContext) throws SQLException {
        AcknowledgeType ackType = includeAcknowledged ? AcknowledgeType.BOTH : AcknowledgeType.UNACKNOWLEDGED;
        return AlarmFactory.getAlarmsForService(serviceId, SortStyle.ID, ackType, -1, -1, servletContext);
    }

    public static Alarm[] getAlarmsForService(int serviceId, SortStyle sortStyle, AcknowledgeType ackType, int throttle, int offset, ServletContext servletContext) throws SQLException {
        if (sortStyle == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new ServiceFilter(serviceId, servletContext)};
        return AlarmFactory.getAlarms(sortStyle, ackType, filters, throttle, offset);
    }

    public static int getAlarmCountForService(int nodeId, String ipAddress, int serviceId, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (ipAddress == null || ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new NodeFilter(nodeId, servletContext), new InterfaceFilter(ipAddress), new ServiceFilter(serviceId, servletContext)};
        return AlarmFactory.getAlarmCount(ackType, filters);
    }

    public static int getAlarmCountForService(int serviceId, AcknowledgeType ackType, ServletContext servletContext) throws SQLException {
        if (ackType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Filter[] filters = new Filter[]{new ServiceFilter(serviceId, servletContext)};
        return AlarmFactory.getAlarmCount(ackType, filters);
    }

    public static Alarm[] getAlarmsForSeverity(int severity) throws SQLException {
        return AlarmFactory.getAlarmsForSeverity(severity, SortStyle.ID, AcknowledgeType.UNACKNOWLEDGED);
    }

    public static Alarm[] getAlarmsForSeverity(int severity, SortStyle sortStyle, AcknowledgeType ackType) throws SQLException {
        return AlarmFactory.getAlarms(sortStyle, ackType, new Filter[]{new SeverityFilter(OnmsSeverity.get((int)severity))});
    }

    public static Alarm[] getAlarmsForPoller(String poller) throws SQLException {
        return AlarmFactory.getAlarmsForPoller(poller, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Alarm[] getAlarmsForPoller(String poller, boolean includeAcknowledged) throws SQLException {
        if (poller == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Alarm[] alarms = null;
        DBUtils d = new DBUtils(AlarmFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            StringBuffer select = new StringBuffer("SELECT * FROM ALARMS WHERE DPNAME=?");
            if (!includeAcknowledged) {
                select.append(" AND ALARMACKUSER IS NULL");
            }
            select.append(" AND ALARMDISPLAY='Y' ");
            select.append(" ORDER BY ALARMID DESC");
            PreparedStatement stmt = conn.prepareStatement(select.toString());
            d.watch((Object)stmt);
            stmt.setString(1, poller);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            alarms = AlarmFactory.rs2Alarms(rs);
        }
        finally {
            d.cleanUp();
        }
        return alarms;
    }

    public static void acknowledge(Alarm[] alarms, String user) throws SQLException {
        AlarmFactory.acknowledge(alarms, user, new Date());
    }

    public static void acknowledge(Alarm[] alarms, String user, Date time) throws SQLException {
        if (alarms == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int[] ids = new int[alarms.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = alarms[i].getId();
        }
        AlarmFactory.acknowledge(ids, user, time);
    }

    public static void acknowledge(int[] alarmIds, String user) throws SQLException {
        AlarmFactory.acknowledge(alarmIds, user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acknowledge(int[] alarmIds, String user, Date time) throws SQLException {
        if (alarmIds == null || user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (alarmIds.length > 0) {
            StringBuffer update = new StringBuffer("UPDATE ALARMS SET ALARMACKUSER=?, ALARMACKTIME=?");
            update.append(" WHERE ALARMID IN (");
            update.append(alarmIds[0]);
            for (int i = 1; i < alarmIds.length; ++i) {
                update.append(",");
                update.append(alarmIds[i]);
            }
            update.append(")");
            update.append(" AND ALARMACKUSER IS NULL");
            DBUtils d = new DBUtils(AlarmFactory.class);
            try {
                Connection conn = Vault.getDbConnection();
                d.watch((Object)conn);
                PreparedStatement stmt = conn.prepareStatement(update.toString());
                d.watch((Object)stmt);
                stmt.setString(1, user);
                stmt.setTimestamp(2, new Timestamp(time.getTime()));
                stmt.executeUpdate();
            }
            finally {
                d.cleanUp();
            }
        }
    }

    public static void acknowledge(Filter[] filters, String user) throws SQLException {
        AlarmFactory.acknowledge(filters, user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acknowledge(Filter[] filters, String user, Date time) throws SQLException {
        if (filters == null || user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuffer update = new StringBuffer("UPDATE ALARMS SET ALARMACKUSER=?, ALARMACKTIME=? WHERE");
        update.append(AcknowledgeType.UNACKNOWLEDGED.getAcknowledgeTypeClause());
        for (int i = 0; i < filters.length; ++i) {
            update.append(" AND ");
            update.append(filters[i].getParamSql());
        }
        DBUtils d = new DBUtils(AlarmFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(update.toString());
            d.watch((Object)stmt);
            stmt.setString(1, user);
            stmt.setTimestamp(2, new Timestamp(time.getTime()));
            int parameterIndex = 3;
            for (int i = 0; i < filters.length; ++i) {
                parameterIndex += filters[i].bindParam(stmt, parameterIndex);
            }
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    public static void acknowledgeAll(String user) throws SQLException {
        AlarmFactory.acknowledgeAll(user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acknowledgeAll(String user, Date time) throws SQLException {
        if (user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        DBUtils d = new DBUtils(AlarmFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("UPDATE ALARMS SET ALARMACKUSER=?, ALARMACKTIME=? WHERE ALARMACKUSER IS NULL");
            d.watch((Object)stmt);
            stmt.setString(1, user);
            stmt.setTimestamp(2, new Timestamp(time.getTime()));
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    public static void unacknowledge(Alarm[] alarms) throws SQLException {
        if (alarms == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int[] ids = new int[alarms.length];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = alarms[i].getId();
        }
        AlarmFactory.unacknowledge(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unacknowledge(int[] alarmIds) throws SQLException {
        if (alarmIds == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (alarmIds.length > 0) {
            StringBuffer update = new StringBuffer("UPDATE ALARMS SET ALARMACKUSER=NULL, ALARMACKTIME=NULL");
            update.append(" WHERE ALARMID IN (");
            update.append(alarmIds[0]);
            for (int i = 1; i < alarmIds.length; ++i) {
                update.append(",");
                update.append(alarmIds[i]);
            }
            update.append(")");
            DBUtils d = new DBUtils(AlarmFactory.class);
            try {
                Connection conn = Vault.getDbConnection();
                d.watch((Object)conn);
                PreparedStatement stmt = conn.prepareStatement(update.toString());
                d.watch((Object)stmt);
                stmt.executeUpdate();
            }
            finally {
                d.cleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unacknowledge(Filter[] filters) throws SQLException {
        if (filters == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuffer update = new StringBuffer("UPDATE ALARMS SET ALARMACKUSER=NULL, ALARMACKTIME=NULL WHERE");
        update.append(AcknowledgeType.ACKNOWLEDGED.getAcknowledgeTypeClause());
        for (int i = 0; i < filters.length; ++i) {
            update.append(" AND ");
            update.append(filters[i].getParamSql());
        }
        DBUtils d = new DBUtils(AlarmFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement(update.toString());
            d.watch((Object)stmt);
            int parameterIndex = 1;
            for (int i = 0; i < filters.length; ++i) {
                parameterIndex += filters[i].bindParam(stmt, parameterIndex);
            }
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unacknowledgeAll() throws SQLException {
        DBUtils d = new DBUtils(AlarmFactory.class);
        try {
            Connection conn = Vault.getDbConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("UPDATE ALARMS SET ALARMACKUSER=NULL, ALARMACKTIME=NULL WHERE ALARMACKUSER IS NOT NULL");
            d.watch((Object)stmt);
            stmt.executeUpdate();
        }
        finally {
            d.cleanUp();
        }
    }

    protected static Alarm[] rs2Alarms(ResultSet rs) throws SQLException {
        Vector<Alarm> vector = new Vector<Alarm>();
        while (rs.next()) {
            Timestamp lasteventtime;
            Alarm alarm = new Alarm();
            alarm.id = rs.getInt("alarmID");
            alarm.uei = rs.getString("eventUei");
            alarm.dpName = rs.getString("dpName");
            alarm.nodeID = rs.getInt("nodeID");
            alarm.ipAddr = rs.getString("ipAddr");
            alarm.serviceID = (Integer)rs.getObject("serviceID");
            alarm.reductionKey = rs.getString("reductionKey");
            alarm.count = rs.getInt("counter");
            alarm.severity = OnmsSeverity.get((int)rs.getInt("severity"));
            alarm.lastEventID = rs.getInt("lastEventID");
            Timestamp firsteventtime = rs.getTimestamp("firsteventtime");
            if (firsteventtime != null) {
                alarm.firsteventtime = new Date(firsteventtime.getTime());
            }
            if ((lasteventtime = rs.getTimestamp("lasteventtime")) != null) {
                alarm.lasteventtime = new Date(lasteventtime.getTime());
            }
            alarm.description = rs.getString("description");
            alarm.logMessage = rs.getString("logmsg");
            alarm.operatorInstruction = rs.getString("OperInstruct");
            alarm.troubleTicket = rs.getString("TTicketID");
            Integer stateCode = (Integer)rs.getObject("TTicketState");
            for (TroubleTicketState state : TroubleTicketState.values()) {
                if (stateCode == null || state.ordinal() != stateCode.intValue()) continue;
                alarm.troubleTicketState = state;
            }
            alarm.mouseOverText = rs.getString("MouseOverText");
            Timestamp suppressedUntil = rs.getTimestamp("suppressedUntil");
            if (suppressedUntil != null) {
                alarm.suppressedUntil = new Date(suppressedUntil.getTime());
            }
            alarm.suppressedUser = rs.getString("suppressedUser");
            Timestamp suppressedTime = rs.getTimestamp("suppressedTime");
            if (suppressedTime != null) {
                alarm.suppressedTime = new Date(suppressedTime.getTime());
            }
            alarm.acknowledgeUser = rs.getString("alarmAckUser");
            Timestamp alarmAckTime = rs.getTimestamp("alarmAckTime");
            if (alarmAckTime != null) {
                alarm.acknowledgeTime = new Date(alarmAckTime.getTime());
            }
            alarm.nodeLabel = rs.getString("nodeLabel");
            alarm.serviceName = rs.getString("serviceName");
            vector.addElement(alarm);
        }
        return vector.toArray(new Alarm[vector.size()]);
    }

    public static void escalateAlarms(int[] alarmIds, String user) throws SQLException {
        AlarmFactory.escalateAlarms(alarmIds, user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void escalateAlarms(int[] alarmIds, String user, Date time) throws SQLException {
        if (alarmIds == null || user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (alarmIds.length > 0) {
            StringBuffer update = new StringBuffer("UPDATE ALARMS SET SEVERITY = (");
            update.append("CASE WHEN SEVERITY =? THEN ?");
            update.append(" ELSE (");
            update.append("  CASE WHEN SEVERITY <? THEN SEVERITY + 1");
            update.append("  ELSE ? END)");
            update.append(" END),");
            update.append(" ALARMTYPE =?");
            update.append(" WHERE ALARMID IN (");
            update.append(alarmIds[0]);
            for (int i = 1; i < alarmIds.length; ++i) {
                update.append(",");
                update.append(alarmIds[i]);
            }
            update.append(")");
            update.append(" AND ( (");
            update.append("  ALARMTYPE =? AND");
            update.append("  SEVERITY =?");
            update.append(" ) OR (");
            update.append("  ALARMTYPE =? AND");
            update.append("  SEVERITY >? AND");
            update.append("  SEVERITY <=?");
            update.append(" ) )");
            if (AlarmFactory.log().isDebugEnabled()) {
                AlarmFactory.log().debug("escalateAlarms: built query |" + update.toString() + "|");
            }
            DBUtils d = new DBUtils(AlarmFactory.class);
            try {
                Connection conn = Vault.getDbConnection();
                d.watch((Object)conn);
                PreparedStatement stmt = conn.prepareStatement(update.toString());
                d.watch((Object)stmt);
                stmt.setInt(1, OnmsSeverity.CLEARED.getId());
                stmt.setInt(2, OnmsSeverity.WARNING.getId());
                stmt.setInt(3, OnmsSeverity.CRITICAL.getId());
                stmt.setInt(4, OnmsSeverity.CRITICAL.getId());
                stmt.setInt(5, 1);
                stmt.setInt(6, 2);
                stmt.setInt(7, OnmsSeverity.CLEARED.getId());
                stmt.setInt(8, 1);
                stmt.setInt(9, OnmsSeverity.NORMAL.getId());
                stmt.setInt(10, OnmsSeverity.CRITICAL.getId());
                stmt.executeUpdate();
            }
            finally {
                d.cleanUp();
            }
        }
    }

    public static void clearAlarms(int[] alarmIds, String user) throws SQLException {
        AlarmFactory.clearAlarms(alarmIds, user, new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAlarms(int[] alarmIds, String user, Date time) throws SQLException {
        if (alarmIds == null || user == null || time == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (alarmIds.length > 0) {
            StringBuffer update = new StringBuffer("UPDATE ALARMS SET SEVERITY =?");
            update.append(", ALARMTYPE =?");
            update.append(" WHERE ALARMID IN (");
            update.append(alarmIds[0]);
            for (int i = 1; i < alarmIds.length; ++i) {
                update.append(",");
                update.append(alarmIds[i]);
            }
            update.append(")");
            update.append(" AND SEVERITY >=?");
            update.append(" AND SEVERITY <=?");
            DBUtils d = new DBUtils(AlarmFactory.class);
            try {
                Connection conn = Vault.getDbConnection();
                d.watch((Object)conn);
                PreparedStatement stmt = conn.prepareStatement(update.toString());
                d.watch((Object)stmt);
                stmt.setInt(1, OnmsSeverity.CLEARED.getId());
                stmt.setInt(2, 2);
                stmt.setInt(3, OnmsSeverity.NORMAL.getId());
                stmt.setInt(4, OnmsSeverity.CRITICAL.getId());
                stmt.executeUpdate();
            }
            finally {
                d.cleanUp();
            }
        }
    }
}

