/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.users;

import java.io.IOException;
import java.text.ChoiceFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.UserFactory;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.config.users.Contact;
import org.opennms.netmgt.config.users.DutySchedule;
import org.opennms.netmgt.config.users.Password;
import org.opennms.netmgt.config.users.User;

public class UpdateUserServlet
extends HttpServlet {
    private static final long serialVersionUID = -945279264373810897L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession userSession = request.getSession(false);
        if (userSession != null) {
            String tuiPin;
            String password;
            User newUser = (User)userSession.getAttribute("user.modifyUser.jsp");
            try {
                UserFactory.init();
            }
            catch (Throwable e) {
                throw new ServletException("UpdateUserServlet:init Error initialising UserFactory " + e);
            }
            newUser.setFullName(request.getParameter("fullName"));
            newUser.setUserComments(request.getParameter("userComments"));
            newUser.setReadOnly(false);
            if (request.getParameter("readOnly") != null && (request.getParameter("readOnly").equalsIgnoreCase("true") || request.getParameter("readOnly").equalsIgnoreCase("on"))) {
                newUser.setReadOnly(true);
            }
            if ((password = request.getParameter("password")) != null && !password.trim().equals("")) {
                Password pass = new Password();
                pass.setContent(UserFactory.getInstance().encryptedPassword(password, true));
                pass.setSalt(true);
                newUser.setPassword(pass);
            }
            if ((tuiPin = request.getParameter("tuiPin")) != null && !tuiPin.trim().equals("")) {
                newUser.setTuiPin(tuiPin);
            }
            String email = request.getParameter(UserManager.ContactType.email.toString());
            String pagerEmail = request.getParameter("pemail");
            String xmppAddress = request.getParameter(UserManager.ContactType.xmppAddress.toString());
            String microblog = request.getParameter(UserManager.ContactType.microblog.toString());
            String numericPage = request.getParameter("numericalService");
            String numericPin = request.getParameter("numericalPin");
            String textPage = request.getParameter("textService");
            String textPin = request.getParameter("textPin");
            String workPhone = request.getParameter(UserManager.ContactType.workPhone.toString());
            String mobilePhone = request.getParameter(UserManager.ContactType.mobilePhone.toString());
            String homePhone = request.getParameter(UserManager.ContactType.homePhone.toString());
            newUser.removeAllContact();
            Contact tmpContact = new Contact();
            tmpContact.setInfo(email);
            tmpContact.setType(UserManager.ContactType.email.toString());
            newUser.addContact(tmpContact);
            tmpContact = new Contact();
            tmpContact.setInfo(pagerEmail);
            tmpContact.setType(UserManager.ContactType.pagerEmail.toString());
            newUser.addContact(tmpContact);
            tmpContact = new Contact();
            tmpContact.setInfo(xmppAddress);
            tmpContact.setType(UserManager.ContactType.xmppAddress.toString());
            newUser.addContact(tmpContact);
            tmpContact = new Contact();
            tmpContact.setInfo(microblog);
            tmpContact.setType(UserManager.ContactType.microblog.toString());
            newUser.addContact(tmpContact);
            tmpContact = new Contact();
            tmpContact.setInfo(numericPin);
            tmpContact.setServiceProvider(numericPage);
            tmpContact.setType(UserManager.ContactType.numericPage.toString());
            newUser.addContact(tmpContact);
            tmpContact = new Contact();
            tmpContact.setInfo(textPin);
            tmpContact.setServiceProvider(textPage);
            tmpContact.setType(UserManager.ContactType.textPage.toString());
            newUser.addContact(tmpContact);
            tmpContact = new Contact();
            tmpContact.setInfo(workPhone);
            tmpContact.setType(UserManager.ContactType.workPhone.toString());
            newUser.addContact(tmpContact);
            tmpContact = new Contact();
            tmpContact.setInfo(mobilePhone);
            tmpContact.setType(UserManager.ContactType.mobilePhone.toString());
            newUser.addContact(tmpContact);
            tmpContact = new Contact();
            tmpContact.setInfo(homePhone);
            tmpContact.setType(UserManager.ContactType.homePhone.toString());
            newUser.addContact(tmpContact);
            ArrayList<Boolean> newSchedule = new ArrayList<Boolean>(7);
            ChoiceFormat days = new ChoiceFormat("0#Mo|1#Tu|2#We|3#Th|4#Fr|5#Sa|6#Su");
            List<String> dutySchedules = this.getDutySchedulesForUser(newUser);
            dutySchedules.clear();
            int dutyCount = WebSecurityUtils.safeParseInt((String)request.getParameter("dutySchedules"));
            for (int duties = 0; duties < dutyCount; ++duties) {
                newSchedule.clear();
                String deleteFlag = request.getParameter("deleteDuty" + duties);
                if (deleteFlag != null) continue;
                for (int i = 0; i < 7; ++i) {
                    String curDayFlag = request.getParameter("duty" + duties + days.format(i));
                    newSchedule.add(new Boolean(curDayFlag != null));
                }
                int startTime = WebSecurityUtils.safeParseInt((String)request.getParameter("duty" + duties + "Begin"));
                int stopTime = WebSecurityUtils.safeParseInt((String)request.getParameter("duty" + duties + "End"));
                DutySchedule newDuty = new DutySchedule(newSchedule, startTime, stopTime);
                dutySchedules.add(newDuty.toString());
            }
            userSession.setAttribute("user.modifyUser.jsp", (Object)newUser);
        }
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher(request.getParameter("redirect"));
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private List<String> getDutySchedulesForUser(User newUser) {
        return newUser.getDutyScheduleCollection();
    }
}

