/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.pollerConfig;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.CapsdConfig;
import org.opennms.netmgt.config.CapsdConfigFactory;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.PollerConfigFactory;
import org.opennms.netmgt.config.capsd.CapsdConfiguration;
import org.opennms.netmgt.config.capsd.Property;
import org.opennms.netmgt.config.capsd.ProtocolPlugin;
import org.opennms.netmgt.config.poller.Monitor;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.config.poller.Service;
import org.opennms.web.api.Util;

public class AddPollerConfigServlet
extends HttpServlet {
    private static final long serialVersionUID = 8025629129971135727L;
    PollerConfiguration pollerConfig = null;
    CapsdConfiguration capsdConfig = null;
    protected String redirectSuccess;
    Map<String, Service> pollerServices = new HashMap<String, Service>();
    Map<String, ProtocolPlugin> capsdProtocols = new HashMap<String, ProtocolPlugin>();
    List<ProtocolPlugin> capsdColl = new ArrayList<ProtocolPlugin>();
    Package pkg = null;
    Collection<ProtocolPlugin> pluginColl = null;
    Properties props = new Properties();
    PollerConfig pollerFactory = null;
    CapsdConfig capsdFactory = null;
    boolean errorflag = false;

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        try {
            this.props.load(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)));
            PollerConfigFactory.init();
            this.pollerFactory = PollerConfigFactory.getInstance();
            this.pollerConfig = this.pollerFactory.getConfiguration();
            if (this.pollerConfig == null) {
                this.errorflag = true;
                throw new ServletException("Poller Configuration file is empty");
            }
            CapsdConfigFactory.init();
            this.capsdFactory = CapsdConfigFactory.getInstance();
            this.capsdConfig = this.capsdFactory.getConfiguration();
            if (this.capsdConfig == null) {
                this.errorflag = true;
                throw new ServletException("Capsd Configuration file is empty");
            }
        }
        catch (Throwable e) {
            throw new ServletException(e.getMessage());
        }
        this.initPollerServices();
        this.initCapsdProtocols();
        this.redirectSuccess = config.getInitParameter("redirect.success");
        if (this.redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
    }

    public void reloadFiles() throws ServletException {
        ServletConfig config = this.getServletConfig();
        try {
            this.props.load(new FileInputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)));
            PollerConfigFactory.init();
            this.pollerFactory = PollerConfigFactory.getInstance();
            this.pollerConfig = this.pollerFactory.getConfiguration();
            if (this.pollerConfig == null) {
                this.errorflag = true;
                throw new ServletException("Poller Configuration file is empty");
            }
            CapsdConfigFactory.init();
            this.capsdFactory = CapsdConfigFactory.getInstance();
            this.capsdConfig = this.capsdFactory.getConfiguration();
            if (this.capsdConfig == null) {
                this.errorflag = true;
                throw new ServletException("Capsd Configuration file is empty");
            }
        }
        catch (Throwable e) {
            throw new ServletException(e.getMessage());
        }
        this.initPollerServices();
        this.initCapsdProtocols();
        this.redirectSuccess = config.getInitParameter("redirect.success");
        if (this.redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
    }

    public void initCapsdProtocols() {
        this.capsdProtocols = new HashMap<String, ProtocolPlugin>();
        this.pluginColl = this.getProtocolPlugins();
        if (this.pluginColl != null) {
            for (ProtocolPlugin plugin : this.pluginColl) {
                this.capsdColl.add(plugin);
                this.capsdProtocols.put(plugin.getProtocol(), plugin);
            }
        }
    }

    private List<ProtocolPlugin> getProtocolPlugins() {
        return this.capsdConfig.getProtocolPluginCollection();
    }

    public void initPollerServices() {
        Iterator pkgiter;
        this.pollerServices = new HashMap<String, Service>();
        List<Package> packageColl = this.getPackages();
        if (packageColl != null && (pkgiter = packageColl.iterator()).hasNext()) {
            this.pkg = (Package)pkgiter.next();
            List<Service> svcColl = this.getServicesForPackage();
            Iterator svcIter = svcColl.iterator();
            Service svcProp = null;
            while (svcIter.hasNext()) {
                svcProp = (Service)svcIter.next();
                this.pollerServices.put(svcProp.getName(), svcProp);
            }
        }
    }

    private List<Service> getServicesForPackage() {
        return this.pkg.getServiceCollection();
    }

    private List<Package> getPackages() {
        return this.pollerConfig.getPackageCollection();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String user_id = request.getRemoteUser();
        this.errorflag = false;
        this.reloadFiles();
        String check1 = request.getParameter("check1");
        String name1 = request.getParameter("name1");
        String protoArray1 = request.getParameter("protArray1");
        String port1 = request.getParameter("port1");
        ArrayList<String> checkedList = new ArrayList<String>();
        if (name1 != null && !name1.equals("")) {
            this.addPollerInfo(check1, name1, port1, user_id, protoArray1, response, request);
            if (this.errorflag) {
                return;
            }
            checkedList.add(name1);
            this.addCapsdInfo(name1, port1, user_id, protoArray1, response, request);
            if (!this.errorflag) {
                this.props.setProperty("service." + name1 + ".protocol", protoArray1);
            } else {
                return;
            }
        }
        this.props.store(new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONF_FILE_NAME)), null);
        OutputStreamWriter poller_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.POLLER_CONFIG_FILE_NAME)), "UTF-8");
        OutputStreamWriter capsd_fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(ConfigFileConstants.getFile((int)ConfigFileConstants.CAPSD_CONFIG_FILE_NAME)), "UTF-8");
        try {
            Marshaller.marshal((Object)this.pollerConfig, (Writer)poller_fileWriter);
            Marshaller.marshal((Object)this.capsdConfig, (Writer)capsd_fileWriter);
        }
        catch (MarshalException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ValidationException e) {
            throw new ServletException((Throwable)e);
        }
        if (!this.errorflag) {
            response.sendRedirect(this.redirectSuccess);
        }
    }

    public void addCapsdInfo(String name, String port, String user, String protocol, HttpServletResponse response, HttpServletRequest request) throws ServletException, IOException {
        List<ProtocolPlugin> tmpCapsd = this.getProtocolPlugins();
        Iterator iter = tmpCapsd.iterator();
        Service pollersvc = null;
        while (iter.hasNext()) {
            List<Service> tmpPoller;
            ProtocolPlugin svc = (ProtocolPlugin)iter.next();
            if (!svc.getProtocol().equals(name)) continue;
            List<Service> tmpPollers = this.getServicesForPackage();
            Iterator polleriter = tmpPollers.iterator();
            boolean removePoller = false;
            while (polleriter.hasNext()) {
                pollersvc = (Service)polleriter.next();
                if (!pollersvc.getName().equals(name)) continue;
                removePoller = true;
                break;
            }
            if (!removePoller || !(tmpPoller = this.getServicesForPackage()).contains(pollersvc) || !pollersvc.getName().equals(name)) break;
            this.errorflag = true;
            tmpPoller.remove(pollersvc);
            response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("/admin/error.jsp?error=1&name=" + name)));
            return;
        }
        ProtocolPlugin pluginAdd = new ProtocolPlugin();
        pluginAdd.setProtocol(name);
        String className = (String)this.props.get("service." + protocol + ".capsd-class");
        if (className != null) {
            pluginAdd.setClassName(className);
            pluginAdd.setScan("on");
            pluginAdd.setUserDefined("true");
            Property newprop = new Property();
            String banner = "*";
            if (this.props.get("banner") != null) {
                banner = (String)this.props.get("banner");
            }
            newprop.setValue(banner);
            newprop.setKey("banner");
            pluginAdd.addProperty(newprop);
            newprop = new Property();
            if (port != null && !port.equals("")) {
                newprop.setValue(port);
                if (port.indexOf(":") == -1) {
                    newprop.setKey("port");
                } else {
                    newprop.setKey("ports");
                }
                pluginAdd.addProperty(newprop);
            } else {
                if (this.props.get("service." + protocol + ".port") == null || ((String)this.props.get("service." + protocol + ".port")).equals("")) {
                    this.errorflag = true;
                    response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/error.jsp?error=0&name=service." + protocol + ".port")));
                    pluginAdd = null;
                    return;
                }
                port = (String)this.props.get("service." + protocol + ".port");
                newprop.setValue(port);
                if (port.indexOf(":") == -1) {
                    newprop.setKey("port");
                } else {
                    newprop.setKey("ports");
                }
                pluginAdd.addProperty(newprop);
            }
            newprop = new Property();
            String timeout = "3000";
            if (this.props.get("timeout") != null) {
                timeout = (String)this.props.get("timeout");
            }
            newprop.setValue(timeout);
            newprop.setKey("timeout");
            if (pluginAdd != null) {
                pluginAdd.addProperty(newprop);
            }
            newprop = new Property();
            String retry = "3";
            if (this.props.get("retry") != null) {
                retry = (String)this.props.get("retry");
            }
            newprop.setValue(retry);
            newprop.setKey("retry");
            if (pluginAdd != null) {
                pluginAdd.addProperty(newprop);
                this.capsdProtocols.put(name, pluginAdd);
                this.pluginColl = this.capsdProtocols.values();
                this.capsdColl.add(pluginAdd);
                this.capsdConfig.addProtocolPlugin(pluginAdd);
            }
        } else {
            this.errorflag = true;
            response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/error.jsp?error=0&name=service." + protocol + ".capsd-class")));
            return;
        }
    }

    public void addPollerInfo(String bPolled, String name, String port, String user, String protocol, HttpServletResponse response, HttpServletRequest request) throws ServletException, IOException {
        List<Service> tmpPollers = this.getServicesForPackage();
        for (Service svc : tmpPollers) {
            if (!svc.getName().equals(name)) continue;
            this.errorflag = true;
            response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/error.jsp?error=1&name=" + name)));
            return;
        }
        if (this.pkg != null) {
            Service newService = new Service();
            newService.setName(name);
            if (bPolled != null) {
                newService.setStatus(bPolled);
            } else {
                newService.setStatus("off");
            }
            newService.setName(name);
            newService.setUserDefined("true");
            List<Monitor> monitorColl = this.getMonitors();
            Monitor newMonitor = new Monitor();
            String monitor = (String)this.props.get("service." + protocol + ".monitor");
            if (monitor == null) {
                this.errorflag = true;
                response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/error.jsp?error=0&name=service." + protocol + ".monitor")));
                return;
            }
            newMonitor.setService(name);
            newMonitor.setClassName(monitor);
            if (this.props.get("interval") != null) {
                newService.setInterval(new Long((String)this.props.get("interval")).longValue());
            } else {
                newService.setInterval(300000L);
            }
            Parameter newprop = new Parameter();
            String timeout = "3000";
            if (this.props.get("timeout") != null) {
                timeout = (String)this.props.get("timeout");
            }
            newprop.setValue(timeout);
            newprop.setKey("timeout");
            newService.addParameter(newprop);
            newprop = new Parameter();
            String banner = "*";
            if (this.props.get("banner") != null) {
                banner = (String)this.props.get("banner");
            }
            newprop.setValue(banner);
            newprop.setKey("banner");
            newService.addParameter(newprop);
            newprop = new Parameter();
            String retry = "3";
            if (this.props.get("retry") != null) {
                retry = (String)this.props.get("retry");
            }
            newprop.setValue(retry);
            newprop.setKey("retry");
            newService.addParameter(newprop);
            newprop = new Parameter();
            if (port == null || port.equals("")) {
                if (this.props.get("service." + protocol + ".port") == null || ((String)this.props.get("service." + protocol + ".port")).equals("")) {
                    this.errorflag = true;
                    newMonitor = null;
                    newService = null;
                    response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)("admin/error.jsp?error=0&name=service." + protocol + ".port")));
                    return;
                }
                port = (String)this.props.get("service." + protocol + ".port");
            }
            newprop.setValue(port);
            if (port.indexOf(":") != -1) {
                newprop.setKey("ports");
            } else {
                newprop.setKey("port");
            }
            if (newMonitor != null && newService != null) {
                if (monitorColl == null) {
                    this.pollerConfig.addMonitor(0, newMonitor);
                } else {
                    this.pollerConfig.addMonitor(newMonitor);
                }
                newService.addParameter(newprop);
                this.pkg.addService(newService);
            }
        }
    }

    private List<Monitor> getMonitors() {
        return this.pollerConfig.getMonitorCollection();
    }
}

