/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.notification.noticeWizard;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.config.NotifdConfigFactory;
import org.opennms.netmgt.config.NotificationFactory;
import org.opennms.netmgt.config.notifications.Notification;
import org.opennms.netmgt.config.notifications.Parameter;
import org.opennms.netmgt.config.notifications.Varbind;
import org.opennms.netmgt.filter.FilterDao;
import org.opennms.netmgt.filter.FilterDaoFactory;
import org.opennms.netmgt.filter.FilterParseException;
import org.opennms.web.api.Util;

public class NotificationWizardServlet
extends HttpServlet {
    private static final long serialVersionUID = -8394875468854510137L;
    public static final String SOURCE_PAGE_OTHER_WEBUI = "eventslist";
    public static final String SOURCE_PAGE_NOTICES = "eventNotices.jsp";
    public static final String SOURCE_PAGE_NOTIFS_FOR_UEI = "notifsForUEI.jsp";
    public static final String SOURCE_PAGE_UEIS = "chooseUeis.jsp";
    public static final String SOURCE_PAGE_RULE = "buildRule.jsp";
    public static final String SOURCE_PAGE_VALIDATE = "validateRule.jsp";
    public static final String SOURCE_PAGE_PATH_OUTAGE = "buildPathOutage.jsp";
    public static final String SOURCE_PAGE_VALIDATE_PATH_OUTAGE = "validatePathOutage.jsp";
    public static final String SOURCE_PAGE_PATH = "choosePath.jsp";
    public static final String SOURCE_PAGE_NOTIFICATION_INDEX = "../index.jsp";
    private static final String SQL_DELETE_CRITICAL_PATH = "DELETE FROM pathoutage WHERE nodeid=?";
    private static final String SQL_SET_CRITICAL_PATH = "INSERT INTO pathoutage (nodeid, criticalpathip, criticalpathservicename) VALUES (?, ?, ?)";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sourcePage = request.getParameter("sourcePage");
        HttpSession user = request.getSession(true);
        try {
            NotifdConfigFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("Failed to initialize NotifdConfigFactory: " + e, e);
        }
        try {
            NotificationFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("Failed to initialize NotificationFactory: " + e, e);
        }
        String redirect = sourcePage.equals(SOURCE_PAGE_NOTICES) ? this.processNotices(request, user) : (sourcePage.equals(SOURCE_PAGE_UEIS) ? this.processUeis(request, user) : (sourcePage.equals(SOURCE_PAGE_RULE) ? this.processRule(request, user) : (sourcePage.equals(SOURCE_PAGE_VALIDATE) ? this.processValidate(request, user) : (sourcePage.equals(SOURCE_PAGE_PATH) ? this.processPath(request, user) : (sourcePage.equals(SOURCE_PAGE_PATH_OUTAGE) ? this.processPathOutage(request) : (sourcePage.equals(SOURCE_PAGE_VALIDATE_PATH_OUTAGE) ? this.processValidatePathOutage(request) : (sourcePage.equals(SOURCE_PAGE_OTHER_WEBUI) ? this.processOtherWebUi(request, user) : (sourcePage.equals(SOURCE_PAGE_NOTIFS_FOR_UEI) ? this.processNotificationsForUei(request, user) : ""))))))));
        if (redirect.equals("")) {
            throw new ServletException("no redirect specified for this wizard!");
        }
        response.sendRedirect(redirect);
    }

    private String processNotices(HttpServletRequest request, HttpSession user) throws ServletException {
        String userAction = request.getParameter("userAction");
        if (userAction.equals("delete")) {
            try {
                this.getNotificationFactory().removeNotification(request.getParameter("notice"));
            }
            catch (Throwable e) {
                throw new ServletException("Couldn't save/reload notifications configuration file: " + e, e);
            }
            return SOURCE_PAGE_NOTICES;
        }
        if (userAction.equals("edit")) {
            return this.edit(request, user);
        }
        if (userAction.equals("new")) {
            user.setAttribute("newNotice", (Object)this.buildNewNotification("off"));
            return SOURCE_PAGE_UEIS;
        }
        if (userAction.equals("on") || userAction.equals("off")) {
            try {
                this.getNotificationFactory().updateStatus(request.getParameter("notice"), userAction);
            }
            catch (Throwable e) {
                throw new ServletException("Couldn't save/reload notifications configuration file: " + e, e);
            }
            return SOURCE_PAGE_NOTICES;
        }
        return "";
    }

    private String processUeis(HttpServletRequest request, HttpSession user) {
        Notification newNotice = (Notification)user.getAttribute("newNotice");
        newNotice.setUei(request.getParameter("uei"));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("newRule", NotificationWizardServlet.toSingleQuote(newNotice.getRule()));
        return SOURCE_PAGE_RULE + this.makeQueryString(params);
    }

    private String processValidate(HttpServletRequest request, HttpSession user) {
        String userAction = request.getParameter("userAction");
        if (userAction.equals("rebuild")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("newRule", request.getParameter("newRule"));
            String[] services = request.getParameterValues("services");
            if (services != null) {
                params.put("services", services);
            }
            params.put("mode", "rebuild");
            return SOURCE_PAGE_RULE + this.makeQueryString(params);
        }
        Notification newNotice = (Notification)user.getAttribute("newNotice");
        newNotice.setRule(request.getParameter("newRule"));
        return SOURCE_PAGE_PATH;
    }

    private String processRule(HttpServletRequest request, HttpSession user) {
        String[] notServices;
        String ruleString = request.getParameter("newRule");
        ruleString = NotificationWizardServlet.toSingleQuote(ruleString);
        ruleString = NotificationWizardServlet.stripExtraWhite(ruleString);
        ruleString = NotificationWizardServlet.stripServices(ruleString);
        ruleString = NotificationWizardServlet.checkParens(ruleString);
        StringBuffer rule = new StringBuffer(ruleString);
        String[] services = request.getParameterValues("services");
        if (services != null) {
            rule.append(" & ").append(" (");
            for (int i = 0; i < services.length; ++i) {
                rule.append("is").append(services[i]);
                if (i >= services.length - 1) continue;
                rule.append(" | ");
            }
            rule.append(" )");
        }
        if ((notServices = request.getParameterValues("notServices")) != null) {
            rule.append(" & ").append(" (");
            for (int i = 0; i < notServices.length; ++i) {
                rule.append("!is").append(notServices[i]);
                if (i >= notServices.length - 1) continue;
                rule.append(" & ");
            }
            rule.append(" )");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("newRule", rule.toString());
        if (services != null) {
            params.put("services", services);
        }
        if (notServices != null) {
            params.put("notServices", notServices);
        }
        String redirectPage = request.getParameter("nextPage");
        try {
            this.getFilterDao().validateRule(rule.toString());
        }
        catch (FilterParseException e) {
            params.put("mode", "failed");
            redirectPage = SOURCE_PAGE_RULE;
        }
        if (redirectPage.equals(SOURCE_PAGE_PATH)) {
            Notification newNotice = (Notification)user.getAttribute("newNotice");
            newNotice.setRule(rule.toString());
        }
        return redirectPage + this.makeQueryString(params);
    }

    private String processPath(HttpServletRequest request, HttpSession user) throws ServletException {
        Notification newNotice = (Notification)user.getAttribute("newNotice");
        newNotice.setDestinationPath(request.getParameter("path"));
        String description = request.getParameter("description");
        if (description != null && !description.trim().equals("")) {
            newNotice.setDescription(description);
        } else {
            newNotice.setDescription(null);
        }
        newNotice.setTextMessage(request.getParameter("textMsg"));
        String subject = request.getParameter("subject");
        if (subject != null && !subject.trim().equals("")) {
            newNotice.setSubject(subject);
        } else {
            newNotice.setSubject(null);
        }
        String numMessage = request.getParameter("numMsg");
        if (numMessage != null && !numMessage.trim().equals("")) {
            newNotice.setNumericMessage(numMessage);
        } else {
            newNotice.setNumericMessage(null);
        }
        String oldName = newNotice.getName();
        newNotice.setName(request.getParameter("name"));
        String varbindName = request.getParameter("varbindName");
        String varbindValue = request.getParameter("varbindValue");
        Varbind varbind = newNotice.getVarbind();
        if (varbindName != null && !varbindName.trim().equals("") && varbindValue != null && !varbindValue.trim().equals("")) {
            if (varbind == null) {
                varbind = new Varbind();
                newNotice.setVarbind(varbind);
            }
            varbind.setVbname(varbindName);
            varbind.setVbvalue(varbindValue);
        } else {
            newNotice.setVarbind(null);
        }
        try {
            this.getNotificationFactory().replaceNotification(oldName, newNotice);
        }
        catch (Throwable e) {
            throw new ServletException("Couldn't save/reload notification configuration file.", e);
        }
        String suppliedReturnPage = (String)user.getAttribute("noticeWizardReturnPage");
        if (suppliedReturnPage != null && !suppliedReturnPage.equals("")) {
            user.removeAttribute("noticeWizardReturnPage");
            return suppliedReturnPage;
        }
        return SOURCE_PAGE_NOTICES;
    }

    private String processPathOutage(HttpServletRequest request) {
        String newRule = request.getParameter("newRule");
        newRule = NotificationWizardServlet.toSingleQuote(newRule);
        newRule = NotificationWizardServlet.stripExtraWhite(newRule);
        newRule = NotificationWizardServlet.stripServices(newRule);
        newRule = NotificationWizardServlet.checkParens(newRule);
        String redirectPage = SOURCE_PAGE_VALIDATE_PATH_OUTAGE;
        String criticalIp = request.getParameter("criticalIp");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (newRule != null) {
            params.put("newRule", newRule);
        }
        if (request.getParameter("criticalSvc") != null) {
            params.put("criticalSvc", request.getParameter("criticalSvc"));
        }
        if (request.getParameter("showNodes") != null) {
            params.put("showNodes", request.getParameter("showNodes"));
        }
        if (criticalIp != null && !criticalIp.equals("")) {
            params.put("criticalIp", criticalIp);
            try {
                this.getFilterDao().validateRule("IPADDR IPLIKE " + criticalIp);
            }
            catch (FilterParseException e) {
                params.put("mode", "Critical path IP failed");
                redirectPage = SOURCE_PAGE_PATH_OUTAGE;
            }
        }
        try {
            this.getFilterDao().validateRule(newRule);
        }
        catch (FilterParseException e) {
            params.put("mode", "Current rule failed");
            redirectPage = SOURCE_PAGE_PATH_OUTAGE;
        }
        return redirectPage + this.makeQueryString(params);
    }

    private String processValidatePathOutage(HttpServletRequest request) {
        String redirectPage = SOURCE_PAGE_NOTIFICATION_INDEX;
        String userAction = request.getParameter("userAction");
        String criticalIp = request.getParameter("criticalIp");
        String criticalSvc = request.getParameter("criticalSvc");
        String newRule = request.getParameter("newRule");
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (userAction != null && userAction.equals("rebuild")) {
            params.put("newRule", newRule);
            params.put("criticalIp", criticalIp);
            params.put("criticalSvc", criticalSvc);
            if (request.getParameter("showNodes") != null) {
                params.put("showNodes", request.getParameter("showNodes"));
            }
            redirectPage = SOURCE_PAGE_PATH_OUTAGE;
        } else {
            try {
                this.updatePaths(newRule, criticalIp, criticalSvc);
            }
            catch (FilterParseException e) {
                params.put("mode", "Update failed");
                redirectPage = SOURCE_PAGE_PATH_OUTAGE;
            }
            catch (SQLException e) {
                params.put("mode", "Update failed");
                redirectPage = SOURCE_PAGE_PATH_OUTAGE;
            }
        }
        return redirectPage + this.makeQueryString(params);
    }

    private String processOtherWebUi(HttpServletRequest request, HttpSession user) throws ServletException {
        boolean hasUei;
        user.setAttribute("noticeWizardReturnPage", (Object)request.getParameter("returnPage"));
        String uei = request.getParameter("uei");
        try {
            hasUei = this.getNotificationFactory().hasUei(uei);
        }
        catch (IOException e) {
            throw new ServletException("IOException while checking if there is an existing notification for UEI " + uei, (Throwable)e);
        }
        catch (MarshalException e) {
            throw new ServletException("Marshalling Exception while checking if there is an existing notification for UEI " + uei, (Throwable)e);
        }
        catch (ValidationException e) {
            throw new ServletException("Validation Exception while checking if there is an existing notification for UEI " + uei, (Throwable)e);
        }
        if (hasUei) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("uei", uei);
            return SOURCE_PAGE_NOTIFS_FOR_UEI + this.makeQueryString(params);
        }
        return this.newNotifWithUEI(request, user);
    }

    private String processNotificationsForUei(HttpServletRequest request, HttpSession user) throws ServletException {
        String userAction = request.getParameter("userAction");
        if ("edit".equals(userAction)) {
            return this.edit(request, user);
        }
        if ("new".equals(userAction)) {
            return this.newNotifWithUEI(request, user);
        }
        return "";
    }

    private String newNotifWithUEI(HttpServletRequest request, HttpSession user) {
        String uei = request.getParameter("uei");
        Notification newNotice = this.buildNewNotification("on");
        newNotice.setUei(uei);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("newRule", NotificationWizardServlet.toSingleQuote(newNotice.getRule()));
        user.setAttribute("newNotice", (Object)newNotice);
        return SOURCE_PAGE_RULE + this.makeQueryString(params);
    }

    private Notification buildNewNotification(String status) {
        Notification notice = new Notification();
        notice.setRule("IPADDR IPLIKE *.*.*.*");
        notice.setNumericMessage("111-%noticeid%");
        notice.setSubject("Notice #%noticeid%");
        notice.setStatus(status);
        return notice;
    }

    private String edit(HttpServletRequest request, HttpSession user) throws ServletException {
        Notification oldNotice;
        try {
            oldNotice = this.getNotificationFactory().getNotification(request.getParameter("notice"));
        }
        catch (Throwable e) {
            throw new ServletException("couldn't get a copy of the notification to edit.", e);
        }
        Notification newNotice = this.copyNotice(oldNotice);
        user.setAttribute("newNotice", (Object)newNotice);
        return SOURCE_PAGE_UEIS;
    }

    private Notification copyNotice(Notification oldNotice) {
        Parameter[] parameters;
        Notification newNotice = new Notification();
        newNotice.setName(oldNotice.getName());
        newNotice.setWriteable(oldNotice.getWriteable());
        newNotice.setDescription(oldNotice.getDescription());
        newNotice.setUei(oldNotice.getUei());
        newNotice.setRule(oldNotice.getRule());
        newNotice.setDestinationPath(oldNotice.getDestinationPath());
        newNotice.setNoticeQueue(oldNotice.getNoticeQueue());
        newNotice.setTextMessage(oldNotice.getTextMessage());
        newNotice.setSubject(oldNotice.getSubject());
        newNotice.setNumericMessage(oldNotice.getNumericMessage());
        newNotice.setStatus(oldNotice.getStatus());
        newNotice.setVarbind(oldNotice.getVarbind());
        for (Parameter parameter : parameters = oldNotice.getParameter()) {
            Parameter newParam = new Parameter();
            newParam.setName(parameter.getName());
            newParam.setValue(parameter.getValue());
            newNotice.addParameter(newParam);
        }
        return newNotice;
    }

    private String makeQueryString(Map<String, Object> map) {
        StringBuffer buffer = new StringBuffer();
        String separator = "?";
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof String[]) {
                String[] list = (String[])value;
                for (int j = 0; j < list.length; ++j) {
                    buffer.append(separator).append(key).append("=").append(Util.encode((String)list[j]));
                    separator = "&";
                }
            } else {
                buffer.append(separator).append(key).append("=").append(Util.encode((String)((String)value)));
            }
            separator = "&";
        }
        return buffer.toString();
    }

    private static String toSingleQuote(String rule) {
        StringBuffer buffer = new StringBuffer(rule);
        for (int i = 0; i < buffer.length(); ++i) {
            if (i < buffer.length() - 5 && buffer.substring(i, i + 6).equals("&quot;")) {
                buffer.replace(i, i + 6, "'");
                continue;
            }
            if (buffer.charAt(i) != '\"') continue;
            buffer.replace(i, i + 1, "'");
        }
        return buffer.toString();
    }

    private static String stripExtraWhite(String s) {
        Pattern pattern1 = Pattern.compile("\\s+");
        Matcher matcher1 = pattern1.matcher(s);
        String mys1 = matcher1.replaceAll(" ");
        Pattern pattern2 = Pattern.compile("^\\s");
        Matcher matcher2 = pattern2.matcher(mys1);
        String mys2 = matcher2.replaceAll("");
        Pattern pattern3 = Pattern.compile("\\s$");
        Matcher matcher3 = pattern3.matcher(mys2);
        return matcher3.replaceAll("");
    }

    private static String stripServices(String s) {
        String myregex = "\\s*\\&\\s*\\(\\s*\\!?is.+";
        Pattern pattern = Pattern.compile(myregex);
        Matcher matcher = pattern.matcher(s);
        return matcher.replaceAll("");
    }

    private static String checkParens(String rule) {
        if (rule.length() == 0) {
            return rule;
        }
        if (rule.charAt(0) != '(' || rule.charAt(rule.length() - 1) != ')') {
            return "(" + rule + ")";
        }
        return rule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCriticalPath(int node, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            stmt = conn.prepareStatement(SQL_DELETE_CRITICAL_PATH);
            d.watch((Object)stmt);
            stmt.setInt(1, node);
            stmt.execute();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCriticalPath(int node, String criticalIp, String criticalSvc, Connection conn) throws SQLException {
        PreparedStatement stmt = null;
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            stmt = conn.prepareStatement(SQL_SET_CRITICAL_PATH);
            d.watch((Object)stmt);
            stmt.setInt(1, node);
            stmt.setString(2, criticalIp);
            stmt.setString(3, criticalSvc);
            stmt.execute();
        }
        finally {
            d.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePaths(String rule, String criticalIp, String criticalSvc) throws FilterParseException, SQLException {
        Connection conn = Vault.getDbConnection();
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass(), new Object[]{conn});
        try {
            SortedMap nodes = this.getFilterDao().getNodeMap(rule);
            for (Integer key : nodes.keySet()) {
                this.deleteCriticalPath(key, conn);
                if (criticalIp == null || criticalIp.equals("")) continue;
                this.setCriticalPath(key, criticalIp, criticalSvc, conn);
            }
        }
        finally {
            d.cleanUp();
        }
    }

    private FilterDao getFilterDao() {
        return FilterDaoFactory.getInstance();
    }

    private NotificationFactory getNotificationFactory() {
        return NotificationFactory.getInstance();
    }
}

