/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.nodeManagement;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.DBUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.NotificationFactory;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.admin.nodeManagement.ManagedInterface;
import org.opennms.web.admin.nodeManagement.ManagedService;
import org.opennms.web.api.Util;

public class ManageNodesServlet
extends HttpServlet {
    private static final long serialVersionUID = -4938417809629844445L;
    private static final String UPDATE_SERVICE = "UPDATE ifservices SET status = ? WHERE ipaddr = ? AND nodeID = ? AND serviceid = ?";
    private static final String DELETE_SERVICE_OUTAGES = "DELETE FROM outages WHERE ipaddr = ? AND nodeID = ? AND serviceid = ? AND ifregainedservice IS NULL";
    private static final String INCLUDE_FILE_NAME = "include";
    public static final String NOTICE_NAME = "Email-Reporting";

    public void init() throws ServletException {
        try {
            DataSourceFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("Could not initialize database factory: " + e.getMessage(), e);
        }
        try {
            NotificationFactory.init();
        }
        catch (Throwable e) {
            throw new ServletException("Could not initialize notification factory: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession userSession = request.getSession(false);
        List<ManagedInterface> allNodes = this.getManagedInterfacesFromSession(userSession);
        List<String> interfaceList = this.getList(request.getParameterValues("interfaceCheck"));
        List<String> serviceList = this.getList(request.getParameterValues("serviceCheck"));
        ArrayList<String> addToURL = new ArrayList<String>();
        ArrayList<String> unmanageInterfacesList = new ArrayList<String>();
        ArrayList<String> manageInterfacesList = new ArrayList<String>();
        DBUtils d = new DBUtils(((Object)((Object)this)).getClass());
        try {
            Connection connection = Vault.getDbConnection();
            d.watch((Object)connection);
            try {
                connection.setAutoCommit(false);
                PreparedStatement stmt = connection.prepareStatement(UPDATE_SERVICE);
                d.watch((Object)stmt);
                PreparedStatement outagesstmt = connection.prepareStatement(DELETE_SERVICE_OUTAGES);
                d.watch((Object)outagesstmt);
                for (int j = 0; j < allNodes.size(); ++j) {
                    ManagedInterface curInterface = allNodes.get(j);
                    String intKey = curInterface.getNodeid() + "-" + curInterface.getAddress();
                    if (interfaceList.contains(intKey)) {
                        addToURL.add(curInterface.getAddress());
                    }
                    if (interfaceList.contains(intKey) && curInterface.getStatus().equals("unmanaged")) {
                        manageInterfacesList.add(curInterface.getAddress());
                    } else if (!interfaceList.contains(intKey) && curInterface.getStatus().equals("managed")) {
                        unmanageInterfacesList.add(curInterface.getAddress());
                    }
                    List<ManagedService> interfaceServices = curInterface.getServices();
                    for (int k = 0; k < interfaceServices.size(); ++k) {
                        ManagedService curService = interfaceServices.get(k);
                        String serviceKey = intKey + "-" + curService.getId();
                        if (serviceList.contains(serviceKey) && curService.getStatus().equals("unmanaged")) {
                            stmt.setString(1, "R");
                            stmt.setString(2, curInterface.getAddress());
                            stmt.setInt(3, curInterface.getNodeid());
                            stmt.setInt(4, curService.getId());
                            this.log("DEBUG: executing manage service update for " + curInterface.getAddress() + " " + curService.getName());
                            stmt.executeUpdate();
                            continue;
                        }
                        if (serviceList.contains(serviceKey) || !curService.getStatus().equals("managed")) continue;
                        EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/serviceUnmanaged", "web ui");
                        bldr.setNodeid((long)curInterface.getNodeid());
                        bldr.setInterface(InetAddressUtils.addr((String)curInterface.getAddress()));
                        bldr.setService(curService.getName());
                        this.sendEvent(bldr.getEvent());
                        stmt.setString(1, "S");
                        stmt.setString(2, curInterface.getAddress());
                        stmt.setInt(3, curInterface.getNodeid());
                        stmt.setInt(4, curService.getId());
                        outagesstmt.setString(1, curInterface.getAddress());
                        outagesstmt.setInt(2, curInterface.getNodeid());
                        outagesstmt.setInt(3, curService.getId());
                        this.log("DEBUG: executing unmanage service update for " + curInterface.getAddress() + " " + curService.getName());
                        stmt.executeUpdate();
                        outagesstmt.executeUpdate();
                    }
                }
                if (manageInterfacesList.size() > 0) {
                    this.manageInterfaces(manageInterfacesList, connection);
                }
                if (unmanageInterfacesList.size() > 0) {
                    this.unmanageInterfaces(unmanageInterfacesList, connection);
                }
                this.writeURLFile(addToURL);
                connection.commit();
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            d.cleanUp();
        }
        this.sendSCMRestartEvent();
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/manageNodesFinish.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private List<ManagedInterface> getManagedInterfacesFromSession(HttpSession userSession) {
        if (userSession == null) {
            return null;
        }
        return (List)userSession.getAttribute("listAll.manage.jsp");
    }

    private void manageInterfaces(List<String> interfaces, Connection connection) throws SQLException {
        StringBuffer query = new StringBuffer("UPDATE ipinterface SET isManaged = ");
        query.append("'M'").append(" WHERE ipaddr IN (");
        for (int i = 0; i < interfaces.size(); ++i) {
            query.append("'").append(interfaces.get(i)).append("'");
            if (i >= interfaces.size() - 1) continue;
            query.append(",");
        }
        query.append(")");
        this.log("DEBUG: " + query.toString());
        Statement update = connection.createStatement();
        update.executeUpdate(query.toString());
        update.close();
    }

    private void unmanageInterfaces(List<String> interfaces, Connection connection) throws SQLException {
        StringBuffer query = new StringBuffer("UPDATE ipinterface SET isManaged = ");
        query.append("'F'").append(" WHERE ipaddr IN (");
        for (int i = 0; i < interfaces.size(); ++i) {
            query.append("'").append(interfaces.get(i)).append("'");
            if (i >= interfaces.size() - 1) continue;
            query.append(",");
        }
        query.append(")");
        this.log("DEBUG: " + query.toString());
        Statement update = connection.createStatement();
        update.executeUpdate(query.toString());
        update.close();
    }

    private void sendSCMRestartEvent() throws ServletException {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/restartSCM", "web ui");
        this.sendEvent(bldr.getEvent());
    }

    private void writeURLFile(List<String> interfaceList) throws ServletException {
        String path = System.getProperty("opennms.home") + File.separator + "etc" + File.separator;
        String fileName = path + INCLUDE_FILE_NAME;
        OutputStreamWriter fileWriter = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            fileWriter = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            for (int i = 0; i < interfaceList.size(); ++i) {
                fileWriter.write(interfaceList.get(i) + System.getProperty("line.separator"));
            }
            ((Writer)fileWriter).flush();
        }
        catch (IOException e) {
            try {
                throw new ServletException("Error writing the include url file " + fileName + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                IOUtils.closeQuietly((OutputStream)fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fileWriter);
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private List<String> getList(String[] array) {
        ArrayList<String> newList = new ArrayList<String>();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                newList.add(array[i]);
            }
        }
        return newList;
    }

    private void sendEvent(Event event) throws ServletException {
        try {
            Util.createEventProxy().send(event);
        }
        catch (Throwable e) {
            throw new ServletException("Could not send event " + event.getUei(), e);
        }
    }
}

