/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.admin.discovery;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.IncludeUrl;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventProxy;
import org.opennms.web.admin.discovery.GeneralSettingsLoader;
import org.opennms.web.admin.discovery.ModifyDiscoveryConfigurationServlet;
import org.opennms.web.api.Util;

public class ActionDiscoveryServlet
extends HttpServlet {
    private static final long serialVersionUID = 2L;
    protected static ThreadCategory log = ThreadCategory.getInstance((String)"WEB");
    public static String addSpecificAction = "AddSpecific";
    public static String removeSpecificAction = "RemoveSpecific";
    public static String addIncludeRangeAction = "AddIncludeRange";
    public static String removeIncludeRangeAction = "RemoveIncludeRange";
    public static String addIncludeUrlAction = "AddIncludeUrl";
    public static String removeIncludeUrlAction = "RemoveIncludeUrl";
    public static String addExcludeRangeAction = "AddExcludeRange";
    public static String removeExcludeRangeAction = "RemoveExcludeRange";
    public static String saveAndRestartAction = "SaveAndRestart";

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String specificIndex;
        String retries;
        log.info("Loading Discovery configuration.");
        HttpSession sess = request.getSession(true);
        DiscoveryConfiguration config = (DiscoveryConfiguration)sess.getAttribute("discoveryConfiguration");
        if (config == null) {
            config = ModifyDiscoveryConfigurationServlet.getDiscoveryConfig();
            sess.setAttribute("discoveryConfiguration", (Object)config);
        }
        config = GeneralSettingsLoader.load(request, config);
        String action = request.getParameter("action");
        log.debug("action: " + action);
        if (action.equals(addSpecificAction)) {
            log.debug("Adding Specific");
            String ipAddr = request.getParameter("specificipaddress");
            String timeout = request.getParameter("specifictimeout");
            retries = request.getParameter("specificretries");
            Specific newSpecific = new Specific();
            newSpecific.setContent(ipAddr);
            if (timeout != null && !timeout.trim().equals("") && !timeout.equals(config.getTimeout())) {
                newSpecific.setTimeout(WebSecurityUtils.safeParseLong((String)timeout));
            }
            if (retries != null && !retries.trim().equals("") && !retries.equals(config.getRetries())) {
                newSpecific.setRetries(WebSecurityUtils.safeParseInt((String)retries));
            }
            config.addSpecific(newSpecific);
        }
        if (action.equals(removeSpecificAction)) {
            log.debug("Removing Specific");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            Specific spec = config.getSpecific(index);
            boolean result = config.removeSpecific(spec);
            log.debug("Removing Specific result = " + result);
        }
        if (action.equals(addIncludeRangeAction)) {
            log.debug("Adding Include Range");
            String ipAddrBase = request.getParameter("irbase");
            String ipAddrEnd = request.getParameter("irend");
            String timeout = request.getParameter("irtimeout");
            String retries2 = request.getParameter("irretries");
            IncludeRange newIR = new IncludeRange();
            newIR.setBegin(ipAddrBase);
            newIR.setEnd(ipAddrEnd);
            if (timeout != null && !timeout.trim().equals("") && !timeout.equals(config.getTimeout())) {
                newIR.setTimeout(WebSecurityUtils.safeParseLong((String)timeout));
            }
            if (retries2 != null && !retries2.trim().equals("") && !retries2.equals(config.getRetries())) {
                newIR.setRetries(WebSecurityUtils.safeParseInt((String)retries2));
            }
            config.addIncludeRange(newIR);
        }
        if (action.equals(removeIncludeRangeAction)) {
            log.debug("Removing Include Range");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            IncludeRange ir = config.getIncludeRange(index);
            boolean result = config.removeIncludeRange(ir);
            log.debug("Removing Include Range result = " + result);
        }
        if (action.equals(addIncludeUrlAction)) {
            log.debug("Adding Include URL");
            String url = request.getParameter("iuurl");
            String timeout = request.getParameter("iutimeout");
            retries = request.getParameter("iuretries");
            IncludeUrl iu = new IncludeUrl();
            iu.setContent(url);
            if (timeout != null && !timeout.trim().equals("") && !timeout.equals(config.getTimeout())) {
                iu.setTimeout(WebSecurityUtils.safeParseLong((String)timeout));
            }
            if (retries != null && !retries.trim().equals("") && !retries.equals(config.getRetries())) {
                iu.setRetries(WebSecurityUtils.safeParseInt((String)retries));
            }
            config.addIncludeUrl(iu);
        }
        if (action.equals(removeIncludeUrlAction)) {
            log.debug("Removing Include URL");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            IncludeUrl iu = config.getIncludeUrl(index);
            boolean result = config.removeIncludeUrl(iu);
            log.debug("Removing Include URL result = " + result);
        }
        if (action.equals(addExcludeRangeAction)) {
            log.debug("Adding Exclude Range");
            String ipAddrBegin = request.getParameter("erbegin");
            String ipAddrEnd = request.getParameter("erend");
            ExcludeRange newER = new ExcludeRange();
            newER.setBegin(ipAddrBegin);
            newER.setEnd(ipAddrEnd);
            config.addExcludeRange(newER);
        }
        if (action.equals(removeExcludeRangeAction)) {
            log.debug("Removing Exclude Range");
            specificIndex = request.getParameter("index");
            int index = WebSecurityUtils.safeParseInt((String)specificIndex);
            ExcludeRange er = config.getExcludeRange(index);
            boolean result = config.removeExcludeRange(er);
            log.debug("Removing Exclude Range result = " + result);
        }
        if (action.equals(saveAndRestartAction)) {
            DiscoveryConfigFactory dcf = null;
            try {
                if (log.isDebugEnabled()) {
                    StringWriter configString = new StringWriter();
                    config.marshal((Writer)configString);
                    log.debug(configString.toString().trim());
                }
                DiscoveryConfigFactory.init();
                dcf = DiscoveryConfigFactory.getInstance();
                dcf.saveConfiguration(config);
            }
            catch (Throwable ex) {
                log.error("Error while saving configuration. " + ex);
                throw new ServletException(ex);
            }
            EventProxy proxy = null;
            try {
                proxy = Util.createEventProxy();
            }
            catch (Throwable me) {
                log.error(me.getMessage());
            }
            EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/discoveryConfigChange", "ActionDiscoveryServlet");
            bldr.setHost("host");
            try {
                proxy.send(bldr.getEvent());
            }
            catch (Throwable me) {
                log.error(me.getMessage());
            }
            log.info("Restart Discovery requested!");
            sess.removeAttribute("discoveryConfiguration");
            response.sendRedirect(Util.calculateUrlBase((HttpServletRequest)request, (String)"event/query?msgmatchany=Discovery"));
            return;
        }
        sess.setAttribute("discoveryConfiguration", (Object)config);
        RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/admin/discovery/edit-config.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

