/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.user.client.ui.ListBox;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.DirectionalChangeHandler;

public class ValidatedListBox
extends ListBox {
    private Dashlet m_dashlet;
    private boolean m_allowWrapAround = true;
    private ValidatedListBox m_parent = null;
    private DirectionalChangeHandler m_directionalChangeHandler = null;

    public ValidatedListBox(Dashlet dashlet) {
        this.m_dashlet = dashlet;
    }

    public void setParent(ValidatedListBox parent) {
        this.m_parent = parent;
    }

    public void setDirectionalChangeHandler(DirectionalChangeHandler handler) {
        this.m_directionalChangeHandler = handler;
    }

    public String getSelectedValue() {
        int index = this.getSelectedIndex();
        if (index < 0 || index >= this.getItemCount()) {
            this.m_dashlet.error("Error: list box index " + index + " is out of range");
            return null;
        }
        return this.getValue(index);
    }

    public String getRelativeSelectedValue(int offset) {
        int relativeIndex = this.getSelectedIndex() + offset;
        if (relativeIndex < 0 || relativeIndex >= this.getItemCount()) {
            return null;
        }
        return this.getValue(relativeIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void adjustSelectedValue(int direction) {
        int newPrefabIndex = this.getSelectedIndex() + direction;
        if (newPrefabIndex < 0) {
            if (this.m_parent != null) {
                this.m_parent.adjustSelectedValue(-1);
                return;
            }
            if (!this.m_allowWrapAround) return;
            newPrefabIndex = this.getItemCount() - 1;
        } else if (newPrefabIndex >= this.getItemCount()) {
            if (this.m_parent != null) {
                this.m_parent.adjustSelectedValue(1);
                return;
            }
            if (!this.m_allowWrapAround) return;
            newPrefabIndex = 0;
        }
        this.setSelectedIndex(newPrefabIndex);
        if (this.m_directionalChangeHandler == null) return;
        this.m_directionalChangeHandler.onChange(null, direction);
    }
}

