/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.dashboard.client;

import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import org.opennms.dashboard.client.Alarm;
import org.opennms.dashboard.client.Dashlet;
import org.opennms.dashboard.client.PageableTableView;

class AlarmView
extends PageableTableView {
    private Alarm[] m_alarms;
    private RegExp m_regex = RegExp.compile((String)"<(.|\n)*?>", (String)"g");

    AlarmView(Dashlet dashlet) {
        super(dashlet, 5, new String[]{"Node", "Description", "Count", "First Time", "Last Time"});
    }

    public void setAlarms(Alarm[] alarms) {
        this.m_alarms = alarms;
        this.refresh();
    }

    @Override
    protected void setRow(FlexTable table, int row, int elementIndex) {
        Alarm alarm = this.m_alarms[elementIndex];
        if (alarm.getIsDashboardRole()) {
            table.setText(row, 0, alarm.getNodeLabel());
        } else {
            table.setHTML(row, 0, "<a href=\"element/node.jsp?node=" + alarm.getNodeId() + "\">" + alarm.getNodeLabel() + "</a>");
        }
        HTML label = new HTML();
        label.setTitle(this.stripHtmlTags(alarm.getDescrption()));
        label.setHTML(SafeHtmlUtils.fromTrustedString((String)alarm.getLogMsg()));
        table.setWidget(row, 1, (Widget)label);
        table.setText(row, 2, "" + alarm.getCount());
        table.setText(row, 3, alarm.getFirstEventTime().toString());
        table.setText(row, 4, alarm.getLastEventTime().toString());
        table.getRowFormatter().setStyleName(row, alarm.getSeverity());
    }

    private String stripHtmlTags(String description) {
        return this.m_regex.replace(description, "");
    }

    @Override
    public int getElementCount() {
        return this.m_alarms == null ? 0 : this.m_alarms.length;
    }

    @Override
    protected void formatCells(FlexTable table, int row) {
        super.formatCells(table, row);
        table.getCellFormatter().addStyleName(row, 1, "bright");
    }
}

