/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Parm;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.opennms.web.rest.AbstractSpringJerseyRestTestCase;
import org.opennms.web.rest.MockEventProxy;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-daemon.xml", "classpath:/restServiceTest.xml"})
@JUnitConfigurationEnvironment
public class RequisitionRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    @Test
    public void testRequisition() throws Exception {
        this.cleanUpImports();
        this.createRequisition();
        String url = "/requisitions";
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("Management interface"));
        url = "/requisitions/test";
        this.sendRequest(DELETE, url, 200);
        xml = this.sendRequest(GET, url, 204);
    }

    @Test
    public void testDuplicateNodes() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
        String req = "<model-import xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" date-stamp=\"2006-03-09T00:03:09\" foreign-source=\"test\"><node node-label=\"a\" foreign-id=\"a\" /><node node-label=\"b\" foreign-id=\"c\" /><node node-label=\"c\" foreign-id=\"c\" /></model-import>";
        MockHttpServletResponse response = this.sendPost("/requisitions", req, 400, null);
        Assert.assertTrue((String)"response should say 'c' has duplicates", (boolean)response.getContentAsString().contains("Duplicate nodes found on foreign source test: c (2 found)"));
    }

    @Test
    public void testNodes() throws Exception {
        this.createRequisition();
        String url = "/requisitions/test/nodes";
        this.sendPost(url, "<node xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" node-label=\"shoe\" parent-node-label=\"david\" foreign-id=\"1111\" />", 303, "/test/nodes/1111");
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<node "));
        Assert.assertTrue((boolean)xml.contains("node-label="));
        Assert.assertTrue((boolean)xml.contains("count=\"2\""));
        url = "/requisitions/test/nodes/4243";
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("parent-node-label=\"apknd\""));
        Assert.assertTrue((boolean)xml.contains("node-label=\"apknd\""));
        this.sendPut(url, "node-label=homo+sapien", 303, "/nodes/4243");
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("node-label=\"homo sapien\""));
        xml = this.sendRequest(DELETE, url, 200);
        xml = this.sendRequest(GET, url, 404);
    }

    @Test
    public void testAddExistingNode() throws Exception {
        this.createRequisition();
        String url = "/requisitions/test/nodes";
        this.sendPost(url, "<node xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" node-label=\"shoe\" parent-node-label=\"david\" foreign-id=\"4243\" />", 303, "/requisitions/test/nodes/4243");
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("<node "));
        Assert.assertTrue((boolean)xml.contains("node-label="));
        Assert.assertTrue((String)"Expected only 1 node", (boolean)xml.contains("count=\"1\""));
    }

    @Test
    public void testNodeInterfaces() throws Exception {
        this.createRequisition();
        String base = "/requisitions/test/nodes/4243/interfaces";
        this.sendPost(base, "<interface xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" status=\"1\" snmp-primary=\"S\" ip-addr=\"172.20.1.254\" descr=\"Monkey\"><monitored-service service-name=\"ICMP\"/></interface>", 303, "/nodes/4243/interfaces/172.20.1.254");
        this.sendPost(base, "<interface xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" status=\"1\" snmp-primary=\"S\" ip-addr=\"172.20.1.254\" descr=\"Blah\"><monitored-service service-name=\"ICMP\"/></interface>", 303, "/nodes/4243/interfaces/172.20.1.254");
        String xml = this.sendRequest(GET, base, 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("count=\"3\""));
        Assert.assertTrue((String)xml, (boolean)xml.contains("<interface "));
        Assert.assertTrue((String)xml, (boolean)xml.contains("Blah"));
        Assert.assertFalse((String)xml, (boolean)xml.contains("Monkey"));
        String url = base + "/172.20.1.204";
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("<interface "));
        Assert.assertTrue((String)xml, (boolean)xml.contains("VPN interface"));
        Assert.assertFalse((String)xml, (boolean)xml.contains("172.20.1.201"));
        this.sendPut(url, "status=3&descr=Total+Crap&snmp-primary=P", 303, "/nodes/4243/interfaces/172.20.1.204");
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("descr=\"Total Crap\""));
        Assert.assertTrue((String)xml, (boolean)xml.contains("snmp-primary=\"P\""));
        Assert.assertTrue((String)xml, (boolean)xml.contains("status=\"3\""));
        xml = this.sendRequest(DELETE, url, 200);
        xml = this.sendRequest(GET, url, 404);
        xml = this.sendRequest(GET, base, 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("count=\"2\""));
    }

    @Test
    public void testNodeInterfaceServices() throws Exception {
        this.createRequisition();
        String base = "/requisitions/test/nodes/4243/interfaces/172.20.1.204/services";
        this.sendPost(base, "<monitored-service xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" service-name=\"MONKEY\" />", 303, "/interfaces/172.20.1.204/services/MONKEY");
        String xml = this.sendRequest(GET, base, 200);
        Assert.assertTrue((boolean)xml.contains("count=\"3\""));
        Assert.assertTrue((boolean)xml.contains("ICMP"));
        String url = base + "/ICMP";
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("service-name=\"ICMP\""));
        xml = this.sendRequest(DELETE, url, 200);
        xml = this.sendRequest(GET, url, 404);
        xml = this.sendRequest(GET, base, 200);
        Assert.assertTrue((boolean)xml.contains("count=\"2\""));
    }

    @Test
    public void testNodeCategories() throws Exception {
        this.createRequisition();
        String base = "/requisitions/test/nodes/4243/categories";
        this.sendPost(base, "<category xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" name=\"Dead Servers\" />", 303, "/nodes/4243/categories/Dead%20Servers");
        String url = base;
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("count=\"4\""));
        Assert.assertTrue((boolean)xml.contains("name=\"low\""));
        url = "/requisitions/test/nodes/4243/categories/low";
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((boolean)xml.contains("name=\"low\""));
        xml = this.sendRequest(DELETE, url, 200);
        xml = this.sendRequest(GET, url, 404);
        xml = this.sendRequest(GET, "/requisitions/test/nodes/4243/categories", 200);
        Assert.assertTrue((boolean)xml.contains("count=\"3\""));
        base = "/requisitions/test/nodes/4244/categories";
        this.sendPost(base, "<category xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" name=\"New Category\" />", 303, "/nodes/4244/categories/New%20Category");
        xml = this.sendRequest(GET, base + "/New%20Category", 404);
    }

    @Test
    public void testNodeAssets() throws Exception {
        this.createRequisition();
        String base = "/requisitions/test/nodes/4243/assets";
        this.sendPost(base, "<asset xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" name=\"manufacturer\" value=\"Dead Servers, Inc.\" />", 303, "/nodes/4243/assets/manufacturer");
        String url = base;
        String xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("count=\"3\""));
        Assert.assertTrue((String)xml, (boolean)xml.contains("Windows Pi"));
        url = "/requisitions/test/nodes/4243/assets/operatingSystem";
        xml = this.sendRequest(GET, url, 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("value=\"Windows Pi\""));
        xml = this.sendRequest(DELETE, url, 200);
        xml = this.sendRequest(GET, url, 404);
        xml = this.sendRequest(GET, "/requisitions/test/nodes/4243/assets", 200);
        Assert.assertTrue((String)xml, (boolean)xml.contains("count=\"2\""));
    }

    @Test
    public void testCreateRequisitionNoNamespace() throws Exception {
        String req = "<model-import date-stamp=\"2006-03-09T00:03:09\" foreign-source=\"test\"><node node-label=\"david\" parent-node-label=\"apknd\" foreign-id=\"4243\"><interface ip-addr=\"172.20.1.204\" status=\"1\" snmp-primary=\"S\" descr=\"VPN interface\"><monitored-service service-name=\"ICMP\"/><monitored-service service-name=\"HTTP\"/></interface><interface ip-addr=\"172.20.1.201\" status=\"1\" snmp-primary=\"P\" descr=\"Management interface\"><monitored-service service-name=\"ICMP\"/><monitored-service service-name=\"SNMP\"/></interface><category name=\"AC\"/><category name=\"UK\"/><category name=\"low\"/><asset name=\"manufacturer\" value=\"Dell\" /><asset name=\"operatingSystem\" value=\"Windows Pi\" /><asset name=\"description\" value=\"Large and/or In Charge\" /></node></model-import>";
        this.sendPost("/requisitions", req, 303, "/requisitions/test");
    }

    @Test
    @Ignore
    public void testBadRequisition() throws Exception {
        String req = "<model-import date-stamp=\"2006-03-09T00:03:09\" foreign-source=\"test\">asdfjklasdfjioasdf<node node-label=\"david\" parent-node-label=\"apknd\" foreign-id=\"4243\"><interface ip-addr=\"172.20.1.204\" status=\"1\" snmp-primary=\"S\" descr=\"VPN interface\"><monitored-service service-name=\"ICMP\"/><monitored-service service-name=\"HTTP\"/></interface><interface ip-addr=\"172.20.1.201\" status=\"1\" snmp-primary=\"P\" descr=\"Management interface\"><monitored-service service-name=\"ICMP\"/><monitored-service service-name=\"SNMP\"/></interface><category name=\"AC\"/><category name=\"UK\"/><category name=\"low\"/><asset name=\"manufacturer\" value=\"Dell\" /><asset name=\"operatingSystem\" value=\"Windows Pi\" /><asset name=\"description\" value=\"Large and/or In Charge\" /></node></model-import>";
        Exception ex = null;
        try {
            this.sendPost("/requisitions", req, 500, null);
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertNotNull((String)"we should have an exception", (Object)ex);
        Assert.assertTrue((String)"validator should expect only elements", (boolean)ex.getMessage().contains("content type is element-only"));
    }

    @Test
    public void testImport() throws Exception {
        this.createRequisition();
        MockEventProxy eventProxy = this.getEventProxy();
        eventProxy.resetEvents();
        this.sendRequest(PUT, "/requisitions/test/import", 303);
        Assert.assertEquals((long)1L, (long)eventProxy.getEvents().size());
    }

    @Test
    public void testImportNoRescan() throws Exception {
        this.createRequisition();
        MockEventProxy eventProxy = this.getEventProxy();
        eventProxy.resetEvents();
        this.sendRequest(PUT, "/requisitions/test/import", RequisitionRestServiceTest.parseParamData("rescanExisting=false"), 303);
        Assert.assertEquals((long)1L, (long)eventProxy.getEvents().size());
        Event event = eventProxy.getEvents().get(0);
        List parms = event.getParmCollection();
        Assert.assertEquals((long)2L, (long)parms.size());
        Assert.assertEquals((Object)"false", (Object)((Parm)parms.get(1)).getValue().getContent());
    }

    private void createRequisition() throws Exception {
        String req = "<model-import xmlns=\"http://xmlns.opennms.org/xsd/config/model-import\" date-stamp=\"2006-03-09T00:03:09\" foreign-source=\"test\"><node node-label=\"david\" parent-node-label=\"apknd\" foreign-id=\"4243\"><interface ip-addr=\"172.20.1.204\" status=\"1\" snmp-primary=\"S\" descr=\"VPN interface\"><monitored-service service-name=\"ICMP\"/><monitored-service service-name=\"HTTP\"/></interface><interface ip-addr=\"172.20.1.201\" status=\"1\" snmp-primary=\"P\" descr=\"Management interface\"><monitored-service service-name=\"ICMP\"/><monitored-service service-name=\"SNMP\"/></interface><category name=\"AC\"/><category name=\"UK\"/><category name=\"low\"/><asset name=\"manufacturer\" value=\"Dell\" /><asset name=\"operatingSystem\" value=\"Windows Pi\" /><asset name=\"description\" value=\"Large and/or In Charge\" /></node></model-import>";
        this.sendPost("/requisitions", req, 303, "/requisitions/test");
    }

    private MockEventProxy getEventProxy() {
        return this.getBean("eventProxy", MockEventProxy.class);
    }
}

