/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.OnmsGroup;
import org.opennms.netmgt.model.OnmsGroupList;
import org.opennms.web.rest.AbstractSpringJerseyRestTestCase;

public class GroupRestServiceTest
extends AbstractSpringJerseyRestTestCase {
    @Override
    protected void afterServletStart() throws Exception {
        MockLogAppender.setupLogging((boolean)true, (String)"DEBUG");
    }

    @Test
    public void testGroup() throws Exception {
        String xml = this.sendRequest(GET, "/groups", 200);
        Assert.assertTrue((boolean)xml.contains("Admin"));
        OnmsGroupList list = (OnmsGroupList)JaxbUtils.unmarshal(OnmsGroupList.class, (String)xml);
        Assert.assertEquals((long)1L, (long)list.getGroups().size());
        Assert.assertEquals((String)xml, (Object)"Admin", (Object)((OnmsGroup)list.getGroups().get(0)).getName());
        xml = this.sendRequest(GET, "/groups/Admin", 200);
        Assert.assertTrue((boolean)xml.contains(">Admin<"));
        this.sendRequest(GET, "/groups/idontexist", 404);
    }

    @Test
    public void testWriteGroup() throws Exception {
        this.createGroup("test");
        String xml = this.sendRequest(GET, "/groups/test", 200);
        Assert.assertTrue((boolean)xml.contains("<group><name>test</name>"));
        this.sendPut("/groups/test", "comments=MONKEYS", 303, "/groups/test");
        xml = this.sendRequest(GET, "/groups/test", 200);
        Assert.assertTrue((boolean)xml.contains(">MONKEYS<"));
    }

    @Test
    public void testDeleteGroup() throws Exception {
        this.createGroup("deleteMe");
        String xml = this.sendRequest(GET, "/groups", 200);
        Assert.assertTrue((boolean)xml.contains("deleteMe"));
        this.sendRequest(DELETE, "/groups/idontexist", 400);
        this.sendRequest(DELETE, "/groups/deleteMe", 200);
        this.sendRequest(GET, "/groups/deleteMe", 404);
    }

    @Test
    public void testUsers() throws Exception {
        this.createGroup("deleteMe");
        this.sendRequest(PUT, "/groups/deleteMe/users/totallyUniqueUser", 303);
        String xml = this.sendRequest(GET, "/groups/deleteMe", 200);
        Assert.assertTrue((boolean)xml.contains("totallyUniqueUser"));
        this.sendRequest(DELETE, "/groups/deleteMe/users/totallyBogusUser", 400);
        this.sendRequest(DELETE, "/groups/deleteMe/users/totallyUniqueUser", 200);
        xml = this.sendRequest(GET, "/groups/deleteMe", 200);
        Assert.assertFalse((boolean)xml.contains("totallyUniqueUser"));
    }

    protected void createGroup(String groupname) throws Exception {
        String group = "<group><name>" + groupname + "</name>" + "<comments>" + groupname + "</comments>" + "</group>";
        this.sendPost("/groups", group, 303, "/groups/" + groupname);
    }
}

