/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.spring.container.servlet.SpringServlet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.sql.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.test.db.MockDatabase;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.utils.StringUtils;
import org.opennms.test.DaoTestConfigBean;
import org.opennms.web.rest.MockUserPrincipal;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletConfig;
import org.springframework.mock.web.MockServletContext;
import org.springframework.orm.hibernate3.support.OpenSessionInViewFilter;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class AbstractSpringJerseyRestTestCase {
    public static String GET = "GET";
    public static String POST = "POST";
    public static String DELETE = "DELETE";
    public static String PUT = "PUT";
    String contextPath = "/opennms/rest";
    private ServletContainer dispatcher;
    private MockServletConfig servletConfig;
    private MockServletContext servletContext;
    private ContextLoaderListener contextListener;
    private Filter filter;
    private WebApplicationContext m_webAppContext;
    private String m_username = "admin";
    private Set<String> m_roles = Collections.synchronizedSet(new HashSet<String>(Collections.singletonList("ROLE_ADMIN")));

    @Before
    public void setUp() throws Throwable {
        this.clearUserInfo();
        this.beforeServletStart();
        DaoTestConfigBean bean = new DaoTestConfigBean();
        bean.afterPropertiesSet();
        MockDatabase db = new MockDatabase(true);
        DataSourceFactory.setInstance((DataSource)db);
        this.setServletContext(new MockServletContext("file:src/main/webapp"));
        this.getServletContext().addInitParameter("contextConfigLocation", "classpath:/org/opennms/web/rest/applicationContext-test.xml classpath:/META-INF/opennms/applicationContext-commonConfigs.xml classpath:/META-INF/opennms/applicationContext-soa.xml classpath*:/META-INF/opennms/component-service.xml classpath*:/META-INF/opennms/component-dao.xml classpath:/META-INF/opennms/applicationContext-reportingCore.xml classpath:/META-INF/opennms/applicationContext-databasePopulator.xml classpath:/org/opennms/web/svclayer/applicationContext-svclayer.xml classpath:/org/opennms/web/rest/applicationContext-mockEventProxy.xml classpath:/applicationContext-jersey-test.xml classpath:/META-INF/opennms/applicationContext-reporting.xml classpath:/META-INF/opennms/applicationContext-mock-usergroup.xml classpath:/META-INF/opennms/applicationContext-minimal-conf.xml /WEB-INF/applicationContext-spring-security.xml /WEB-INF/applicationContext-jersey.xml");
        this.getServletContext().addInitParameter("parentContextKey", "daoContext");
        ServletContextEvent e = new ServletContextEvent((ServletContext)this.getServletContext());
        this.setContextListener(new ContextLoaderListener());
        this.getContextListener().contextInitialized(e);
        this.getServletContext().setContextPath(this.contextPath);
        this.setServletConfig(new MockServletConfig((ServletContext)this.getServletContext(), "dispatcher"));
        this.getServletConfig().addInitParameter("com.sun.jersey.config.property.resourceConfigClass", "com.sun.jersey.api.core.PackagesResourceConfig");
        this.getServletConfig().addInitParameter("com.sun.jersey.config.property.packages", "org.opennms.web.rest");
        try {
            MockFilterConfig filterConfig = new MockFilterConfig((ServletContext)this.getServletContext(), "openSessionInViewFilter");
            this.setFilter((Filter)new OpenSessionInViewFilter());
            this.getFilter().init((FilterConfig)filterConfig);
            this.setDispatcher((ServletContainer)new SpringServlet());
            this.getDispatcher().init((ServletConfig)this.getServletConfig());
        }
        catch (ServletException se) {
            throw se.getRootCause();
        }
        this.setWebAppContext(WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext()));
        this.afterServletStart();
        System.err.println("------------------------------------------------------------------------------");
    }

    protected void cleanUpImports() {
        Iterator fileIterator = FileUtils.iterateFiles((File)new File("target/test/opennms-home/etc/imports"), null, (boolean)true);
        while (fileIterator.hasNext()) {
            ((File)fileIterator.next()).delete();
        }
    }

    protected MockServletContext getServletContext() {
        return this.servletContext;
    }

    protected void beforeServletStart() throws Exception {
    }

    protected void afterServletStart() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        System.err.println("------------------------------------------------------------------------------");
        this.beforeServletDestroy();
        this.getContextListener().contextDestroyed(new ServletContextEvent((ServletContext)this.getServletContext()));
        if (this.getDispatcher() != null) {
            this.getDispatcher().destroy();
        }
        this.afterServletDestroy();
    }

    protected void beforeServletDestroy() throws Exception {
    }

    protected void afterServletDestroy() throws Exception {
    }

    protected void dispatch(MockHttpServletRequest request, MockHttpServletResponse response) throws Exception {
        FilterChain filterChain = new FilterChain(){

            public void doFilter(ServletRequest filterRequest, ServletResponse filterResponse) throws IOException, ServletException {
                AbstractSpringJerseyRestTestCase.this.getDispatcher().service(filterRequest, filterResponse);
            }
        };
        if (this.getFilter() != null) {
            this.getFilter().doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
        }
    }

    protected MockHttpServletResponse createResponse() {
        return new MockHttpServletResponse();
    }

    protected MockHttpServletRequest createRequest(String requestType, String urlPath) {
        MockHttpServletRequest request = new MockHttpServletRequest((ServletContext)this.getServletContext(), requestType, this.contextPath + urlPath){

            public void setContentType(String contentType) {
                super.setContentType(contentType);
                super.addHeader("Content-Type", (Object)contentType);
            }
        };
        request.setContextPath(this.contextPath);
        MockUserPrincipal.setName(this.m_username);
        request.setUserPrincipal(MockUserPrincipal.getInstance());
        if (this.m_username != null) {
            request.setRemoteUser(this.m_username);
            for (String role : this.m_roles) {
                request.addUserRole(role);
            }
        }
        return request;
    }

    protected void setUser(String user) {
        this.m_username = user;
    }

    protected String getUser() {
        return this.m_username;
    }

    protected Collection<String> getUserRoles() {
        return Collections.unmodifiableSet(new HashSet<String>(this.m_roles));
    }

    protected void addUserRole(String role) {
        this.m_roles.add(role);
    }

    protected void clearUserInfo() {
        this.m_username = "admin";
        this.m_roles.clear();
    }

    protected MockHttpServletResponse sendPost(String url, String xml) throws Exception {
        return this.sendData(POST, "application/xml", url, xml, 303);
    }

    protected MockHttpServletResponse sendPost(String url, String xml, int statusCode) throws Exception {
        return this.sendData(POST, "application/xml", url, xml, statusCode);
    }

    protected MockHttpServletResponse sendPost(String url, String xml, int statusCode, String expectedUrlSuffix) throws Exception {
        LogUtils.debugf((Object)this, (String)"POST %s, expected status code = %d, expected URL suffix = %s", (Object[])new Object[]{url, statusCode, expectedUrlSuffix});
        MockHttpServletResponse response = this.sendData(POST, "application/xml", url, xml, statusCode);
        if (expectedUrlSuffix != null) {
            Object header = response.getHeader("Location");
            Assert.assertNotNull((Object)header);
            String location = header.toString();
            Assert.assertTrue((String)("location '" + location + "' should end with '" + expectedUrlSuffix + "'"), (boolean)location.endsWith(expectedUrlSuffix));
        }
        return response;
    }

    protected MockHttpServletResponse sendPut(String url, String formData) throws Exception {
        return this.sendData(PUT, "application/x-www-form-urlencoded", url, formData, 303);
    }

    protected MockHttpServletResponse sendPut(String url, String formData, int statusCode) throws Exception {
        return this.sendData(PUT, "application/x-www-form-urlencoded", url, formData, statusCode);
    }

    protected MockHttpServletResponse sendPut(String url, String formData, int statusCode, String expectedUrlSuffix) throws Exception {
        LogUtils.debugf((Object)this, (String)"PUT %s, formData = %s, expected status code = %d, expected URL suffix = %s", (Object[])new Object[]{url, formData, statusCode, expectedUrlSuffix});
        MockHttpServletResponse response = this.sendData(PUT, "application/x-www-form-urlencoded", url, formData, statusCode);
        if (expectedUrlSuffix != null) {
            String location = response.getHeader("Location").toString();
            Assert.assertTrue((String)("location '" + location + "' should end with '" + expectedUrlSuffix + "'"), (boolean)location.endsWith(expectedUrlSuffix));
        }
        return response;
    }

    protected MockHttpServletResponse sendData(String requestType, String contentType, String url, String data) throws Exception {
        return this.sendData(requestType, contentType, url, data, 200);
    }

    protected MockHttpServletResponse sendData(String requestType, String contentType, String url, String data, int statusCode) throws Exception {
        MockHttpServletRequest request = this.createRequest(requestType, url);
        request.setContentType(contentType);
        if (contentType.equals("application/x-www-form-urlencoded")) {
            request.setParameters(AbstractSpringJerseyRestTestCase.parseParamData(data));
            request.setContent(new byte[0]);
        } else {
            request.setContent(data.getBytes());
        }
        MockHttpServletResponse response = this.createResponse();
        this.dispatch(request, response);
        LogUtils.debugf((Object)this, (String)"Received response: %s", (Object[])new Object[]{this.stringifyResponse(response)});
        Assert.assertEquals((String)response.getErrorMessage(), (long)statusCode, (long)response.getStatus());
        return response;
    }

    protected String stringifyResponse(MockHttpServletResponse response) {
        StringBuilder string = new StringBuilder();
        try {
            string.append("HttpServletResponse[").append("status=").append(response.getStatus()).append(",content=").append(response.getContentAsString()).append(",headers=[");
            boolean first = true;
            Iterator i = response.getHeaderNames().iterator();
            while (i.hasNext()) {
                if (!first) {
                    string.append(",");
                }
                String name = (String)i.next();
                string.append("name=").append(response.getHeader(name));
                first = false;
            }
            string.append("]").append("]");
        }
        catch (UnsupportedEncodingException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"Unable to get response content", (Object[])new Object[0]);
        }
        return string.toString();
    }

    protected static Map<String, String> parseParamData(String data) throws UnsupportedEncodingException {
        HashMap<String, String> retVal = new HashMap<String, String>();
        for (String item : data.split("&")) {
            int idx = item.indexOf("=");
            if (idx <= 0) continue;
            retVal.put(URLDecoder.decode(item.substring(0, idx), "UTF-8"), URLDecoder.decode(item.substring(idx + 1), "UTF-8"));
        }
        return retVal;
    }

    protected String sendRequest(String requestType, String url, Map<?, ?> parameters, int expectedStatus) throws Exception {
        return this.sendRequest(requestType, url, parameters, expectedStatus, null);
    }

    protected String sendRequest(String requestType, String url, Map<?, ?> parameters, int expectedStatus, String expectedUrlSuffix) throws Exception {
        MockHttpServletRequest request = this.createRequest(requestType, url);
        request.setParameters(parameters);
        request.setQueryString(this.getQueryString(parameters));
        return this.sendRequest(request, expectedStatus, expectedUrlSuffix);
    }

    protected String getQueryString(Map<?, ?> parameters) {
        StringBuffer sb = new StringBuffer();
        try {
            for (Object key : parameters.keySet()) {
                if (key instanceof String) {
                    Object value = parameters.get(key);
                    String[] valueEntries = null;
                    if (value instanceof String[]) {
                        valueEntries = (String[])value;
                    } else if (value instanceof String) {
                        valueEntries = new String[]{(String)value};
                    } else {
                        LogUtils.warnf((Object)this, (String)"value was not a string or string array! (%s)", (Object[])new Object[]{value});
                        continue;
                    }
                    for (String valueEntry : valueEntries) {
                        sb.append(URLEncoder.encode((String)key, "UTF-8")).append("=").append(URLEncoder.encode(valueEntry, "UTF-8")).append("&");
                    }
                    continue;
                }
                LogUtils.warnf((Object)this, (String)"key was not a string! (%s)", (Object[])new Object[]{key});
            }
        }
        catch (UnsupportedEncodingException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"unsupported encoding UTF-8?!?  WTF??!", (Object[])new Object[0]);
        }
        return sb.toString();
    }

    protected String sendRequest(String requestType, String url, int expectedStatus) throws Exception {
        MockHttpServletRequest request = this.createRequest(requestType, url);
        return this.sendRequest(request, expectedStatus);
    }

    protected String sendRequest(MockHttpServletRequest request, int expectedStatus) throws Exception, UnsupportedEncodingException {
        return this.sendRequest(request, expectedStatus, null);
    }

    protected String sendRequest(MockHttpServletRequest request, int expectedStatus, String expectedUrlSuffix) throws Exception, UnsupportedEncodingException {
        MockHttpServletResponse response = this.createResponse();
        this.dispatch(request, response);
        String xml = response.getContentAsString();
        if (xml != null && !xml.isEmpty()) {
            try {
                System.err.println(StringUtils.prettyXml((String)xml));
            }
            catch (Exception e) {
                System.err.println(xml);
            }
        }
        Assert.assertEquals((long)expectedStatus, (long)response.getStatus());
        if (expectedUrlSuffix != null) {
            String location = response.getHeader("Location").toString();
            Assert.assertTrue((String)("location '" + location + "' should end with '" + expectedUrlSuffix + "'"), (boolean)location.endsWith(expectedUrlSuffix));
        }
        Thread.sleep(50L);
        return xml;
    }

    protected <T> T getXmlObject(JAXBContext context, String url, int expectedStatus, Class<T> expectedClass) throws Exception {
        MockHttpServletRequest request = this.createRequest(GET, url);
        MockHttpServletResponse response = this.createResponse();
        this.dispatch(request, response);
        Assert.assertEquals((long)expectedStatus, (long)response.getStatus());
        System.err.printf("xml: %s\n", response.getContentAsString());
        ByteArrayInputStream in = new ByteArrayInputStream(response.getContentAsByteArray());
        Unmarshaller unmarshaller = context.createUnmarshaller();
        T result = expectedClass.cast(unmarshaller.unmarshal((InputStream)in));
        return result;
    }

    protected void putXmlObject(JAXBContext context, String url, int expectedStatus, Object object, String expectedUrlSuffix) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal(object, (OutputStream)out);
        byte[] content = out.toByteArray();
        MockHttpServletRequest request = this.createRequest(PUT, url);
        request.setContentType("application/xml");
        request.setContent(content);
        MockHttpServletResponse response = this.createResponse();
        this.dispatch(request, response);
        Assert.assertEquals((long)expectedStatus, (long)response.getStatus());
        String location = response.getHeader("Location").toString();
        Assert.assertTrue((String)("location '" + location + "' should end with '" + expectedUrlSuffix + "'"), (boolean)location.endsWith(expectedUrlSuffix));
    }

    protected void createNode() throws Exception {
        String node = "<node label=\"TestMachine\"><labelSource>H</labelSource><sysContact>The Owner</sysContact><sysDescription>Darwin TestMachine 9.4.0 Darwin Kernel Version 9.4.0: Mon Jun  9 19:30:53 PDT 2008; root:xnu-1228.5.20~1/RELEASE_I386 i386</sysDescription><sysLocation>DevJam</sysLocation><sysName>TestMachine</sysName><sysObjectId>.1.3.6.1.4.1.8072.3.2.255</sysObjectId><type>A</type></node>";
        this.sendPost("/nodes", node, 303, "/nodes/1");
    }

    protected void createIpInterface() throws Exception {
        this.createNode();
        String ipInterface = "<ipInterface isManaged=\"M\" snmpPrimary=\"P\"><ipAddress>10.10.10.10</ipAddress><hostName>TestMachine</hostName><ipStatus>1</ipStatus></ipInterface>";
        this.sendPost("/nodes/1/ipinterfaces", ipInterface, 303, "/nodes/1/ipinterfaces/10.10.10.10");
    }

    protected void createSnmpInterface() throws Exception {
        this.createIpInterface();
        String snmpInterface = "<snmpInterface ifIndex=\"6\"><ifAdminStatus>1</ifAdminStatus><ifDescr>en1</ifDescr><ifName>en1</ifName><ifOperStatus>1</ifOperStatus><ifSpeed>10000000</ifSpeed><ifType>6</ifType><netMask>255.255.255.0</netMask><physAddr>001e5271136d</physAddr></snmpInterface>";
        this.sendPost("/nodes/1/snmpinterfaces", snmpInterface, 303, "/nodes/1/snmpinterfaces/6");
    }

    protected void createService() throws Exception {
        this.createIpInterface();
        String service = "<service source=\"P\" status=\"N\"><notify>Y</notify><serviceType><name>ICMP</name></serviceType></service>";
        this.sendPost("/nodes/1/ipinterfaces/10.10.10.10/services", service, 303, "/nodes/1/ipinterfaces/10.10.10.10/services/ICMP");
    }

    protected void createCategory() throws Exception {
        this.createNode();
        String service = "<category name=\"Routers\"><description>Core Routers</description></category>";
        this.sendPost("/nodes/1/categories", service, 303, "/nodes/1/categories/Routers");
    }

    public void setWebAppContext(WebApplicationContext webAppContext) {
        this.m_webAppContext = webAppContext;
    }

    public WebApplicationContext getWebAppContext() {
        return this.m_webAppContext;
    }

    public <T> T getBean(String name, Class<T> beanClass) {
        return (T)this.m_webAppContext.getBean(name, beanClass);
    }

    public void setServletContext(MockServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setContextListener(ContextLoaderListener contextListener) {
        this.contextListener = contextListener;
    }

    public ContextLoaderListener getContextListener() {
        return this.contextListener;
    }

    public void setServletConfig(MockServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public MockServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setDispatcher(ServletContainer dispatcher) {
        this.dispatcher = dispatcher;
    }

    public ServletContainer getDispatcher() {
        return this.dispatcher;
    }
}

