/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.vulnerability.filter;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.opennms.web.vulnerability.filter.Filter;

public class InterfaceFilter
implements Filter {
    public static final String TYPE = "interface";
    protected String ipAddress;

    public InterfaceFilter(String ipAddress) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        this.ipAddress = ipAddress;
    }

    @Override
    public String getSql() {
        return " IPADDR='" + this.ipAddress + "'";
    }

    @Override
    public String getParamSql() {
        return " IPADDR=?";
    }

    @Override
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        ps.setString(parameterIndex, this.ipAddress);
        return 1;
    }

    @Override
    public String getDescription() {
        return "interface=" + this.ipAddress;
    }

    @Override
    public String getTextDescription() {
        return "IP address is " + this.ipAddress;
    }

    public String toString() {
        return "<Vulnerability Interface Filter: " + this.getDescription() + ">";
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }
}

