/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import org.opennms.web.svclayer.SecurityContextService;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.userdetails.UserDetails;

public class SpringSecurityContextService
implements SecurityContextService {
    private SecurityContext m_context = SecurityContextHolder.getContext();

    @Override
    public String getUsername() {
        return this.getUserDetails().getUsername();
    }

    @Override
    public String getPassword() {
        return this.getUserDetails().getPassword();
    }

    private UserDetails getUserDetails() {
        Object principal = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        UserDetails userDetails = null;
        if (principal instanceof UserDetails) {
            userDetails = (UserDetails)principal;
        }
        return userDetails;
    }

    @Override
    public boolean hasRole(String role) {
        GrantedAuthority[] authorities;
        boolean hasRole = false;
        UserDetails userDetails = this.getUserDetails();
        if (userDetails != null && this.isRolePresent(authorities = userDetails.getAuthorities(), role)) {
            hasRole = true;
        }
        return hasRole;
    }

    @Override
    public boolean isAuthenticated() {
        return this.m_context.getAuthentication().isAuthenticated();
    }

    private boolean isRolePresent(GrantedAuthority[] authorities, String role) {
        GrantedAuthority grantedAuthority;
        boolean isRolePresent = false;
        GrantedAuthority[] arr$ = authorities;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(isRolePresent = (grantedAuthority = arr$[i$]).getAuthority().equals(role)); ++i$) {
        }
        return isRolePresent;
    }
}

