/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.web.svclayer.KscReportService;
import org.opennms.web.svclayer.ResourceService;
import org.opennms.web.svclayer.support.DefaultGraphResultsService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultKscReportService
implements KscReportService,
InitializingBean {
    private ResourceService m_resourceService;
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private static final LinkedHashMap<String, String> s_timeSpans = new LinkedHashMap();
    private static final LinkedHashMap<String, String> s_timeSpansWithNone = new LinkedHashMap();

    @Override
    public Report buildDomainReport(String domain) {
        String resourceId = OnmsResource.createResourceId((String[])new String[]{"domain", domain});
        OnmsResource node = this.getResourceService().getResourceById(resourceId);
        return DefaultKscReportService.buildResourceReport(this.getResourceService(), node, "Domain Report for Domain " + domain);
    }

    @Override
    public Report buildNodeReport(int node_id) {
        String resourceId = OnmsResource.createResourceId((String[])new String[]{"node", Integer.toString(node_id)});
        OnmsResource node = this.getResourceService().getResourceById(resourceId);
        return DefaultKscReportService.buildResourceReport(this.getResourceService(), node, "Node Report for Node Number " + node_id);
    }

    private static Report buildResourceReport(ResourceService service, OnmsResource parentResource, String title) {
        Report report = new Report();
        report.setTitle(title);
        report.setShow_timespan_button(true);
        report.setShow_graphtype_button(true);
        List<OnmsResource> resources = service.findChildResources(parentResource, "interfaceSnmp");
        for (OnmsResource resource : resources) {
            PrefabGraph[] graphs = service.findPrefabGraphsForResource(resource);
            if (graphs.length == 0) continue;
            Graph graph = new Graph();
            graph.setTitle("");
            graph.setResourceId(resource.getId());
            graph.setTimespan("7_day");
            graph.setGraphtype(graphs[0].getName());
            report.addGraph(graph);
        }
        return report;
    }

    private static String getResourceIdForGraph(Graph graph) {
        String resourceId;
        Assert.notNull((Object)graph, (String)"graph argument cannot be null");
        if (graph.getResourceId() != null) {
            resourceId = graph.getResourceId();
        } else {
            String resourceName;
            String resourceTypeName;
            String parentResourceName;
            String parentResourceTypeName;
            if (graph.getNodeId() != null && !graph.getNodeId().equals("null")) {
                parentResourceTypeName = "node";
                parentResourceName = graph.getNodeId();
            } else if (graph.getDomain() != null && !graph.getDomain().equals("null")) {
                parentResourceTypeName = "domain";
                parentResourceName = graph.getDomain();
            } else {
                throw new IllegalArgumentException("Graph does not have a resourceId, nodeId, or domain.");
            }
            String intf = graph.getInterfaceId();
            if (intf == null || "".equals(intf)) {
                resourceTypeName = "nodeSnmp";
                resourceName = "";
            } else {
                resourceTypeName = "interfaceSnmp";
                resourceName = intf;
            }
            resourceId = OnmsResource.createResourceId((String[])new String[]{parentResourceTypeName, parentResourceName, resourceTypeName, resourceName});
        }
        return resourceId;
    }

    @Override
    public OnmsResource getResourceFromGraph(Graph graph) {
        return this.getResourceService().getResourceById(DefaultKscReportService.getResourceIdForGraph(graph));
    }

    @Override
    public List<OnmsResource> getResourcesFromGraphs(List<Graph> graphs) {
        Assert.notNull(graphs, (String)"graph argument cannot be null");
        LinkedList<OnmsResource> resources = new LinkedList<OnmsResource>();
        HashMap<String, List<OnmsResource>> resourcesMap = new HashMap<String, List<OnmsResource>>();
        block2: for (Graph graph : graphs) {
            String resourceId = DefaultKscReportService.getResourceIdForGraph(graph);
            if (resourceId == null) continue;
            String[] resourceParts = DefaultGraphResultsService.parseResourceId(resourceId);
            if (resourceParts == null) {
                DefaultKscReportService.log().warn("getResourcesFromGraphs: unparsable resourceId, skipping: " + resourceId);
                continue;
            }
            String parent = resourceParts[0];
            String childType = resourceParts[1];
            String childName = resourceParts[2];
            List<OnmsResource> resourcesForParent = (List<OnmsResource>)resourcesMap.get(parent);
            if (resourcesForParent == null) {
                try {
                    resourcesForParent = this.getResourceService().getResourceListById(resourceId);
                    if (resourcesForParent == null) {
                        DefaultKscReportService.log().warn("getResourcesFromGraphs: no resources found for parent " + parent);
                        continue;
                    }
                    resourcesMap.put(parent, resourcesForParent);
                    DefaultKscReportService.log().debug("getResourcesFromGraphs: add resourceList to map for " + parent);
                }
                catch (Throwable e) {
                    DefaultKscReportService.log().warn("getResourcesFromGraphs: unexpected exception thrown while fetching resource list for \"" + parent + "\", skipping resource", e);
                    continue;
                }
            }
            for (OnmsResource r : resourcesForParent) {
                if (!childType.equals(r.getResourceType().getName()) || !childName.equals(r.getName())) continue;
                resources.add(r);
                DefaultKscReportService.log().debug("getResourcesFromGraphs: found resource in map" + r.toString());
                continue block2;
            }
        }
        return resources;
    }

    private void initTimeSpans() {
        for (String timeSpan : KSC_PerformanceReportFactory.TIMESPAN_OPTIONS) {
            s_timeSpans.put(timeSpan, timeSpan);
        }
        s_timeSpansWithNone.put("none", "none");
        s_timeSpansWithNone.putAll(s_timeSpans);
    }

    @Override
    public Map<String, String> getTimeSpans(boolean includeNone) {
        if (includeNone) {
            return s_timeSpansWithNone;
        }
        return s_timeSpans;
    }

    @Override
    public Map<Integer, String> getReportList() {
        return this.m_kscReportFactory.getReportList();
    }

    public ResourceService getResourceService() {
        return this.m_resourceService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.m_resourceService = resourceService;
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_resourceService != null ? 1 : 0) != 0, (String)"resourceService property has not been set");
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"kscReportFactory property has not been set");
        this.initTimeSpans();
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(DefaultKscReportService.class);
    }
}

