/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.beans.PropertyEditor;
import java.text.ParseException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.joda.time.Duration;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.StringIntervalPropertyEditor;
import org.opennms.netmgt.provision.persist.foreignsource.DetectorCollection;
import org.opennms.netmgt.provision.persist.foreignsource.DetectorWrapper;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSourceCollection;
import org.opennms.netmgt.provision.persist.foreignsource.PluginConfig;
import org.opennms.netmgt.provision.persist.foreignsource.PolicyCollection;
import org.opennms.netmgt.provision.persist.foreignsource.PolicyWrapper;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="foreignSources")
public class ForeignSourceRestService
extends OnmsRestService {
    @Autowired
    @Qualifier(value="pending")
    private ForeignSourceRepository m_pendingForeignSourceRepository;
    @Autowired
    @Qualifier(value="deployed")
    private ForeignSourceRepository m_deployedForeignSourceRepository;
    @Context
    UriInfo m_uriInfo;
    @Context
    HttpHeaders m_headers;
    @Context
    SecurityContext m_securityContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="default")
    @Produces(value={"application/xml", "application/json"})
    public ForeignSource getDefaultForeignSource() throws ParseException {
        this.readLock();
        try {
            ForeignSource foreignSource = this.m_deployedForeignSourceRepository.getDefaultForeignSource();
            return foreignSource;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="deployed")
    public ForeignSourceCollection getDeployedForeignSources() throws ParseException {
        this.readLock();
        try {
            ForeignSourceCollection foreignSourceCollection = new ForeignSourceCollection((Collection)this.m_deployedForeignSourceRepository.getForeignSources());
            return foreignSourceCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="deployed/count")
    @Produces(value={"text/plain"})
    public String getDeployedCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_pendingForeignSourceRepository.getForeignSourceCount());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    public ForeignSourceCollection getForeignSources() throws ParseException {
        this.readLock();
        try {
            TreeSet<ForeignSource> foreignSources = new TreeSet<ForeignSource>();
            for (String fsName : this.getActiveForeignSourceNames()) {
                foreignSources.add(this.getActiveForeignSource(fsName));
            }
            ForeignSourceCollection foreignSourceCollection = new ForeignSourceCollection(foreignSources);
            return foreignSourceCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="count")
    @Produces(value={"text/plain"})
    public String getTotalCount() throws ParseException {
        this.readLock();
        try {
            String string = Integer.toString(this.getActiveForeignSourceNames().size());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}")
    @Produces(value={"application/xml", "application/json"})
    public ForeignSource getForeignSource(@PathParam(value="foreignSource") String foreignSource) {
        this.readLock();
        try {
            ForeignSource foreignSource2 = this.getActiveForeignSource(foreignSource);
            return foreignSource2;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/detectors")
    @Produces(value={"application/xml", "application/json"})
    public DetectorCollection getDetectors(@PathParam(value="foreignSource") String foreignSource) {
        this.readLock();
        try {
            DetectorCollection detectorCollection = new DetectorCollection((Collection)this.getActiveForeignSource(foreignSource).getDetectors());
            return detectorCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/detectors/{detector}")
    @Produces(value={"application/xml", "application/json"})
    public DetectorWrapper getDetector(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="detector") String detector) {
        this.readLock();
        try {
            for (PluginConfig pc : this.getActiveForeignSource(foreignSource).getDetectors()) {
                if (!pc.getName().equals(detector)) continue;
                DetectorWrapper detectorWrapper = new DetectorWrapper(pc);
                return detectorWrapper;
            }
            DetectorWrapper detectorWrapper = null;
            return detectorWrapper;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/policies")
    @Produces(value={"application/xml", "application/json"})
    public PolicyCollection getPolicies(@PathParam(value="foreignSource") String foreignSource) {
        this.readLock();
        try {
            PolicyCollection policyCollection = new PolicyCollection((Collection)this.getActiveForeignSource(foreignSource).getPolicies());
            return policyCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{foreignSource}/policies/{policy}")
    @Produces(value={"application/xml", "application/json"})
    public PolicyWrapper getPolicy(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="policy") String policy) {
        this.readLock();
        try {
            for (PluginConfig pc : this.getActiveForeignSource(foreignSource).getPolicies()) {
                if (!pc.getName().equals(policy)) continue;
                PolicyWrapper policyWrapper = new PolicyWrapper(pc);
                return policyWrapper;
            }
            PolicyWrapper policyWrapper = null;
            return policyWrapper;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addForeignSource(ForeignSource foreignSource) {
        this.writeLock();
        try {
            this.log().debug("addForeignSource: Adding foreignSource " + foreignSource.getName());
            this.m_pendingForeignSourceRepository.save(foreignSource);
            Response response = Response.ok((Object)foreignSource).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{foreignSource}/detectors")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addDetector(@PathParam(value="foreignSource") String foreignSource, DetectorWrapper detector) {
        this.writeLock();
        try {
            this.log().debug("addDetector: Adding detector " + detector.getName());
            ForeignSource fs = this.getActiveForeignSource(foreignSource);
            fs.addDetector((PluginConfig)detector);
            this.m_pendingForeignSourceRepository.save(fs);
            Response response = Response.ok((Object)detector).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{foreignSource}/policies")
    @Consumes(value={"application/xml"})
    @Transactional
    public Response addPolicy(@PathParam(value="foreignSource") String foreignSource, PolicyWrapper policy) {
        this.writeLock();
        try {
            this.log().debug("addPolicy: Adding policy " + policy.getName());
            ForeignSource fs = this.getActiveForeignSource(foreignSource);
            fs.addPolicy((PluginConfig)policy);
            this.m_pendingForeignSourceRepository.save(fs);
            Response response = Response.ok((Object)policy).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{foreignSource}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateForeignSource(@PathParam(value="foreignSource") String foreignSource, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            ForeignSource fs = this.getActiveForeignSource(foreignSource);
            this.log().debug("updateForeignSource: updating foreign source " + foreignSource);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)fs);
            wrapper.registerCustomEditor(Duration.class, (PropertyEditor)new StringIntervalPropertyEditor());
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                Object value = null;
                String stringValue = params.getFirst(key);
                value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            this.log().debug("updateForeignSource: foreign source " + foreignSource + " updated");
            this.m_pendingForeignSourceRepository.save(fs);
            Response response = Response.ok((Object)fs).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{foreignSource}")
    @Transactional
    public Response deletePendingForeignSource(@PathParam(value="foreignSource") String foreignSource) {
        this.writeLock();
        try {
            ForeignSource fs = this.getForeignSource(foreignSource);
            this.log().debug("deletePendingForeignSource: deleting foreign source " + foreignSource);
            this.m_pendingForeignSourceRepository.delete(fs);
            Response response = Response.ok((Object)fs).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="deployed/{foreignSource}")
    @Transactional
    public Response deleteDeployedForeignSource(@PathParam(value="foreignSource") String foreignSource) {
        this.writeLock();
        try {
            ForeignSource fs = this.getForeignSource(foreignSource);
            this.log().debug("deleteDeployedForeignSource: deleting foreign source " + foreignSource);
            this.m_deployedForeignSourceRepository.delete(fs);
            Response response = Response.ok((Object)fs).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{foreignSource}/detectors/{detector}")
    @Transactional
    public Response deleteDetector(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="detector") String detector) {
        this.writeLock();
        try {
            ForeignSource fs = this.getActiveForeignSource(foreignSource);
            List detectors = fs.getDetectors();
            PluginConfig removed = this.removeEntry(detectors, detector);
            if (removed != null) {
                fs.setDetectors(detectors);
                this.m_pendingForeignSourceRepository.save(fs);
                Response response = Response.ok((Object)removed).build();
                return response;
            }
            Response response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{foreignSource}/policies/{policy}")
    @Transactional
    public Response deletePolicy(@PathParam(value="foreignSource") String foreignSource, @PathParam(value="policy") String policy) {
        this.writeLock();
        try {
            ForeignSource fs = this.getActiveForeignSource(foreignSource);
            List policies = fs.getPolicies();
            PluginConfig removed = this.removeEntry(policies, policy);
            if (removed != null) {
                fs.setPolicies(policies);
                this.m_pendingForeignSourceRepository.save(fs);
                Response response = Response.ok((Object)removed).build();
                return response;
            }
            Response response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private PluginConfig removeEntry(List<PluginConfig> plugins, String name) {
        PluginConfig removed = null;
        Iterator<PluginConfig> i = plugins.iterator();
        while (i.hasNext()) {
            PluginConfig pc = i.next();
            if (!pc.getName().equals(name)) continue;
            removed = pc;
            i.remove();
            break;
        }
        return removed;
    }

    private Set<String> getActiveForeignSourceNames() {
        Set fsNames = this.m_pendingForeignSourceRepository.getActiveForeignSourceNames();
        fsNames.addAll(this.m_deployedForeignSourceRepository.getActiveForeignSourceNames());
        return fsNames;
    }

    private ForeignSource getActiveForeignSource(String foreignSourceName) {
        ForeignSource fs = this.m_pendingForeignSourceRepository.getForeignSource(foreignSourceName);
        if (fs.isDefault()) {
            return this.m_deployedForeignSourceRepository.getForeignSource(foreignSourceName);
        }
        return fs;
    }
}

