/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest;

import com.sun.jersey.spi.resource.PerRequest;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventCollection;
import org.opennms.web.rest.MultivaluedMapImpl;
import org.opennms.web.rest.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@PerRequest
@Scope(value="prototype")
@Path(value="events")
public class EventRestService
extends OnmsRestService {
    @Autowired
    private EventDao m_eventDao;
    @Context
    UriInfo m_uriInfo;
    @Context
    HttpHeaders m_headers;
    @Context
    SecurityContext m_securityContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{eventId}")
    @Transactional
    public OnmsEvent getEvent(@PathParam(value="eventId") String eventId) {
        this.readLock();
        try {
            OnmsEvent onmsEvent = (OnmsEvent)this.m_eventDao.get((Serializable)new Integer(eventId));
            return onmsEvent;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        this.readLock();
        try {
            String string = Integer.toString(this.m_eventDao.countAll());
            return string;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Transactional
    public OnmsEventCollection getEvents() throws ParseException {
        this.readLock();
        try {
            CriteriaBuilder builder = new CriteriaBuilder(OnmsEvent.class);
            this.applyQueryFilters((MultivaluedMap<String, String>)this.m_uriInfo.getQueryParameters(), builder);
            OnmsEventCollection coll = new OnmsEventCollection((Collection)this.m_eventDao.findMatching(builder.toCriteria()));
            coll.setTotalCount(this.m_eventDao.countMatching(builder.clearOrder().toCriteria()));
            OnmsEventCollection onmsEventCollection = coll;
            return onmsEventCollection;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{eventId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public void updateEvent(@PathParam(value="eventId") String eventId, @FormParam(value="ack") Boolean ack) {
        this.writeLock();
        try {
            OnmsEvent event = (OnmsEvent)this.m_eventDao.get((Serializable)new Integer(eventId));
            if (ack == null) {
                throw new IllegalArgumentException("Must supply the 'ack' parameter, set to either 'true' or 'false'");
            }
            this.processEventAck(event, ack);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public void updateEvents(MultivaluedMapImpl formProperties) {
        this.writeLock();
        try {
            Boolean ack = false;
            if (formProperties.containsKey("ack")) {
                ack = "true".equals(formProperties.getFirst("ack"));
                formProperties.remove("ack");
            }
            CriteriaBuilder builder = new CriteriaBuilder(OnmsEvent.class);
            this.applyQueryFilters(formProperties, builder);
            builder.orderBy("eventTime").desc();
            for (OnmsEvent event : this.m_eventDao.findMatching(builder.toCriteria())) {
                this.processEventAck(event, ack);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private void processEventAck(OnmsEvent event, Boolean ack) {
        if (ack.booleanValue()) {
            event.setEventAckTime(new Date());
            event.setEventAckUser(this.m_securityContext.getUserPrincipal().getName());
        } else {
            event.setEventAckTime(null);
            event.setEventAckUser(null);
        }
        this.m_eventDao.save((Object)event);
    }
}

