/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.notification;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.opennms.core.resource.Vault;
import org.opennms.web.notification.NoticeSentTo;
import org.opennms.web.notification.Notification;

public class NotificationModel {
    private final String USERID = "userID";
    private final String NOTICE_TIME = "notifytime";
    private final String TXT_MESG = "textMsg";
    private final String NUM_MESG = "numericMsg";
    private final String NOTIFY = "notifyID";
    private final String TIME = "pageTime";
    private final String REPLYTIME = "respondTime";
    private final String ANS_BY = "answeredBy";
    private final String CONTACT = "contactInfo";
    private final String NODE = "nodeID";
    private final String INTERFACE = "interfaceID";
    private final String SERVICE = "serviceID";
    private final String MEDIA = "media";
    private final String EVENTID = "eventid";
    private final String SELECT = "SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid from NOTIFICATIONS";
    private final String NOTICE_ID = "SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid from NOTIFICATIONS where NOTIFYID = ?";
    private final String SENT_TO = "SELECT userid, notifytime, media, contactinfo FROM usersnotified WHERE notifyid=?";
    private final String INSERT_NOTIFY = "INSERT INTO NOTIFICATIONS (notifyid, textmsg, numericmsg, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid) VALUES (NEXTVAL('notifyNxtId'), ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private final String OUTSTANDING = "SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid FROM NOTIFICATIONS WHERE respondTime is NULL";
    private final String OUTSTANDING_COUNT = "SELECT COUNT(notifyid) AS TOTAL FROM NOTIFICATIONS WHERE respondTime is NULL";
    private final String USER_OUTSTANDING = "SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid FROM NOTIFICATIONS WHERE (respondTime is NULL) AND notifications.notifyid in (SELECT DISTINCT usersnotified.notifyid FROM usersnotified WHERE usersnotified.userid=?)";
    private final String USER_OUTSTANDING_COUNT = "SELECT COUNT(notifyid) AS TOTAL FROM NOTIFICATIONS WHERE (respondTime is NULL) AND notifications.notifyid in (SELECT DISTINCT usersnotified.notifyid FROM usersnotified WHERE usersnotified.userid=?)";

    private Logger log() {
        return Logger.getLogger(this.getClass());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Notification getNoticeInfo(int id) throws SQLException {
        Notification nbean = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection conn = Vault.getDbConnection();
        try {
            pstmt = conn.prepareStatement("SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid from NOTIFICATIONS where NOTIFYID = ?");
            pstmt.setInt(1, id);
            rs = pstmt.executeQuery();
            Notification[] n = this.rs2NotifyBean(conn, rs);
            nbean = n.length > 0 ? n[0] : new Notification();
            rs.close();
            pstmt.close();
            PreparedStatement sentTo = conn.prepareStatement("SELECT userid, notifytime, media, contactinfo FROM usersnotified WHERE notifyid=?");
            sentTo.setInt(1, id);
            ResultSet sentToResults = sentTo.executeQuery();
            ArrayList<NoticeSentTo> sentToList = new ArrayList<NoticeSentTo>();
            while (sentToResults.next()) {
                NoticeSentTo newSentTo = new NoticeSentTo();
                newSentTo.setUserId(sentToResults.getString("userID"));
                Timestamp ts = sentToResults.getTimestamp("notifytime");
                if (ts != null) {
                    newSentTo.setTime(ts.getTime());
                } else {
                    newSentTo.setTime(0L);
                }
                newSentTo.setMedia(sentToResults.getString("media"));
                newSentTo.setContactInfo(sentToResults.getString("contactInfo"));
                sentToList.add(newSentTo);
            }
            nbean.m_sentTo = sentToList;
            return nbean;
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            Vault.releaseDbConnection((Connection)conn);
        }
    }

    public Notification[] allNotifications() throws SQLException {
        return this.allNotifications(null);
    }

    public Notification[] allNotifications(String order) throws SQLException {
        Notification[] notices = null;
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            String query = "SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid from NOTIFICATIONS";
            if (order != null) {
                if (order.equalsIgnoreCase("asc")) {
                    query = query + " ORDER BY pagetime ASC";
                } else if (order.equalsIgnoreCase("desc")) {
                    query = query + " ORDER BY pagetime DESC";
                }
            }
            query = query + ";";
            ResultSet rs = stmt.executeQuery(query);
            notices = this.rs2NotifyBean(conn, rs);
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.log().error((Object)("allNotifications: Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return notices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getServiceName(Connection conn, Integer id) {
        if (id == null) {
            return null;
        }
        String serviceName = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = conn.prepareStatement("SELECT servicename from service where serviceid = ?");
            ps.setInt(1, id);
            rs = ps.executeQuery();
            if (!rs.next()) return serviceName;
            serviceName = rs.getString("servicename");
            return serviceName;
        }
        catch (SQLException e) {
            this.log().warn((Object)("unable to get service name for service ID '" + id + "'"), (Throwable)e);
            return serviceName;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                this.log().warn((Object)("unable to close result set while getting service name for service ID '" + id + "'"), (Throwable)e);
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException e) {
                    this.log().warn((Object)("unable to close prepared statement while getting service name for service ID '" + id + "'"), (Throwable)e);
                }
            }
        }
    }

    protected Notification[] rs2NotifyBean(Connection conn, ResultSet rs) throws SQLException {
        Notification[] notices = null;
        Vector<Notification> vector = new Vector<Notification>();
        try {
            while (rs.next()) {
                Notification nbean = new Notification();
                nbean.m_timeReply = 0L;
                nbean.m_txtMsg = rs.getString("textMsg");
                nbean.m_numMsg = rs.getString("numericMsg");
                nbean.m_notifyID = rs.getInt("notifyID");
                if (rs.getTimestamp("pageTime") != null) {
                    nbean.m_timeSent = rs.getTimestamp("pageTime").getTime();
                }
                if (rs.getTimestamp("respondTime") != null) {
                    nbean.m_timeReply = rs.getTimestamp("respondTime").getTime();
                }
                nbean.m_responder = rs.getString("answeredBy");
                nbean.m_nodeID = rs.getInt("nodeID");
                nbean.m_interfaceID = rs.getString("interfaceID");
                nbean.m_serviceId = rs.getInt("serviceID");
                nbean.m_eventId = rs.getInt("eventid");
                nbean.m_serviceName = this.getServiceName(conn, nbean.m_serviceId);
                vector.addElement(nbean);
            }
        }
        catch (SQLException e) {
            this.log().error((Object)("Error occurred in rs2NotifyBean: " + e), (Throwable)e);
            throw e;
        }
        notices = new Notification[vector.size()];
        for (int i = 0; i < notices.length; ++i) {
            notices[i] = (Notification)vector.elementAt(i);
        }
        return notices;
    }

    public Notification[] getOutstandingNotices() throws SQLException {
        Notification[] notices = null;
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid FROM NOTIFICATIONS WHERE respondTime is NULL");
            notices = this.rs2NotifyBean(conn, rs);
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return notices;
    }

    public int getOutstandingNoticeCount() throws SQLException {
        int count = 0;
        Connection conn = Vault.getDbConnection();
        try {
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT COUNT(notifyid) AS TOTAL FROM NOTIFICATIONS WHERE respondTime is NULL");
            if (rs.next()) {
                count = rs.getInt("TOTAL");
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return count;
    }

    public int getOutstandingNoticeCount(String username) throws SQLException {
        if (username == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        int count = 0;
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement pstmt = conn.prepareStatement("SELECT COUNT(notifyid) AS TOTAL FROM NOTIFICATIONS WHERE (respondTime is NULL) AND notifications.notifyid in (SELECT DISTINCT usersnotified.notifyid FROM usersnotified WHERE usersnotified.userid=?)");
            pstmt.setString(1, username);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt("TOTAL");
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return count;
    }

    public Notification[] getOutstandingNotices(String name) throws SQLException {
        Notification[] notices = null;
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement pstmt = conn.prepareStatement("SELECT textmsg, numericmsg, notifyid, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid FROM NOTIFICATIONS WHERE (respondTime is NULL) AND notifications.notifyid in (SELECT DISTINCT usersnotified.notifyid FROM usersnotified WHERE usersnotified.userid=?)");
            pstmt.setString(1, name);
            ResultSet rs = pstmt.executeQuery();
            notices = this.rs2NotifyBean(conn, rs);
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
        return notices;
    }

    public void acknowledged(String name, int noticeId) throws SQLException {
        if (name == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement pstmt = conn.prepareStatement("UPDATE notifications SET respondtime = ? , answeredby = ? WHERE notifyid= ?");
            pstmt.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            pstmt.setString(2, name);
            pstmt.setInt(3, noticeId);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem acknowledging notification " + noticeId + " as answered by '" + name + "': " + e), (Throwable)e);
            throw e;
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
    }

    public void insert(Notification nbean) throws SQLException {
        if (nbean == null || nbean.m_txtMsg == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Connection conn = Vault.getDbConnection();
        try {
            PreparedStatement pstmt = conn.prepareStatement("INSERT INTO NOTIFICATIONS (notifyid, textmsg, numericmsg, pagetime, respondtime, answeredby, nodeid, interfaceid, serviceid, eventid) VALUES (NEXTVAL('notifyNxtId'), ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            pstmt.setString(1, nbean.m_txtMsg);
            pstmt.setString(2, nbean.m_numMsg);
            pstmt.setLong(3, nbean.m_timeSent);
            pstmt.setLong(4, nbean.m_timeReply);
            pstmt.setString(5, nbean.m_responder);
            pstmt.setInt(6, nbean.m_nodeID);
            pstmt.setString(7, nbean.m_interfaceID);
            pstmt.setInt(8, nbean.m_serviceId);
            pstmt.setInt(9, nbean.m_eventId);
            pstmt.execute();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log().error((Object)("Problem getting data from the notifications table: " + e), (Throwable)e);
            throw e;
        }
        finally {
            Vault.releaseDbConnection((Connection)conn);
        }
    }
}

