/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map.view;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Command {
    private BufferedReader out;
    private Process p;
    String firstLine;
    boolean scheduledtoremove;
    int scheduletoremoverequest = 0;
    private List<String> lines = new ArrayList<String>();

    public Command(String command) throws IOException, IllegalStateException {
        if (!(command.startsWith("traceroute") || command.startsWith("ping") || command.startsWith("ipmitool"))) {
            throw new IllegalStateException("Command " + command + " not supported.");
        }
        this.p = Runtime.getRuntime().exec(command);
        this.out = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String s = null;
                    while ((s = Command.this.out.readLine()) != null) {
                        Command.this.addLineBuffer(s);
                    }
                }
                catch (IOException io) {
                    throw new IllegalStateException("Error while writing the IO buffer");
                }
            }
        }, this.getClass().getSimpleName()).start();
    }

    private synchronized void addLineBuffer(String line) {
        this.lines.add(line);
    }

    public synchronized String getNextLine() {
        this.scheduledtoremove = false;
        this.scheduletoremoverequest = 0;
        if (this.lines.size() > 0) {
            return this.lines.remove(0);
        }
        return null;
    }

    public boolean runned() {
        try {
            this.p.exitValue();
            return true;
        }
        catch (IllegalThreadStateException exc) {
            return false;
        }
    }

    public boolean scheduledToRemove() {
        return this.scheduledtoremove;
    }

    public void scheduleToRemove() {
        ++this.scheduletoremoverequest;
        if (this.scheduletoremoverequest > 2) {
            this.scheduledtoremove = true;
        }
    }
}

